/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PartAttachment {
    private final Optional<String> type;
    private final Optional<String> name;
    private final Optional<String> url;
    private final Optional<String> contentType;
    private final Optional<Integer> filesize;
    private final Optional<Integer> width;
    private final Optional<Integer> height;
    private final Map<String, Object> additionalProperties;

    private PartAttachment(Optional<String> type, Optional<String> name, Optional<String> url, Optional<String> contentType, Optional<Integer> filesize, Optional<Integer> width, Optional<Integer> height, Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.contentType = contentType;
        this.filesize = filesize;
        this.width = width;
        this.height = height;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="filesize")
    public Optional<Integer> getFilesize() {
        return this.filesize;
    }

    @JsonProperty(value="width")
    public Optional<Integer> getWidth() {
        return this.width;
    }

    @JsonProperty(value="height")
    public Optional<Integer> getHeight() {
        return this.height;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PartAttachment && this.equalTo((PartAttachment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PartAttachment other) {
        return this.type.equals(other.type) && this.name.equals(other.name) && this.url.equals(other.url) && this.contentType.equals(other.contentType) && this.filesize.equals(other.filesize) && this.width.equals(other.width) && this.height.equals(other.height);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> contentType = Optional.empty();
        private Optional<Integer> filesize = Optional.empty();
        private Optional<Integer> width = Optional.empty();
        private Optional<Integer> height = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PartAttachment other) {
            this.type(other.getType());
            this.name(other.getName());
            this.url(other.getUrl());
            this.contentType(other.getContentType());
            this.filesize(other.getFilesize());
            this.width(other.getWidth());
            this.height(other.getHeight());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @JsonSetter(value="filesize", nulls=Nulls.SKIP)
        public Builder filesize(Optional<Integer> filesize) {
            this.filesize = filesize;
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = Optional.ofNullable(filesize);
            return this;
        }

        @JsonSetter(value="width", nulls=Nulls.SKIP)
        public Builder width(Optional<Integer> width) {
            this.width = width;
            return this;
        }

        public Builder width(Integer width) {
            this.width = Optional.ofNullable(width);
            return this;
        }

        @JsonSetter(value="height", nulls=Nulls.SKIP)
        public Builder height(Optional<Integer> height) {
            this.height = height;
            return this;
        }

        public Builder height(Integer height) {
            this.height = Optional.ofNullable(height);
            return this;
        }

        public PartAttachment build() {
            return new PartAttachment(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height, this.additionalProperties);
        }
    }
}

