/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SlaApplied {
    private final Optional<String> type;
    private final Optional<String> slaName;
    private final Optional<SlaStatus> slaStatus;
    private final Map<String, Object> additionalProperties;

    private SlaApplied(Optional<String> type, Optional<String> slaName, Optional<SlaStatus> slaStatus, Map<String, Object> additionalProperties) {
        this.type = type;
        this.slaName = slaName;
        this.slaStatus = slaStatus;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="sla_name")
    public Optional<String> getSlaName() {
        return this.slaName;
    }

    @JsonProperty(value="sla_status")
    public Optional<SlaStatus> getSlaStatus() {
        return this.slaStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SlaApplied && this.equalTo((SlaApplied)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SlaApplied other) {
        return this.type.equals(other.type) && this.slaName.equals(other.slaName) && this.slaStatus.equals(other.slaStatus);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.slaName, this.slaStatus);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class SlaStatus {
        public static final SlaStatus HIT = new SlaStatus(Value.HIT, "hit");
        public static final SlaStatus CANCELLED = new SlaStatus(Value.CANCELLED, "cancelled");
        public static final SlaStatus ACTIVE = new SlaStatus(Value.ACTIVE, "active");
        public static final SlaStatus MISSED = new SlaStatus(Value.MISSED, "missed");
        private final Value value;
        private final String string;

        SlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SlaStatus && this.string.equals(((SlaStatus)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case HIT: {
                    return visitor.visitHit();
                }
                case CANCELLED: {
                    return visitor.visitCancelled();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
                case MISSED: {
                    return visitor.visitMissed();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SlaStatus valueOf(String value) {
            switch (value) {
                case "hit": {
                    return HIT;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "missed": {
                    return MISSED;
                }
            }
            return new SlaStatus(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitHit();

            public T visitMissed();

            public T visitCancelled();

            public T visitActive();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            HIT,
            MISSED,
            CANCELLED,
            ACTIVE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> slaName = Optional.empty();
        private Optional<SlaStatus> slaStatus = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SlaApplied other) {
            this.type(other.getType());
            this.slaName(other.getSlaName());
            this.slaStatus(other.getSlaStatus());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="sla_name", nulls=Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        @JsonSetter(value="sla_status", nulls=Nulls.SKIP)
        public Builder slaStatus(Optional<SlaStatus> slaStatus) {
            this.slaStatus = slaStatus;
            return this;
        }

        public Builder slaStatus(SlaStatus slaStatus) {
            this.slaStatus = Optional.ofNullable(slaStatus);
            return this;
        }

        public SlaApplied build() {
            return new SlaApplied(this.type, this.slaName, this.slaStatus, this.additionalProperties);
        }
    }
}

