/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TagCompanyRequest {
    private final String name;
    private final List<CompaniesItem> companies;
    private final Map<String, Object> additionalProperties;

    private TagCompanyRequest(String name, List<CompaniesItem> companies, Map<String, Object> additionalProperties) {
        this.name = name;
        this.companies = companies;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="companies")
    public List<CompaniesItem> getCompanies() {
        return this.companies;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TagCompanyRequest && this.equalTo((TagCompanyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagCompanyRequest other) {
        return this.name.equals(other.name) && this.companies.equals(other.companies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.companies);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class CompaniesItem {
        private final Optional<String> id;
        private final Optional<String> companyId;
        private final Map<String, Object> additionalProperties;

        private CompaniesItem(Optional<String> id, Optional<String> companyId, Map<String, Object> additionalProperties) {
            this.id = id;
            this.companyId = companyId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        @JsonProperty(value="company_id")
        public Optional<String> getCompanyId() {
            return this.companyId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CompaniesItem && this.equalTo((CompaniesItem)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(CompaniesItem other) {
            return this.id.equals(other.id) && this.companyId.equals(other.companyId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.companyId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();
            private Optional<String> companyId = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(CompaniesItem other) {
                this.id(other.getId());
                this.companyId(other.getCompanyId());
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            @JsonSetter(value="company_id", nulls=Nulls.SKIP)
            public Builder companyId(Optional<String> companyId) {
                this.companyId = companyId;
                return this;
            }

            public Builder companyId(String companyId) {
                this.companyId = Optional.ofNullable(companyId);
                return this;
            }

            public CompaniesItem build() {
                return new CompaniesItem(this.id, this.companyId, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private List<CompaniesItem> companies = new ArrayList<CompaniesItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TagCompanyRequest other) {
            this.name(other.getName());
            this.companies(other.getCompanies());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllCompanies(List<CompaniesItem> companies) {
            if (companies != null) {
                this.companies.addAll(companies);
            }
            return this;
        }

        @Override
        public _FinalStage addCompanies(CompaniesItem companies) {
            this.companies.add(companies);
            return this;
        }

        @Override
        @JsonSetter(value="companies", nulls=Nulls.SKIP)
        public _FinalStage companies(List<CompaniesItem> companies) {
            this.companies.clear();
            if (companies != null) {
                this.companies.addAll(companies);
            }
            return this;
        }

        @Override
        public TagCompanyRequest build() {
            return new TagCompanyRequest(this.name, this.companies, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TagCompanyRequest build();

        public _FinalStage companies(List<CompaniesItem> var1);

        public _FinalStage addCompanies(CompaniesItem var1);

        public _FinalStage addAllCompanies(List<CompaniesItem> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(TagCompanyRequest var1);
    }
}

