/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.teams.types.Team;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamList {
    private final Optional<String> type;
    private final Optional<List<Team>> teams;
    private final Map<String, Object> additionalProperties;

    private TeamList(Optional<String> type, Optional<List<Team>> teams, Map<String, Object> additionalProperties) {
        this.type = type;
        this.teams = teams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="teams")
    public Optional<List<Team>> getTeams() {
        return this.teams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamList && this.equalTo((TeamList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamList other) {
        return this.type.equals(other.type) && this.teams.equals(other.teams);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.teams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<Team>> teams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamList other) {
            this.type(other.getType());
            this.teams(other.getTeams());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="teams", nulls=Nulls.SKIP)
        public Builder teams(Optional<List<Team>> teams) {
            this.teams = teams;
            return this;
        }

        public Builder teams(List<Team> teams) {
            this.teams = Optional.ofNullable(teams);
            return this;
        }

        public TeamList build() {
            return new TeamList(this.type, this.teams, this.additionalProperties);
        }
    }
}

