/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aiagent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContentSourcesList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AiAgent.Builder.class)
public final class AiAgent {
    private final Optional<SourceType> sourceType;

    private final Optional<String> sourceTitle;

    private final Optional<LastAnswerType> lastAnswerType;

    private final Optional<ResolutionState> resolutionState;

    private final Optional<Integer> rating;

    private final Optional<String> ratingRemark;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<ContentSourcesList> contentSources;

    private final Map<String, Object> additionalProperties;

    private AiAgent(
            Optional<SourceType> sourceType,
            Optional<String> sourceTitle,
            Optional<LastAnswerType> lastAnswerType,
            Optional<ResolutionState> resolutionState,
            Optional<Integer> rating,
            Optional<String> ratingRemark,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<ContentSourcesList> contentSources,
            Map<String, Object> additionalProperties) {
        this.sourceType = sourceType;
        this.sourceTitle = sourceTitle;
        this.lastAnswerType = lastAnswerType;
        this.resolutionState = resolutionState;
        this.rating = rating;
        this.ratingRemark = ratingRemark;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the source that triggered AI Agent involvement in the conversation.
     */
    @JsonProperty("source_type")
    public Optional<SourceType> getSourceType() {
        return sourceType;
    }

    /**
     * @return The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.
     */
    @JsonProperty("source_title")
    public Optional<String> getSourceTitle() {
        return sourceTitle;
    }

    /**
     * @return The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code>
     */
    @JsonProperty("last_answer_type")
    public Optional<LastAnswerType> getLastAnswerType() {
        return lastAnswerType;
    }

    /**
     * @return The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.
     */
    @JsonProperty("resolution_state")
    public Optional<ResolutionState> getResolutionState() {
        return resolutionState;
    }

    /**
     * @return The customer satisfaction rating given to AI Agent, from 1-5.
     */
    @JsonProperty("rating")
    public Optional<Integer> getRating() {
        return rating;
    }

    /**
     * @return The customer satisfaction rating remark given to AI Agent.
     */
    @JsonProperty("rating_remark")
    public Optional<String> getRatingRemark() {
        return ratingRemark;
    }

    /**
     * @return The time when the AI agent rating was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the AI agent rating was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("content_sources")
    public Optional<ContentSourcesList> getContentSources() {
        return contentSources;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AiAgent && equalTo((AiAgent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiAgent other) {
        return sourceType.equals(other.sourceType)
                && sourceTitle.equals(other.sourceTitle)
                && lastAnswerType.equals(other.lastAnswerType)
                && resolutionState.equals(other.resolutionState)
                && rating.equals(other.rating)
                && ratingRemark.equals(other.ratingRemark)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && contentSources.equals(other.contentSources);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.sourceType,
                this.sourceTitle,
                this.lastAnswerType,
                this.resolutionState,
                this.rating,
                this.ratingRemark,
                this.createdAt,
                this.updatedAt,
                this.contentSources);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<SourceType> sourceType = Optional.empty();

        private Optional<String> sourceTitle = Optional.empty();

        private Optional<LastAnswerType> lastAnswerType = Optional.empty();

        private Optional<ResolutionState> resolutionState = Optional.empty();

        private Optional<Integer> rating = Optional.empty();

        private Optional<String> ratingRemark = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<ContentSourcesList> contentSources = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AiAgent other) {
            sourceType(other.getSourceType());
            sourceTitle(other.getSourceTitle());
            lastAnswerType(other.getLastAnswerType());
            resolutionState(other.getResolutionState());
            rating(other.getRating());
            ratingRemark(other.getRatingRemark());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            contentSources(other.getContentSources());
            return this;
        }

        /**
         * <p>The type of the source that triggered AI Agent involvement in the conversation.</p>
         */
        @JsonSetter(value = "source_type", nulls = Nulls.SKIP)
        public Builder sourceType(Optional<SourceType> sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = Optional.ofNullable(sourceType);
            return this;
        }

        /**
         * <p>The title of the source that triggered AI Agent involvement in the conversation. If this is <code>essentials_plan_setup</code> then it will return <code>null</code>.</p>
         */
        @JsonSetter(value = "source_title", nulls = Nulls.SKIP)
        public Builder sourceTitle(Optional<String> sourceTitle) {
            this.sourceTitle = sourceTitle;
            return this;
        }

        public Builder sourceTitle(String sourceTitle) {
            this.sourceTitle = Optional.ofNullable(sourceTitle);
            return this;
        }

        /**
         * <p>The type of the last answer delivered by AI Agent. If no answer was delivered then this will return <code>null</code></p>
         */
        @JsonSetter(value = "last_answer_type", nulls = Nulls.SKIP)
        public Builder lastAnswerType(Optional<LastAnswerType> lastAnswerType) {
            this.lastAnswerType = lastAnswerType;
            return this;
        }

        public Builder lastAnswerType(LastAnswerType lastAnswerType) {
            this.lastAnswerType = Optional.ofNullable(lastAnswerType);
            return this;
        }

        /**
         * <p>The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return <code>null</code>.</p>
         */
        @JsonSetter(value = "resolution_state", nulls = Nulls.SKIP)
        public Builder resolutionState(Optional<ResolutionState> resolutionState) {
            this.resolutionState = resolutionState;
            return this;
        }

        public Builder resolutionState(ResolutionState resolutionState) {
            this.resolutionState = Optional.ofNullable(resolutionState);
            return this;
        }

        /**
         * <p>The customer satisfaction rating given to AI Agent, from 1-5.</p>
         */
        @JsonSetter(value = "rating", nulls = Nulls.SKIP)
        public Builder rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        public Builder rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        /**
         * <p>The customer satisfaction rating remark given to AI Agent.</p>
         */
        @JsonSetter(value = "rating_remark", nulls = Nulls.SKIP)
        public Builder ratingRemark(Optional<String> ratingRemark) {
            this.ratingRemark = ratingRemark;
            return this;
        }

        public Builder ratingRemark(String ratingRemark) {
            this.ratingRemark = Optional.ofNullable(ratingRemark);
            return this;
        }

        /**
         * <p>The time when the AI agent rating was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the AI agent rating was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value = "content_sources", nulls = Nulls.SKIP)
        public Builder contentSources(Optional<ContentSourcesList> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        public Builder contentSources(ContentSourcesList contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        public AiAgent build() {
            return new AiAgent(
                    sourceType,
                    sourceTitle,
                    lastAnswerType,
                    resolutionState,
                    rating,
                    ratingRemark,
                    createdAt,
                    updatedAt,
                    contentSources,
                    additionalProperties);
        }
    }

    public static final class ResolutionState {
        public static final ResolutionState ASSUMED_RESOLUTION =
                new ResolutionState(Value.ASSUMED_RESOLUTION, "assumed_resolution");

        public static final ResolutionState ABANDONED = new ResolutionState(Value.ABANDONED, "abandoned");

        public static final ResolutionState ROUTED_TO_TEAM =
                new ResolutionState(Value.ROUTED_TO_TEAM, "routed_to_team");

        public static final ResolutionState CONFIRMED_RESOLUTION =
                new ResolutionState(Value.CONFIRMED_RESOLUTION, "confirmed_resolution");

        private final Value value;

        private final String string;

        ResolutionState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof ResolutionState && this.string.equals(((ResolutionState) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case ASSUMED_RESOLUTION:
                    return visitor.visitAssumedResolution();
                case ABANDONED:
                    return visitor.visitAbandoned();
                case ROUTED_TO_TEAM:
                    return visitor.visitRoutedToTeam();
                case CONFIRMED_RESOLUTION:
                    return visitor.visitConfirmedResolution();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ResolutionState valueOf(String value) {
            switch (value) {
                case "assumed_resolution":
                    return ASSUMED_RESOLUTION;
                case "abandoned":
                    return ABANDONED;
                case "routed_to_team":
                    return ROUTED_TO_TEAM;
                case "confirmed_resolution":
                    return CONFIRMED_RESOLUTION;
                default:
                    return new ResolutionState(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ASSUMED_RESOLUTION,

            CONFIRMED_RESOLUTION,

            ROUTED_TO_TEAM,

            ABANDONED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAssumedResolution();

            T visitConfirmedResolution();

            T visitRoutedToTeam();

            T visitAbandoned();

            T visitUnknown(String unknownType);
        }
    }

    public static final class SourceType {
        public static final SourceType WORKFLOW = new SourceType(Value.WORKFLOW, "workflow");

        public static final SourceType WORKFLOW_PREVIEW = new SourceType(Value.WORKFLOW_PREVIEW, "workflow_preview");

        public static final SourceType FIN_PREVIEW = new SourceType(Value.FIN_PREVIEW, "fin_preview");

        public static final SourceType ESSENTIALS_PLAN_SETUP =
                new SourceType(Value.ESSENTIALS_PLAN_SETUP, "essentials_plan_setup");

        public static final SourceType PROFILE = new SourceType(Value.PROFILE, "profile");

        private final Value value;

        private final String string;

        SourceType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SourceType && this.string.equals(((SourceType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case WORKFLOW:
                    return visitor.visitWorkflow();
                case WORKFLOW_PREVIEW:
                    return visitor.visitWorkflowPreview();
                case FIN_PREVIEW:
                    return visitor.visitFinPreview();
                case ESSENTIALS_PLAN_SETUP:
                    return visitor.visitEssentialsPlanSetup();
                case PROFILE:
                    return visitor.visitProfile();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SourceType valueOf(String value) {
            switch (value) {
                case "workflow":
                    return WORKFLOW;
                case "workflow_preview":
                    return WORKFLOW_PREVIEW;
                case "fin_preview":
                    return FIN_PREVIEW;
                case "essentials_plan_setup":
                    return ESSENTIALS_PLAN_SETUP;
                case "profile":
                    return PROFILE;
                default:
                    return new SourceType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ESSENTIALS_PLAN_SETUP,

            PROFILE,

            WORKFLOW,

            WORKFLOW_PREVIEW,

            FIN_PREVIEW,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEssentialsPlanSetup();

            T visitProfile();

            T visitWorkflow();

            T visitWorkflowPreview();

            T visitFinPreview();

            T visitUnknown(String unknownType);
        }
    }

    public static final class LastAnswerType {
        public static final LastAnswerType AI_ANSWER = new LastAnswerType(Value.AI_ANSWER, "ai_answer");

        public static final LastAnswerType CUSTOM_ANSWER = new LastAnswerType(Value.CUSTOM_ANSWER, "custom_answer");

        private final Value value;

        private final String string;

        LastAnswerType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof LastAnswerType && this.string.equals(((LastAnswerType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case AI_ANSWER:
                    return visitor.visitAiAnswer();
                case CUSTOM_ANSWER:
                    return visitor.visitCustomAnswer();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static LastAnswerType valueOf(String value) {
            switch (value) {
                case "ai_answer":
                    return AI_ANSWER;
                case "custom_answer":
                    return CUSTOM_ANSWER;
                default:
                    return new LastAnswerType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            AI_ANSWER,

            CUSTOM_ANSWER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAiAnswer();

            T visitCustomAnswer();

            T visitUnknown(String unknownType);
        }
    }
}
