/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetExternalPageRequest.Builder.class)
public final class GetExternalPageRequest {
    private final String pageId;

    private final Map<String, Object> additionalProperties;

    private GetExternalPageRequest(String pageId, Map<String, Object> additionalProperties) {
        this.pageId = pageId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the external page which is given by Intercom.
     */
    @JsonProperty("page_id")
    public String getPageId() {
        return pageId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetExternalPageRequest && equalTo((GetExternalPageRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetExternalPageRequest other) {
        return pageId.equals(other.pageId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.pageId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageIdStage builder() {
        return new Builder();
    }

    public interface PageIdStage {
        /**
         * <p>The unique identifier for the external page which is given by Intercom.</p>
         */
        _FinalStage pageId(@NotNull String pageId);

        Builder from(GetExternalPageRequest other);
    }

    public interface _FinalStage {
        GetExternalPageRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PageIdStage, _FinalStage {
        private String pageId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GetExternalPageRequest other) {
            pageId(other.getPageId());
            return this;
        }

        /**
         * <p>The unique identifier for the external page which is given by Intercom.</p>
         * <p>The unique identifier for the external page which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("page_id")
        public _FinalStage pageId(@NotNull String pageId) {
            this.pageId = Objects.requireNonNull(pageId, "pageId must not be null");
            return this;
        }

        @java.lang.Override
        public GetExternalPageRequest build() {
            return new GetExternalPageRequest(pageId, additionalProperties);
        }
    }
}
