/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontentsource.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentSource.Builder.class)
public final class ContentSource {
    private final Optional<String> contentType;

    private final Optional<String> url;

    private final Optional<String> title;

    private final Optional<String> locale;

    private final Map<String, Object> additionalProperties;

    private ContentSource(
            Optional<String> contentType,
            Optional<String> url,
            Optional<String> title,
            Optional<String> locale,
            Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.url = url;
        this.title = title;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the content source.
     */
    @JsonProperty("content_type")
    public Optional<String> getContentType() {
        return contentType;
    }

    /**
     * @return The internal URL linking to the content source for teammates.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The title of the content source.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The ISO 639 language code of the content source.
     */
    @JsonProperty("locale")
    public Optional<String> getLocale() {
        return locale;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSource && equalTo((ContentSource) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSource other) {
        return contentType.equals(other.contentType)
                && url.equals(other.url)
                && title.equals(other.title)
                && locale.equals(other.locale);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contentType, this.url, this.title, this.locale);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> contentType = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> locale = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContentSource other) {
            contentType(other.getContentType());
            url(other.getUrl());
            title(other.getTitle());
            locale(other.getLocale());
            return this;
        }

        /**
         * <p>The type of the content source.</p>
         */
        @JsonSetter(value = "content_type", nulls = Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        /**
         * <p>The internal URL linking to the content source for teammates.</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The title of the content source.</p>
         */
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The ISO 639 language code of the content source.</p>
         */
        @JsonSetter(value = "locale", nulls = Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public ContentSource build() {
            return new ContentSource(contentType, url, title, locale, additionalProperties);
        }
    }
}
