/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.calls.requests.ListCallsRequest;
import com.intercom.api.resources.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.calls.requests.ShowCallRequest;
import com.intercom.api.resources.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.calls.types.Call;
import com.intercom.api.resources.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.types.CallList;

public class CallsClient {
    protected final ClientOptions clientOptions;

    private final RawCallsClient rawClient;

    public CallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCallsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCallsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls() {
        return this.rawClient.listCalls().body();
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).body();
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).body();
    }

    /**
     * Retrieve a single call by id.
     */
    public Call showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).body();
    }

    /**
     * Retrieve a single call by id.
     */
    public Call showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).body();
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public void showCallRecording(ShowCallRecordingRequest request) {
        this.rawClient.showCallRecording(request).body();
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public void showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        this.rawClient.showCallRecording(request, requestOptions).body();
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public String showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).body();
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public String showCallTranscript(ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).body();
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).body();
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).body();
    }
}
