/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.calls.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Datetime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCallsWithTranscriptsResponse.Builder.class)
public final class ListCallsWithTranscriptsResponse {
    private final Optional<String> type;

    private final Optional<List<DataItem>> data;

    private final Map<String, Object> additionalProperties;

    private ListCallsWithTranscriptsResponse(
            Optional<String> type, Optional<List<DataItem>> data, Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    @JsonProperty("data")
    public Optional<List<DataItem>> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCallsWithTranscriptsResponse && equalTo((ListCallsWithTranscriptsResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCallsWithTranscriptsResponse other) {
        return type.equals(other.type) && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<DataItem>> data = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCallsWithTranscriptsResponse other) {
            type(other.getType());
            data(other.getData());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<DataItem>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<DataItem> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public ListCallsWithTranscriptsResponse build() {
            return new ListCallsWithTranscriptsResponse(type, data, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = DataItem.Builder.class)
    public static final class DataItem implements ICall {
        private final Optional<String> type;

        private final Optional<String> id;

        private final Optional<String> conversationId;

        private final Optional<String> adminId;

        private final Optional<String> contactId;

        private final Optional<String> state;

        private final Optional<Datetime> initiatedAt;

        private final Optional<Datetime> answeredAt;

        private final Optional<Datetime> endedAt;

        private final Optional<Datetime> createdAt;

        private final Optional<Datetime> updatedAt;

        private final Optional<String> recordingUrl;

        private final Optional<String> transcriptionUrl;

        private final Optional<String> callType;

        private final Optional<String> direction;

        private final Optional<String> endedReason;

        private final Optional<String> phone;

        private final Optional<String> finRecordingUrl;

        private final Optional<String> finTranscriptionUrl;

        private final Optional<List<Map<String, Object>>> transcript;

        private final Optional<String> transcriptStatus;

        private final Map<String, Object> additionalProperties;

        private DataItem(
                Optional<String> type,
                Optional<String> id,
                Optional<String> conversationId,
                Optional<String> adminId,
                Optional<String> contactId,
                Optional<String> state,
                Optional<Datetime> initiatedAt,
                Optional<Datetime> answeredAt,
                Optional<Datetime> endedAt,
                Optional<Datetime> createdAt,
                Optional<Datetime> updatedAt,
                Optional<String> recordingUrl,
                Optional<String> transcriptionUrl,
                Optional<String> callType,
                Optional<String> direction,
                Optional<String> endedReason,
                Optional<String> phone,
                Optional<String> finRecordingUrl,
                Optional<String> finTranscriptionUrl,
                Optional<List<Map<String, Object>>> transcript,
                Optional<String> transcriptStatus,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.conversationId = conversationId;
            this.adminId = adminId;
            this.contactId = contactId;
            this.state = state;
            this.initiatedAt = initiatedAt;
            this.answeredAt = answeredAt;
            this.endedAt = endedAt;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.recordingUrl = recordingUrl;
            this.transcriptionUrl = transcriptionUrl;
            this.callType = callType;
            this.direction = direction;
            this.endedReason = endedReason;
            this.phone = phone;
            this.finRecordingUrl = finRecordingUrl;
            this.finTranscriptionUrl = finTranscriptionUrl;
            this.transcript = transcript;
            this.transcriptStatus = transcriptStatus;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return String representing the object's type. Always has the value <code>call</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return The id of the call.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        /**
         * @return The id of the conversation associated with the call, if any.
         */
        @JsonProperty("conversation_id")
        public Optional<String> getConversationId() {
            return conversationId;
        }

        /**
         * @return The id of the admin associated with the call, if any.
         */
        @JsonProperty("admin_id")
        public Optional<String> getAdminId() {
            return adminId;
        }

        /**
         * @return The id of the contact associated with the call, if any.
         */
        @JsonProperty("contact_id")
        public Optional<String> getContactId() {
            return contactId;
        }

        /**
         * @return The current state of the call.
         */
        @JsonProperty("state")
        public Optional<String> getState() {
            return state;
        }

        @JsonProperty("initiated_at")
        public Optional<Datetime> getInitiatedAt() {
            return initiatedAt;
        }

        @JsonProperty("answered_at")
        public Optional<Datetime> getAnsweredAt() {
            return answeredAt;
        }

        @JsonProperty("ended_at")
        public Optional<Datetime> getEndedAt() {
            return endedAt;
        }

        @JsonProperty("created_at")
        public Optional<Datetime> getCreatedAt() {
            return createdAt;
        }

        @JsonProperty("updated_at")
        public Optional<Datetime> getUpdatedAt() {
            return updatedAt;
        }

        /**
         * @return API URL to download or redirect to the call recording if available.
         */
        @JsonProperty("recording_url")
        public Optional<String> getRecordingUrl() {
            return recordingUrl;
        }

        /**
         * @return API URL to download or redirect to the call transcript if available.
         */
        @JsonProperty("transcription_url")
        public Optional<String> getTranscriptionUrl() {
            return transcriptionUrl;
        }

        /**
         * @return The type of call.
         */
        @JsonProperty("call_type")
        public Optional<String> getCallType() {
            return callType;
        }

        /**
         * @return The direction of the call.
         */
        @JsonProperty("direction")
        public Optional<String> getDirection() {
            return direction;
        }

        /**
         * @return The reason for the call end, if applicable.
         */
        @JsonProperty("ended_reason")
        public Optional<String> getEndedReason() {
            return endedReason;
        }

        /**
         * @return The phone number involved in the call, in E.164 format.
         */
        @JsonProperty("phone")
        public Optional<String> getPhone() {
            return phone;
        }

        /**
         * @return API URL to the AI Agent (Fin) call recording if available.
         */
        @JsonProperty("fin_recording_url")
        public Optional<String> getFinRecordingUrl() {
            return finRecordingUrl;
        }

        /**
         * @return API URL to the AI Agent (Fin) call transcript if available.
         */
        @JsonProperty("fin_transcription_url")
        public Optional<String> getFinTranscriptionUrl() {
            return finTranscriptionUrl;
        }

        /**
         * @return The call transcript if available, otherwise an empty array.
         */
        @JsonProperty("transcript")
        public Optional<List<Map<String, Object>>> getTranscript() {
            return transcript;
        }

        /**
         * @return The status of the transcript if available.
         */
        @JsonProperty("transcript_status")
        public Optional<String> getTranscriptStatus() {
            return transcriptStatus;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof DataItem && equalTo((DataItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(DataItem other) {
            return type.equals(other.type)
                    && id.equals(other.id)
                    && conversationId.equals(other.conversationId)
                    && adminId.equals(other.adminId)
                    && contactId.equals(other.contactId)
                    && state.equals(other.state)
                    && initiatedAt.equals(other.initiatedAt)
                    && answeredAt.equals(other.answeredAt)
                    && endedAt.equals(other.endedAt)
                    && createdAt.equals(other.createdAt)
                    && updatedAt.equals(other.updatedAt)
                    && recordingUrl.equals(other.recordingUrl)
                    && transcriptionUrl.equals(other.transcriptionUrl)
                    && callType.equals(other.callType)
                    && direction.equals(other.direction)
                    && endedReason.equals(other.endedReason)
                    && phone.equals(other.phone)
                    && finRecordingUrl.equals(other.finRecordingUrl)
                    && finTranscriptionUrl.equals(other.finTranscriptionUrl)
                    && transcript.equals(other.transcript)
                    && transcriptStatus.equals(other.transcriptStatus);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.type,
                    this.id,
                    this.conversationId,
                    this.adminId,
                    this.contactId,
                    this.state,
                    this.initiatedAt,
                    this.answeredAt,
                    this.endedAt,
                    this.createdAt,
                    this.updatedAt,
                    this.recordingUrl,
                    this.transcriptionUrl,
                    this.callType,
                    this.direction,
                    this.endedReason,
                    this.phone,
                    this.finRecordingUrl,
                    this.finTranscriptionUrl,
                    this.transcript,
                    this.transcriptStatus);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> id = Optional.empty();

            private Optional<String> conversationId = Optional.empty();

            private Optional<String> adminId = Optional.empty();

            private Optional<String> contactId = Optional.empty();

            private Optional<String> state = Optional.empty();

            private Optional<Datetime> initiatedAt = Optional.empty();

            private Optional<Datetime> answeredAt = Optional.empty();

            private Optional<Datetime> endedAt = Optional.empty();

            private Optional<Datetime> createdAt = Optional.empty();

            private Optional<Datetime> updatedAt = Optional.empty();

            private Optional<String> recordingUrl = Optional.empty();

            private Optional<String> transcriptionUrl = Optional.empty();

            private Optional<String> callType = Optional.empty();

            private Optional<String> direction = Optional.empty();

            private Optional<String> endedReason = Optional.empty();

            private Optional<String> phone = Optional.empty();

            private Optional<String> finRecordingUrl = Optional.empty();

            private Optional<String> finTranscriptionUrl = Optional.empty();

            private Optional<List<Map<String, Object>>> transcript = Optional.empty();

            private Optional<String> transcriptStatus = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(DataItem other) {
                type(other.getType());
                id(other.getId());
                conversationId(other.getConversationId());
                adminId(other.getAdminId());
                contactId(other.getContactId());
                state(other.getState());
                initiatedAt(other.getInitiatedAt());
                answeredAt(other.getAnsweredAt());
                endedAt(other.getEndedAt());
                createdAt(other.getCreatedAt());
                updatedAt(other.getUpdatedAt());
                recordingUrl(other.getRecordingUrl());
                transcriptionUrl(other.getTranscriptionUrl());
                callType(other.getCallType());
                direction(other.getDirection());
                endedReason(other.getEndedReason());
                phone(other.getPhone());
                finRecordingUrl(other.getFinRecordingUrl());
                finTranscriptionUrl(other.getFinTranscriptionUrl());
                transcript(other.getTranscript());
                transcriptStatus(other.getTranscriptStatus());
                return this;
            }

            /**
             * <p>String representing the object's type. Always has the value <code>call</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The id of the call.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            /**
             * <p>The id of the conversation associated with the call, if any.</p>
             */
            @JsonSetter(value = "conversation_id", nulls = Nulls.SKIP)
            public Builder conversationId(Optional<String> conversationId) {
                this.conversationId = conversationId;
                return this;
            }

            public Builder conversationId(String conversationId) {
                this.conversationId = Optional.ofNullable(conversationId);
                return this;
            }

            /**
             * <p>The id of the admin associated with the call, if any.</p>
             */
            @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
            public Builder adminId(Optional<String> adminId) {
                this.adminId = adminId;
                return this;
            }

            public Builder adminId(String adminId) {
                this.adminId = Optional.ofNullable(adminId);
                return this;
            }

            /**
             * <p>The id of the contact associated with the call, if any.</p>
             */
            @JsonSetter(value = "contact_id", nulls = Nulls.SKIP)
            public Builder contactId(Optional<String> contactId) {
                this.contactId = contactId;
                return this;
            }

            public Builder contactId(String contactId) {
                this.contactId = Optional.ofNullable(contactId);
                return this;
            }

            /**
             * <p>The current state of the call.</p>
             */
            @JsonSetter(value = "state", nulls = Nulls.SKIP)
            public Builder state(Optional<String> state) {
                this.state = state;
                return this;
            }

            public Builder state(String state) {
                this.state = Optional.ofNullable(state);
                return this;
            }

            @JsonSetter(value = "initiated_at", nulls = Nulls.SKIP)
            public Builder initiatedAt(Optional<Datetime> initiatedAt) {
                this.initiatedAt = initiatedAt;
                return this;
            }

            public Builder initiatedAt(Datetime initiatedAt) {
                this.initiatedAt = Optional.ofNullable(initiatedAt);
                return this;
            }

            @JsonSetter(value = "answered_at", nulls = Nulls.SKIP)
            public Builder answeredAt(Optional<Datetime> answeredAt) {
                this.answeredAt = answeredAt;
                return this;
            }

            public Builder answeredAt(Datetime answeredAt) {
                this.answeredAt = Optional.ofNullable(answeredAt);
                return this;
            }

            @JsonSetter(value = "ended_at", nulls = Nulls.SKIP)
            public Builder endedAt(Optional<Datetime> endedAt) {
                this.endedAt = endedAt;
                return this;
            }

            public Builder endedAt(Datetime endedAt) {
                this.endedAt = Optional.ofNullable(endedAt);
                return this;
            }

            @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
            public Builder createdAt(Optional<Datetime> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public Builder createdAt(Datetime createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
            public Builder updatedAt(Optional<Datetime> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder updatedAt(Datetime updatedAt) {
                this.updatedAt = Optional.ofNullable(updatedAt);
                return this;
            }

            /**
             * <p>API URL to download or redirect to the call recording if available.</p>
             */
            @JsonSetter(value = "recording_url", nulls = Nulls.SKIP)
            public Builder recordingUrl(Optional<String> recordingUrl) {
                this.recordingUrl = recordingUrl;
                return this;
            }

            public Builder recordingUrl(String recordingUrl) {
                this.recordingUrl = Optional.ofNullable(recordingUrl);
                return this;
            }

            /**
             * <p>API URL to download or redirect to the call transcript if available.</p>
             */
            @JsonSetter(value = "transcription_url", nulls = Nulls.SKIP)
            public Builder transcriptionUrl(Optional<String> transcriptionUrl) {
                this.transcriptionUrl = transcriptionUrl;
                return this;
            }

            public Builder transcriptionUrl(String transcriptionUrl) {
                this.transcriptionUrl = Optional.ofNullable(transcriptionUrl);
                return this;
            }

            /**
             * <p>The type of call.</p>
             */
            @JsonSetter(value = "call_type", nulls = Nulls.SKIP)
            public Builder callType(Optional<String> callType) {
                this.callType = callType;
                return this;
            }

            public Builder callType(String callType) {
                this.callType = Optional.ofNullable(callType);
                return this;
            }

            /**
             * <p>The direction of the call.</p>
             */
            @JsonSetter(value = "direction", nulls = Nulls.SKIP)
            public Builder direction(Optional<String> direction) {
                this.direction = direction;
                return this;
            }

            public Builder direction(String direction) {
                this.direction = Optional.ofNullable(direction);
                return this;
            }

            /**
             * <p>The reason for the call end, if applicable.</p>
             */
            @JsonSetter(value = "ended_reason", nulls = Nulls.SKIP)
            public Builder endedReason(Optional<String> endedReason) {
                this.endedReason = endedReason;
                return this;
            }

            public Builder endedReason(String endedReason) {
                this.endedReason = Optional.ofNullable(endedReason);
                return this;
            }

            /**
             * <p>The phone number involved in the call, in E.164 format.</p>
             */
            @JsonSetter(value = "phone", nulls = Nulls.SKIP)
            public Builder phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            public Builder phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            /**
             * <p>API URL to the AI Agent (Fin) call recording if available.</p>
             */
            @JsonSetter(value = "fin_recording_url", nulls = Nulls.SKIP)
            public Builder finRecordingUrl(Optional<String> finRecordingUrl) {
                this.finRecordingUrl = finRecordingUrl;
                return this;
            }

            public Builder finRecordingUrl(String finRecordingUrl) {
                this.finRecordingUrl = Optional.ofNullable(finRecordingUrl);
                return this;
            }

            /**
             * <p>API URL to the AI Agent (Fin) call transcript if available.</p>
             */
            @JsonSetter(value = "fin_transcription_url", nulls = Nulls.SKIP)
            public Builder finTranscriptionUrl(Optional<String> finTranscriptionUrl) {
                this.finTranscriptionUrl = finTranscriptionUrl;
                return this;
            }

            public Builder finTranscriptionUrl(String finTranscriptionUrl) {
                this.finTranscriptionUrl = Optional.ofNullable(finTranscriptionUrl);
                return this;
            }

            /**
             * <p>The call transcript if available, otherwise an empty array.</p>
             */
            @JsonSetter(value = "transcript", nulls = Nulls.SKIP)
            public Builder transcript(Optional<List<Map<String, Object>>> transcript) {
                this.transcript = transcript;
                return this;
            }

            public Builder transcript(List<Map<String, Object>> transcript) {
                this.transcript = Optional.ofNullable(transcript);
                return this;
            }

            /**
             * <p>The status of the transcript if available.</p>
             */
            @JsonSetter(value = "transcript_status", nulls = Nulls.SKIP)
            public Builder transcriptStatus(Optional<String> transcriptStatus) {
                this.transcriptStatus = transcriptStatus;
                return this;
            }

            public Builder transcriptStatus(String transcriptStatus) {
                this.transcriptStatus = Optional.ofNullable(transcriptStatus);
                return this;
            }

            public DataItem build() {
                return new DataItem(
                        type,
                        id,
                        conversationId,
                        adminId,
                        contactId,
                        state,
                        initiatedAt,
                        answeredAt,
                        endedAt,
                        createdAt,
                        updatedAt,
                        recordingUrl,
                        transcriptionUrl,
                        callType,
                        direction,
                        endedReason,
                        phone,
                        finRecordingUrl,
                        finTranscriptionUrl,
                        transcript,
                        transcriptStatus,
                        additionalProperties);
            }
        }
    }
}
