/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AttachSubscriptionToContactRequest.Builder.class)
public final class AttachSubscriptionToContactRequest {
    private final String contactId;

    private final String subscriptionId;

    private final String consentType;

    private final Map<String, Object> additionalProperties;

    private AttachSubscriptionToContactRequest(
            String contactId, String subscriptionId, String consentType, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.subscriptionId = subscriptionId;
        this.consentType = consentType;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    /**
     * @return The unique identifier for the subscription which is given by Intercom
     */
    @JsonProperty("id")
    public String getSubscriptionId() {
        return subscriptionId;
    }

    /**
     * @return The consent_type of a subscription, opt_out or opt_in.
     */
    @JsonProperty("consent_type")
    public String getConsentType() {
        return consentType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AttachSubscriptionToContactRequest
                && equalTo((AttachSubscriptionToContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachSubscriptionToContactRequest other) {
        return contactId.equals(other.contactId)
                && subscriptionId.equals(other.subscriptionId)
                && consentType.equals(other.consentType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contactId, this.subscriptionId, this.consentType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    public interface ContactIdStage {
        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         */
        SubscriptionIdStage contactId(@NotNull String contactId);

        Builder from(AttachSubscriptionToContactRequest other);
    }

    public interface SubscriptionIdStage {
        /**
         * <p>The unique identifier for the subscription which is given by Intercom</p>
         */
        ConsentTypeStage subscriptionId(@NotNull String subscriptionId);
    }

    public interface ConsentTypeStage {
        /**
         * <p>The consent_type of a subscription, opt_out or opt_in.</p>
         */
        _FinalStage consentType(@NotNull String consentType);
    }

    public interface _FinalStage {
        AttachSubscriptionToContactRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContactIdStage, SubscriptionIdStage, ConsentTypeStage, _FinalStage {
        private String contactId;

        private String subscriptionId;

        private String consentType;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AttachSubscriptionToContactRequest other) {
            contactId(other.getContactId());
            subscriptionId(other.getSubscriptionId());
            consentType(other.getConsentType());
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * <p>The unique identifier for the contact which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public SubscriptionIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        /**
         * <p>The unique identifier for the subscription which is given by Intercom</p>
         * <p>The unique identifier for the subscription which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public ConsentTypeStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        /**
         * <p>The consent_type of a subscription, opt_out or opt_in.</p>
         * <p>The consent_type of a subscription, opt_out or opt_in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("consent_type")
        public _FinalStage consentType(@NotNull String consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        @java.lang.Override
        public AttachSubscriptionToContactRequest build() {
            return new AttachSubscriptionToContactRequest(contactId, subscriptionId, consentType, additionalProperties);
        }
    }
}
