/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.contacts.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactCompanies;
import com.intercom.api.types.ContactLocation;
import com.intercom.api.types.ContactNotes;
import com.intercom.api.types.ContactSocialProfiles;
import com.intercom.api.types.ContactTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactsMergeLeadInUserResponse.Builder.class)
public final class ContactsMergeLeadInUserResponse implements IContact {
    private final String id;

    private final Optional<String> externalId;

    private final String workspaceId;

    private final String role;

    private final Optional<String> email;

    private final Optional<String> emailDomain;

    private final Optional<String> phone;

    private final Optional<String> name;

    private final Optional<Integer> ownerId;

    private final boolean hasHardBounced;

    private final boolean markedEmailAsSpam;

    private final boolean unsubscribedFromEmails;

    private final int createdAt;

    private final int updatedAt;

    private final Optional<Integer> signedUpAt;

    private final Optional<Integer> lastSeenAt;

    private final Optional<Integer> lastRepliedAt;

    private final Optional<Integer> lastContactedAt;

    private final Optional<Integer> lastEmailOpenedAt;

    private final Optional<Integer> lastEmailClickedAt;

    private final Optional<String> languageOverride;

    private final Optional<String> browser;

    private final Optional<String> browserVersion;

    private final Optional<String> browserLanguage;

    private final Optional<String> os;

    private final Optional<String> androidAppName;

    private final Optional<String> androidAppVersion;

    private final Optional<String> androidDevice;

    private final Optional<String> androidOsVersion;

    private final Optional<String> androidSdkVersion;

    private final Optional<Integer> androidLastSeenAt;

    private final Optional<String> iosAppName;

    private final Optional<String> iosAppVersion;

    private final Optional<String> iosDevice;

    private final Optional<String> iosOsVersion;

    private final Optional<String> iosSdkVersion;

    private final Optional<Integer> iosLastSeenAt;

    private final Optional<Map<String, Object>> customAttributes;

    private final Optional<String> avatar;

    private final Optional<ContactTags> tags;

    private final Optional<ContactNotes> notes;

    private final Optional<ContactCompanies> companies;

    private final Optional<ContactLocation> location;

    private final Optional<ContactSocialProfiles> socialProfiles;

    private final Optional<Boolean> enabledPushMessaging;

    private final Map<String, Object> additionalProperties;

    private ContactsMergeLeadInUserResponse(
            String id,
            Optional<String> externalId,
            String workspaceId,
            String role,
            Optional<String> email,
            Optional<String> emailDomain,
            Optional<String> phone,
            Optional<String> name,
            Optional<Integer> ownerId,
            boolean hasHardBounced,
            boolean markedEmailAsSpam,
            boolean unsubscribedFromEmails,
            int createdAt,
            int updatedAt,
            Optional<Integer> signedUpAt,
            Optional<Integer> lastSeenAt,
            Optional<Integer> lastRepliedAt,
            Optional<Integer> lastContactedAt,
            Optional<Integer> lastEmailOpenedAt,
            Optional<Integer> lastEmailClickedAt,
            Optional<String> languageOverride,
            Optional<String> browser,
            Optional<String> browserVersion,
            Optional<String> browserLanguage,
            Optional<String> os,
            Optional<String> androidAppName,
            Optional<String> androidAppVersion,
            Optional<String> androidDevice,
            Optional<String> androidOsVersion,
            Optional<String> androidSdkVersion,
            Optional<Integer> androidLastSeenAt,
            Optional<String> iosAppName,
            Optional<String> iosAppVersion,
            Optional<String> iosDevice,
            Optional<String> iosOsVersion,
            Optional<String> iosSdkVersion,
            Optional<Integer> iosLastSeenAt,
            Optional<Map<String, Object>> customAttributes,
            Optional<String> avatar,
            Optional<ContactTags> tags,
            Optional<ContactNotes> notes,
            Optional<ContactCompanies> companies,
            Optional<ContactLocation> location,
            Optional<ContactSocialProfiles> socialProfiles,
            Optional<Boolean> enabledPushMessaging,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.externalId = externalId;
        this.workspaceId = workspaceId;
        this.role = role;
        this.email = email;
        this.emailDomain = emailDomain;
        this.phone = phone;
        this.name = name;
        this.ownerId = ownerId;
        this.hasHardBounced = hasHardBounced;
        this.markedEmailAsSpam = markedEmailAsSpam;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.signedUpAt = signedUpAt;
        this.lastSeenAt = lastSeenAt;
        this.lastRepliedAt = lastRepliedAt;
        this.lastContactedAt = lastContactedAt;
        this.lastEmailOpenedAt = lastEmailOpenedAt;
        this.lastEmailClickedAt = lastEmailClickedAt;
        this.languageOverride = languageOverride;
        this.browser = browser;
        this.browserVersion = browserVersion;
        this.browserLanguage = browserLanguage;
        this.os = os;
        this.androidAppName = androidAppName;
        this.androidAppVersion = androidAppVersion;
        this.androidDevice = androidDevice;
        this.androidOsVersion = androidOsVersion;
        this.androidSdkVersion = androidSdkVersion;
        this.androidLastSeenAt = androidLastSeenAt;
        this.iosAppName = iosAppName;
        this.iosAppVersion = iosAppVersion;
        this.iosDevice = iosDevice;
        this.iosOsVersion = iosOsVersion;
        this.iosSdkVersion = iosSdkVersion;
        this.iosLastSeenAt = iosLastSeenAt;
        this.customAttributes = customAttributes;
        this.avatar = avatar;
        this.tags = tags;
        this.notes = notes;
        this.companies = companies;
        this.location = location;
        this.socialProfiles = socialProfiles;
        this.enabledPushMessaging = enabledPushMessaging;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object.
     */
    @JsonProperty("type")
    public String getType() {
        return "contact";
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The unique identifier for the contact which is provided by the Client.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return The id of the workspace which the contact belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The role of the contact.
     */
    @JsonProperty("role")
    public String getRole() {
        return role;
    }

    /**
     * @return The contact's email.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The contact's email domain.
     */
    @JsonProperty("email_domain")
    public Optional<String> getEmailDomain() {
        return emailDomain;
    }

    /**
     * @return The contacts phone.
     */
    @JsonProperty("phone")
    public Optional<String> getPhone() {
        return phone;
    }

    /**
     * @return The contacts name.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The id of an admin that has been assigned account ownership of the contact.
     */
    @JsonProperty("owner_id")
    public Optional<Integer> getOwnerId() {
        return ownerId;
    }

    /**
     * @return Whether the contact has had an email sent to them hard bounce.
     */
    @JsonProperty("has_hard_bounced")
    public boolean getHasHardBounced() {
        return hasHardBounced;
    }

    /**
     * @return Whether the contact has marked an email sent to them as spam.
     */
    @JsonProperty("marked_email_as_spam")
    public boolean getMarkedEmailAsSpam() {
        return markedEmailAsSpam;
    }

    /**
     * @return Whether the contact is unsubscribed from emails.
     */
    @JsonProperty("unsubscribed_from_emails")
    public boolean getUnsubscribedFromEmails() {
        return unsubscribedFromEmails;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return (UNIX timestamp) The time specified for when a contact signed up.
     */
    @JsonProperty("signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return signedUpAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).
     */
    @JsonProperty("last_seen_at")
    public Optional<Integer> getLastSeenAt() {
        return lastSeenAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last messaged in.
     */
    @JsonProperty("last_replied_at")
    public Optional<Integer> getLastRepliedAt() {
        return lastRepliedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last messaged.
     */
    @JsonProperty("last_contacted_at")
    public Optional<Integer> getLastContactedAt() {
        return lastContactedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last opened an email.
     */
    @JsonProperty("last_email_opened_at")
    public Optional<Integer> getLastEmailOpenedAt() {
        return lastEmailOpenedAt;
    }

    /**
     * @return (UNIX timestamp) The time when the contact last clicked a link in an email.
     */
    @JsonProperty("last_email_clicked_at")
    public Optional<Integer> getLastEmailClickedAt() {
        return lastEmailClickedAt;
    }

    /**
     * @return A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.
     */
    @JsonProperty("language_override")
    public Optional<String> getLanguageOverride() {
        return languageOverride;
    }

    /**
     * @return The name of the browser which the contact is using.
     */
    @JsonProperty("browser")
    public Optional<String> getBrowser() {
        return browser;
    }

    /**
     * @return The version of the browser which the contact is using.
     */
    @JsonProperty("browser_version")
    public Optional<String> getBrowserVersion() {
        return browserVersion;
    }

    /**
     * @return The language set by the browser which the contact is using.
     */
    @JsonProperty("browser_language")
    public Optional<String> getBrowserLanguage() {
        return browserLanguage;
    }

    /**
     * @return The operating system which the contact is using.
     */
    @JsonProperty("os")
    public Optional<String> getOs() {
        return os;
    }

    /**
     * @return The name of the Android app which the contact is using.
     */
    @JsonProperty("android_app_name")
    public Optional<String> getAndroidAppName() {
        return androidAppName;
    }

    /**
     * @return The version of the Android app which the contact is using.
     */
    @JsonProperty("android_app_version")
    public Optional<String> getAndroidAppVersion() {
        return androidAppVersion;
    }

    /**
     * @return The Android device which the contact is using.
     */
    @JsonProperty("android_device")
    public Optional<String> getAndroidDevice() {
        return androidDevice;
    }

    /**
     * @return The version of the Android OS which the contact is using.
     */
    @JsonProperty("android_os_version")
    public Optional<String> getAndroidOsVersion() {
        return androidOsVersion;
    }

    /**
     * @return The version of the Android SDK which the contact is using.
     */
    @JsonProperty("android_sdk_version")
    public Optional<String> getAndroidSdkVersion() {
        return androidSdkVersion;
    }

    /**
     * @return (UNIX timestamp) The time when the contact was last seen on an Android device.
     */
    @JsonProperty("android_last_seen_at")
    public Optional<Integer> getAndroidLastSeenAt() {
        return androidLastSeenAt;
    }

    /**
     * @return The name of the iOS app which the contact is using.
     */
    @JsonProperty("ios_app_name")
    public Optional<String> getIosAppName() {
        return iosAppName;
    }

    /**
     * @return The version of the iOS app which the contact is using.
     */
    @JsonProperty("ios_app_version")
    public Optional<String> getIosAppVersion() {
        return iosAppVersion;
    }

    /**
     * @return The iOS device which the contact is using.
     */
    @JsonProperty("ios_device")
    public Optional<String> getIosDevice() {
        return iosDevice;
    }

    /**
     * @return The version of iOS which the contact is using.
     */
    @JsonProperty("ios_os_version")
    public Optional<String> getIosOsVersion() {
        return iosOsVersion;
    }

    /**
     * @return The version of the iOS SDK which the contact is using.
     */
    @JsonProperty("ios_sdk_version")
    public Optional<String> getIosSdkVersion() {
        return iosSdkVersion;
    }

    /**
     * @return (UNIX timestamp) The last time the contact used the iOS app.
     */
    @JsonProperty("ios_last_seen_at")
    public Optional<Integer> getIosLastSeenAt() {
        return iosLastSeenAt;
    }

    /**
     * @return The custom attributes which are set for the contact.
     */
    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    /**
     * @return An image URL containing the avatar of a contact.
     */
    @JsonProperty("avatar")
    public Optional<String> getAvatar() {
        return avatar;
    }

    @JsonProperty("tags")
    public Optional<ContactTags> getTags() {
        return tags;
    }

    @JsonProperty("notes")
    public Optional<ContactNotes> getNotes() {
        return notes;
    }

    @JsonProperty("companies")
    public Optional<ContactCompanies> getCompanies() {
        return companies;
    }

    @JsonProperty("location")
    public Optional<ContactLocation> getLocation() {
        return location;
    }

    @JsonProperty("social_profiles")
    public Optional<ContactSocialProfiles> getSocialProfiles() {
        return socialProfiles;
    }

    /**
     * @return If the user has enabled push messaging.
     */
    @JsonProperty("enabled_push_messaging")
    public Optional<Boolean> getEnabledPushMessaging() {
        return enabledPushMessaging;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactsMergeLeadInUserResponse && equalTo((ContactsMergeLeadInUserResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactsMergeLeadInUserResponse other) {
        return id.equals(other.id)
                && externalId.equals(other.externalId)
                && workspaceId.equals(other.workspaceId)
                && role.equals(other.role)
                && email.equals(other.email)
                && emailDomain.equals(other.emailDomain)
                && phone.equals(other.phone)
                && name.equals(other.name)
                && ownerId.equals(other.ownerId)
                && hasHardBounced == other.hasHardBounced
                && markedEmailAsSpam == other.markedEmailAsSpam
                && unsubscribedFromEmails == other.unsubscribedFromEmails
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt
                && signedUpAt.equals(other.signedUpAt)
                && lastSeenAt.equals(other.lastSeenAt)
                && lastRepliedAt.equals(other.lastRepliedAt)
                && lastContactedAt.equals(other.lastContactedAt)
                && lastEmailOpenedAt.equals(other.lastEmailOpenedAt)
                && lastEmailClickedAt.equals(other.lastEmailClickedAt)
                && languageOverride.equals(other.languageOverride)
                && browser.equals(other.browser)
                && browserVersion.equals(other.browserVersion)
                && browserLanguage.equals(other.browserLanguage)
                && os.equals(other.os)
                && androidAppName.equals(other.androidAppName)
                && androidAppVersion.equals(other.androidAppVersion)
                && androidDevice.equals(other.androidDevice)
                && androidOsVersion.equals(other.androidOsVersion)
                && androidSdkVersion.equals(other.androidSdkVersion)
                && androidLastSeenAt.equals(other.androidLastSeenAt)
                && iosAppName.equals(other.iosAppName)
                && iosAppVersion.equals(other.iosAppVersion)
                && iosDevice.equals(other.iosDevice)
                && iosOsVersion.equals(other.iosOsVersion)
                && iosSdkVersion.equals(other.iosSdkVersion)
                && iosLastSeenAt.equals(other.iosLastSeenAt)
                && customAttributes.equals(other.customAttributes)
                && avatar.equals(other.avatar)
                && tags.equals(other.tags)
                && notes.equals(other.notes)
                && companies.equals(other.companies)
                && location.equals(other.location)
                && socialProfiles.equals(other.socialProfiles)
                && enabledPushMessaging.equals(other.enabledPushMessaging);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.externalId,
                this.workspaceId,
                this.role,
                this.email,
                this.emailDomain,
                this.phone,
                this.name,
                this.ownerId,
                this.hasHardBounced,
                this.markedEmailAsSpam,
                this.unsubscribedFromEmails,
                this.createdAt,
                this.updatedAt,
                this.signedUpAt,
                this.lastSeenAt,
                this.lastRepliedAt,
                this.lastContactedAt,
                this.lastEmailOpenedAt,
                this.lastEmailClickedAt,
                this.languageOverride,
                this.browser,
                this.browserVersion,
                this.browserLanguage,
                this.os,
                this.androidAppName,
                this.androidAppVersion,
                this.androidDevice,
                this.androidOsVersion,
                this.androidSdkVersion,
                this.androidLastSeenAt,
                this.iosAppName,
                this.iosAppVersion,
                this.iosDevice,
                this.iosOsVersion,
                this.iosSdkVersion,
                this.iosLastSeenAt,
                this.customAttributes,
                this.avatar,
                this.tags,
                this.notes,
                this.companies,
                this.location,
                this.socialProfiles,
                this.enabledPushMessaging);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the contact which is given by Intercom.</p>
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(ContactsMergeLeadInUserResponse other);
    }

    public interface WorkspaceIdStage {
        /**
         * <p>The id of the workspace which the contact belongs to.</p>
         */
        RoleStage workspaceId(@NotNull String workspaceId);
    }

    public interface RoleStage {
        /**
         * <p>The role of the contact.</p>
         */
        HasHardBouncedStage role(@NotNull String role);
    }

    public interface HasHardBouncedStage {
        /**
         * <p>Whether the contact has had an email sent to them hard bounce.</p>
         */
        MarkedEmailAsSpamStage hasHardBounced(boolean hasHardBounced);
    }

    public interface MarkedEmailAsSpamStage {
        /**
         * <p>Whether the contact has marked an email sent to them as spam.</p>
         */
        UnsubscribedFromEmailsStage markedEmailAsSpam(boolean markedEmailAsSpam);
    }

    public interface UnsubscribedFromEmailsStage {
        /**
         * <p>Whether the contact is unsubscribed from emails.</p>
         */
        CreatedAtStage unsubscribedFromEmails(boolean unsubscribedFromEmails);
    }

    public interface CreatedAtStage {
        /**
         * <p>(UNIX timestamp) The time when the contact was created.</p>
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * <p>(UNIX timestamp) The time when the contact was last updated.</p>
         */
        _FinalStage updatedAt(int updatedAt);
    }

    public interface _FinalStage {
        ContactsMergeLeadInUserResponse build();

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);

        /**
         * <p>The contact's email.</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);

        /**
         * <p>The contact's email domain.</p>
         */
        _FinalStage emailDomain(Optional<String> emailDomain);

        _FinalStage emailDomain(String emailDomain);

        /**
         * <p>The contacts phone.</p>
         */
        _FinalStage phone(Optional<String> phone);

        _FinalStage phone(String phone);

        /**
         * <p>The contacts name.</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact.</p>
         */
        _FinalStage ownerId(Optional<Integer> ownerId);

        _FinalStage ownerId(Integer ownerId);

        /**
         * <p>(UNIX timestamp) The time specified for when a contact signed up.</p>
         */
        _FinalStage signedUpAt(Optional<Integer> signedUpAt);

        _FinalStage signedUpAt(Integer signedUpAt);

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).</p>
         */
        _FinalStage lastSeenAt(Optional<Integer> lastSeenAt);

        _FinalStage lastSeenAt(Integer lastSeenAt);

        /**
         * <p>(UNIX timestamp) The time when the contact last messaged in.</p>
         */
        _FinalStage lastRepliedAt(Optional<Integer> lastRepliedAt);

        _FinalStage lastRepliedAt(Integer lastRepliedAt);

        /**
         * <p>(UNIX timestamp) The time when the contact was last messaged.</p>
         */
        _FinalStage lastContactedAt(Optional<Integer> lastContactedAt);

        _FinalStage lastContactedAt(Integer lastContactedAt);

        /**
         * <p>(UNIX timestamp) The time when the contact last opened an email.</p>
         */
        _FinalStage lastEmailOpenedAt(Optional<Integer> lastEmailOpenedAt);

        _FinalStage lastEmailOpenedAt(Integer lastEmailOpenedAt);

        /**
         * <p>(UNIX timestamp) The time when the contact last clicked a link in an email.</p>
         */
        _FinalStage lastEmailClickedAt(Optional<Integer> lastEmailClickedAt);

        _FinalStage lastEmailClickedAt(Integer lastEmailClickedAt);

        /**
         * <p>A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.</p>
         */
        _FinalStage languageOverride(Optional<String> languageOverride);

        _FinalStage languageOverride(String languageOverride);

        /**
         * <p>The name of the browser which the contact is using.</p>
         */
        _FinalStage browser(Optional<String> browser);

        _FinalStage browser(String browser);

        /**
         * <p>The version of the browser which the contact is using.</p>
         */
        _FinalStage browserVersion(Optional<String> browserVersion);

        _FinalStage browserVersion(String browserVersion);

        /**
         * <p>The language set by the browser which the contact is using.</p>
         */
        _FinalStage browserLanguage(Optional<String> browserLanguage);

        _FinalStage browserLanguage(String browserLanguage);

        /**
         * <p>The operating system which the contact is using.</p>
         */
        _FinalStage os(Optional<String> os);

        _FinalStage os(String os);

        /**
         * <p>The name of the Android app which the contact is using.</p>
         */
        _FinalStage androidAppName(Optional<String> androidAppName);

        _FinalStage androidAppName(String androidAppName);

        /**
         * <p>The version of the Android app which the contact is using.</p>
         */
        _FinalStage androidAppVersion(Optional<String> androidAppVersion);

        _FinalStage androidAppVersion(String androidAppVersion);

        /**
         * <p>The Android device which the contact is using.</p>
         */
        _FinalStage androidDevice(Optional<String> androidDevice);

        _FinalStage androidDevice(String androidDevice);

        /**
         * <p>The version of the Android OS which the contact is using.</p>
         */
        _FinalStage androidOsVersion(Optional<String> androidOsVersion);

        _FinalStage androidOsVersion(String androidOsVersion);

        /**
         * <p>The version of the Android SDK which the contact is using.</p>
         */
        _FinalStage androidSdkVersion(Optional<String> androidSdkVersion);

        _FinalStage androidSdkVersion(String androidSdkVersion);

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen on an Android device.</p>
         */
        _FinalStage androidLastSeenAt(Optional<Integer> androidLastSeenAt);

        _FinalStage androidLastSeenAt(Integer androidLastSeenAt);

        /**
         * <p>The name of the iOS app which the contact is using.</p>
         */
        _FinalStage iosAppName(Optional<String> iosAppName);

        _FinalStage iosAppName(String iosAppName);

        /**
         * <p>The version of the iOS app which the contact is using.</p>
         */
        _FinalStage iosAppVersion(Optional<String> iosAppVersion);

        _FinalStage iosAppVersion(String iosAppVersion);

        /**
         * <p>The iOS device which the contact is using.</p>
         */
        _FinalStage iosDevice(Optional<String> iosDevice);

        _FinalStage iosDevice(String iosDevice);

        /**
         * <p>The version of iOS which the contact is using.</p>
         */
        _FinalStage iosOsVersion(Optional<String> iosOsVersion);

        _FinalStage iosOsVersion(String iosOsVersion);

        /**
         * <p>The version of the iOS SDK which the contact is using.</p>
         */
        _FinalStage iosSdkVersion(Optional<String> iosSdkVersion);

        _FinalStage iosSdkVersion(String iosSdkVersion);

        /**
         * <p>(UNIX timestamp) The last time the contact used the iOS app.</p>
         */
        _FinalStage iosLastSeenAt(Optional<Integer> iosLastSeenAt);

        _FinalStage iosLastSeenAt(Integer iosLastSeenAt);

        /**
         * <p>The custom attributes which are set for the contact.</p>
         */
        _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

        _FinalStage customAttributes(Map<String, Object> customAttributes);

        /**
         * <p>An image URL containing the avatar of a contact.</p>
         */
        _FinalStage avatar(Optional<String> avatar);

        _FinalStage avatar(String avatar);

        _FinalStage tags(Optional<ContactTags> tags);

        _FinalStage tags(ContactTags tags);

        _FinalStage notes(Optional<ContactNotes> notes);

        _FinalStage notes(ContactNotes notes);

        _FinalStage companies(Optional<ContactCompanies> companies);

        _FinalStage companies(ContactCompanies companies);

        _FinalStage location(Optional<ContactLocation> location);

        _FinalStage location(ContactLocation location);

        _FinalStage socialProfiles(Optional<ContactSocialProfiles> socialProfiles);

        _FinalStage socialProfiles(ContactSocialProfiles socialProfiles);

        /**
         * <p>If the user has enabled push messaging.</p>
         */
        _FinalStage enabledPushMessaging(Optional<Boolean> enabledPushMessaging);

        _FinalStage enabledPushMessaging(Boolean enabledPushMessaging);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    WorkspaceIdStage,
                    RoleStage,
                    HasHardBouncedStage,
                    MarkedEmailAsSpamStage,
                    UnsubscribedFromEmailsStage,
                    CreatedAtStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String id;

        private String workspaceId;

        private String role;

        private boolean hasHardBounced;

        private boolean markedEmailAsSpam;

        private boolean unsubscribedFromEmails;

        private int createdAt;

        private int updatedAt;

        private Optional<Boolean> enabledPushMessaging = Optional.empty();

        private Optional<ContactSocialProfiles> socialProfiles = Optional.empty();

        private Optional<ContactLocation> location = Optional.empty();

        private Optional<ContactCompanies> companies = Optional.empty();

        private Optional<ContactNotes> notes = Optional.empty();

        private Optional<ContactTags> tags = Optional.empty();

        private Optional<String> avatar = Optional.empty();

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        private Optional<Integer> iosLastSeenAt = Optional.empty();

        private Optional<String> iosSdkVersion = Optional.empty();

        private Optional<String> iosOsVersion = Optional.empty();

        private Optional<String> iosDevice = Optional.empty();

        private Optional<String> iosAppVersion = Optional.empty();

        private Optional<String> iosAppName = Optional.empty();

        private Optional<Integer> androidLastSeenAt = Optional.empty();

        private Optional<String> androidSdkVersion = Optional.empty();

        private Optional<String> androidOsVersion = Optional.empty();

        private Optional<String> androidDevice = Optional.empty();

        private Optional<String> androidAppVersion = Optional.empty();

        private Optional<String> androidAppName = Optional.empty();

        private Optional<String> os = Optional.empty();

        private Optional<String> browserLanguage = Optional.empty();

        private Optional<String> browserVersion = Optional.empty();

        private Optional<String> browser = Optional.empty();

        private Optional<String> languageOverride = Optional.empty();

        private Optional<Integer> lastEmailClickedAt = Optional.empty();

        private Optional<Integer> lastEmailOpenedAt = Optional.empty();

        private Optional<Integer> lastContactedAt = Optional.empty();

        private Optional<Integer> lastRepliedAt = Optional.empty();

        private Optional<Integer> lastSeenAt = Optional.empty();

        private Optional<Integer> signedUpAt = Optional.empty();

        private Optional<Integer> ownerId = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> phone = Optional.empty();

        private Optional<String> emailDomain = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContactsMergeLeadInUserResponse other) {
            id(other.getId());
            externalId(other.getExternalId());
            workspaceId(other.getWorkspaceId());
            role(other.getRole());
            email(other.getEmail());
            emailDomain(other.getEmailDomain());
            phone(other.getPhone());
            name(other.getName());
            ownerId(other.getOwnerId());
            hasHardBounced(other.getHasHardBounced());
            markedEmailAsSpam(other.getMarkedEmailAsSpam());
            unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            signedUpAt(other.getSignedUpAt());
            lastSeenAt(other.getLastSeenAt());
            lastRepliedAt(other.getLastRepliedAt());
            lastContactedAt(other.getLastContactedAt());
            lastEmailOpenedAt(other.getLastEmailOpenedAt());
            lastEmailClickedAt(other.getLastEmailClickedAt());
            languageOverride(other.getLanguageOverride());
            browser(other.getBrowser());
            browserVersion(other.getBrowserVersion());
            browserLanguage(other.getBrowserLanguage());
            os(other.getOs());
            androidAppName(other.getAndroidAppName());
            androidAppVersion(other.getAndroidAppVersion());
            androidDevice(other.getAndroidDevice());
            androidOsVersion(other.getAndroidOsVersion());
            androidSdkVersion(other.getAndroidSdkVersion());
            androidLastSeenAt(other.getAndroidLastSeenAt());
            iosAppName(other.getIosAppName());
            iosAppVersion(other.getIosAppVersion());
            iosDevice(other.getIosDevice());
            iosOsVersion(other.getIosOsVersion());
            iosSdkVersion(other.getIosSdkVersion());
            iosLastSeenAt(other.getIosLastSeenAt());
            customAttributes(other.getCustomAttributes());
            avatar(other.getAvatar());
            tags(other.getTags());
            notes(other.getNotes());
            companies(other.getCompanies());
            location(other.getLocation());
            socialProfiles(other.getSocialProfiles());
            enabledPushMessaging(other.getEnabledPushMessaging());
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is given by Intercom.</p>
         * <p>The unique identifier for the contact which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The id of the workspace which the contact belongs to.</p>
         * <p>The id of the workspace which the contact belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public RoleStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * <p>The role of the contact.</p>
         * <p>The role of the contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("role")
        public HasHardBouncedStage role(@NotNull String role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        /**
         * <p>Whether the contact has had an email sent to them hard bounce.</p>
         * <p>Whether the contact has had an email sent to them hard bounce.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("has_hard_bounced")
        public MarkedEmailAsSpamStage hasHardBounced(boolean hasHardBounced) {
            this.hasHardBounced = hasHardBounced;
            return this;
        }

        /**
         * <p>Whether the contact has marked an email sent to them as spam.</p>
         * <p>Whether the contact has marked an email sent to them as spam.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("marked_email_as_spam")
        public UnsubscribedFromEmailsStage markedEmailAsSpam(boolean markedEmailAsSpam) {
            this.markedEmailAsSpam = markedEmailAsSpam;
            return this;
        }

        /**
         * <p>Whether the contact is unsubscribed from emails.</p>
         * <p>Whether the contact is unsubscribed from emails.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("unsubscribed_from_emails")
        public CreatedAtStage unsubscribedFromEmails(boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was created.</p>
         * <p>(UNIX timestamp) The time when the contact was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last updated.</p>
         * <p>(UNIX timestamp) The time when the contact was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>If the user has enabled push messaging.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage enabledPushMessaging(Boolean enabledPushMessaging) {
            this.enabledPushMessaging = Optional.ofNullable(enabledPushMessaging);
            return this;
        }

        /**
         * <p>If the user has enabled push messaging.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "enabled_push_messaging", nulls = Nulls.SKIP)
        public _FinalStage enabledPushMessaging(Optional<Boolean> enabledPushMessaging) {
            this.enabledPushMessaging = enabledPushMessaging;
            return this;
        }

        @java.lang.Override
        public _FinalStage socialProfiles(ContactSocialProfiles socialProfiles) {
            this.socialProfiles = Optional.ofNullable(socialProfiles);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "social_profiles", nulls = Nulls.SKIP)
        public _FinalStage socialProfiles(Optional<ContactSocialProfiles> socialProfiles) {
            this.socialProfiles = socialProfiles;
            return this;
        }

        @java.lang.Override
        public _FinalStage location(ContactLocation location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public _FinalStage location(Optional<ContactLocation> location) {
            this.location = location;
            return this;
        }

        @java.lang.Override
        public _FinalStage companies(ContactCompanies companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public _FinalStage companies(Optional<ContactCompanies> companies) {
            this.companies = companies;
            return this;
        }

        @java.lang.Override
        public _FinalStage notes(ContactNotes notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public _FinalStage notes(Optional<ContactNotes> notes) {
            this.notes = notes;
            return this;
        }

        @java.lang.Override
        public _FinalStage tags(ContactTags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public _FinalStage tags(Optional<ContactTags> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * <p>An image URL containing the avatar of a contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage avatar(String avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        /**
         * <p>An image URL containing the avatar of a contact.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public _FinalStage avatar(Optional<String> avatar) {
            this.avatar = avatar;
            return this;
        }

        /**
         * <p>The custom attributes which are set for the contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        /**
         * <p>The custom attributes which are set for the contact.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The last time the contact used the iOS app.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosLastSeenAt(Integer iosLastSeenAt) {
            this.iosLastSeenAt = Optional.ofNullable(iosLastSeenAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The last time the contact used the iOS app.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage iosLastSeenAt(Optional<Integer> iosLastSeenAt) {
            this.iosLastSeenAt = iosLastSeenAt;
            return this;
        }

        /**
         * <p>The version of the iOS SDK which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosSdkVersion(String iosSdkVersion) {
            this.iosSdkVersion = Optional.ofNullable(iosSdkVersion);
            return this;
        }

        /**
         * <p>The version of the iOS SDK which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_sdk_version", nulls = Nulls.SKIP)
        public _FinalStage iosSdkVersion(Optional<String> iosSdkVersion) {
            this.iosSdkVersion = iosSdkVersion;
            return this;
        }

        /**
         * <p>The version of iOS which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosOsVersion(String iosOsVersion) {
            this.iosOsVersion = Optional.ofNullable(iosOsVersion);
            return this;
        }

        /**
         * <p>The version of iOS which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_os_version", nulls = Nulls.SKIP)
        public _FinalStage iosOsVersion(Optional<String> iosOsVersion) {
            this.iosOsVersion = iosOsVersion;
            return this;
        }

        /**
         * <p>The iOS device which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosDevice(String iosDevice) {
            this.iosDevice = Optional.ofNullable(iosDevice);
            return this;
        }

        /**
         * <p>The iOS device which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_device", nulls = Nulls.SKIP)
        public _FinalStage iosDevice(Optional<String> iosDevice) {
            this.iosDevice = iosDevice;
            return this;
        }

        /**
         * <p>The version of the iOS app which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosAppVersion(String iosAppVersion) {
            this.iosAppVersion = Optional.ofNullable(iosAppVersion);
            return this;
        }

        /**
         * <p>The version of the iOS app which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_app_version", nulls = Nulls.SKIP)
        public _FinalStage iosAppVersion(Optional<String> iosAppVersion) {
            this.iosAppVersion = iosAppVersion;
            return this;
        }

        /**
         * <p>The name of the iOS app which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iosAppName(String iosAppName) {
            this.iosAppName = Optional.ofNullable(iosAppName);
            return this;
        }

        /**
         * <p>The name of the iOS app which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ios_app_name", nulls = Nulls.SKIP)
        public _FinalStage iosAppName(Optional<String> iosAppName) {
            this.iosAppName = iosAppName;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen on an Android device.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidLastSeenAt(Integer androidLastSeenAt) {
            this.androidLastSeenAt = Optional.ofNullable(androidLastSeenAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen on an Android device.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage androidLastSeenAt(Optional<Integer> androidLastSeenAt) {
            this.androidLastSeenAt = androidLastSeenAt;
            return this;
        }

        /**
         * <p>The version of the Android SDK which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidSdkVersion(String androidSdkVersion) {
            this.androidSdkVersion = Optional.ofNullable(androidSdkVersion);
            return this;
        }

        /**
         * <p>The version of the Android SDK which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_sdk_version", nulls = Nulls.SKIP)
        public _FinalStage androidSdkVersion(Optional<String> androidSdkVersion) {
            this.androidSdkVersion = androidSdkVersion;
            return this;
        }

        /**
         * <p>The version of the Android OS which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidOsVersion(String androidOsVersion) {
            this.androidOsVersion = Optional.ofNullable(androidOsVersion);
            return this;
        }

        /**
         * <p>The version of the Android OS which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_os_version", nulls = Nulls.SKIP)
        public _FinalStage androidOsVersion(Optional<String> androidOsVersion) {
            this.androidOsVersion = androidOsVersion;
            return this;
        }

        /**
         * <p>The Android device which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidDevice(String androidDevice) {
            this.androidDevice = Optional.ofNullable(androidDevice);
            return this;
        }

        /**
         * <p>The Android device which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_device", nulls = Nulls.SKIP)
        public _FinalStage androidDevice(Optional<String> androidDevice) {
            this.androidDevice = androidDevice;
            return this;
        }

        /**
         * <p>The version of the Android app which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidAppVersion(String androidAppVersion) {
            this.androidAppVersion = Optional.ofNullable(androidAppVersion);
            return this;
        }

        /**
         * <p>The version of the Android app which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_app_version", nulls = Nulls.SKIP)
        public _FinalStage androidAppVersion(Optional<String> androidAppVersion) {
            this.androidAppVersion = androidAppVersion;
            return this;
        }

        /**
         * <p>The name of the Android app which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage androidAppName(String androidAppName) {
            this.androidAppName = Optional.ofNullable(androidAppName);
            return this;
        }

        /**
         * <p>The name of the Android app which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "android_app_name", nulls = Nulls.SKIP)
        public _FinalStage androidAppName(Optional<String> androidAppName) {
            this.androidAppName = androidAppName;
            return this;
        }

        /**
         * <p>The operating system which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage os(String os) {
            this.os = Optional.ofNullable(os);
            return this;
        }

        /**
         * <p>The operating system which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "os", nulls = Nulls.SKIP)
        public _FinalStage os(Optional<String> os) {
            this.os = os;
            return this;
        }

        /**
         * <p>The language set by the browser which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage browserLanguage(String browserLanguage) {
            this.browserLanguage = Optional.ofNullable(browserLanguage);
            return this;
        }

        /**
         * <p>The language set by the browser which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "browser_language", nulls = Nulls.SKIP)
        public _FinalStage browserLanguage(Optional<String> browserLanguage) {
            this.browserLanguage = browserLanguage;
            return this;
        }

        /**
         * <p>The version of the browser which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage browserVersion(String browserVersion) {
            this.browserVersion = Optional.ofNullable(browserVersion);
            return this;
        }

        /**
         * <p>The version of the browser which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "browser_version", nulls = Nulls.SKIP)
        public _FinalStage browserVersion(Optional<String> browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        /**
         * <p>The name of the browser which the contact is using.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage browser(String browser) {
            this.browser = Optional.ofNullable(browser);
            return this;
        }

        /**
         * <p>The name of the browser which the contact is using.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "browser", nulls = Nulls.SKIP)
        public _FinalStage browser(Optional<String> browser) {
            this.browser = browser;
            return this;
        }

        /**
         * <p>A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage languageOverride(String languageOverride) {
            this.languageOverride = Optional.ofNullable(languageOverride);
            return this;
        }

        /**
         * <p>A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "language_override", nulls = Nulls.SKIP)
        public _FinalStage languageOverride(Optional<String> languageOverride) {
            this.languageOverride = languageOverride;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last clicked a link in an email.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastEmailClickedAt(Integer lastEmailClickedAt) {
            this.lastEmailClickedAt = Optional.ofNullable(lastEmailClickedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last clicked a link in an email.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_email_clicked_at", nulls = Nulls.SKIP)
        public _FinalStage lastEmailClickedAt(Optional<Integer> lastEmailClickedAt) {
            this.lastEmailClickedAt = lastEmailClickedAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last opened an email.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastEmailOpenedAt(Integer lastEmailOpenedAt) {
            this.lastEmailOpenedAt = Optional.ofNullable(lastEmailOpenedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last opened an email.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_email_opened_at", nulls = Nulls.SKIP)
        public _FinalStage lastEmailOpenedAt(Optional<Integer> lastEmailOpenedAt) {
            this.lastEmailOpenedAt = lastEmailOpenedAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last messaged.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastContactedAt(Integer lastContactedAt) {
            this.lastContactedAt = Optional.ofNullable(lastContactedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last messaged.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_contacted_at", nulls = Nulls.SKIP)
        public _FinalStage lastContactedAt(Optional<Integer> lastContactedAt) {
            this.lastContactedAt = lastContactedAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last messaged in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastRepliedAt(Integer lastRepliedAt) {
            this.lastRepliedAt = Optional.ofNullable(lastRepliedAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact last messaged in.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_replied_at", nulls = Nulls.SKIP)
        public _FinalStage lastRepliedAt(Optional<Integer> lastRepliedAt) {
            this.lastRepliedAt = lastRepliedAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastSeenAt(Integer lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time specified for when a contact signed up.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        /**
         * <p>(UNIX timestamp) The time specified for when a contact signed up.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
        public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public _FinalStage ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * <p>The contacts name.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The contacts name.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        /**
         * <p>The contacts phone.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        /**
         * <p>The contacts phone.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "phone", nulls = Nulls.SKIP)
        public _FinalStage phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        /**
         * <p>The contact's email domain.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage emailDomain(String emailDomain) {
            this.emailDomain = Optional.ofNullable(emailDomain);
            return this;
        }

        /**
         * <p>The contact's email domain.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email_domain", nulls = Nulls.SKIP)
        public _FinalStage emailDomain(Optional<String> emailDomain) {
            this.emailDomain = emailDomain;
            return this;
        }

        /**
         * <p>The contact's email.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The contact's email.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @java.lang.Override
        public ContactsMergeLeadInUserResponse build() {
            return new ContactsMergeLeadInUserResponse(
                    id,
                    externalId,
                    workspaceId,
                    role,
                    email,
                    emailDomain,
                    phone,
                    name,
                    ownerId,
                    hasHardBounced,
                    markedEmailAsSpam,
                    unsubscribedFromEmails,
                    createdAt,
                    updatedAt,
                    signedUpAt,
                    lastSeenAt,
                    lastRepliedAt,
                    lastContactedAt,
                    lastEmailOpenedAt,
                    lastEmailClickedAt,
                    languageOverride,
                    browser,
                    browserVersion,
                    browserLanguage,
                    os,
                    androidAppName,
                    androidAppVersion,
                    androidDevice,
                    androidOsVersion,
                    androidSdkVersion,
                    androidLastSeenAt,
                    iosAppName,
                    iosAppVersion,
                    iosDevice,
                    iosOsVersion,
                    iosSdkVersion,
                    iosLastSeenAt,
                    customAttributes,
                    avatar,
                    tags,
                    notes,
                    companies,
                    location,
                    socialProfiles,
                    enabledPushMessaging,
                    additionalProperties);
        }
    }
}
