/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetCustomObjectInstancesByExternalIdRequest.Builder.class)
public final class GetCustomObjectInstancesByExternalIdRequest {
    private final String customObjectTypeIdentifier;

    private final String externalId;

    private final Map<String, Object> additionalProperties;

    private GetCustomObjectInstancesByExternalIdRequest(
            String customObjectTypeIdentifier, String externalId, Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of the custom object type that defines the structure of the custom object instance.
     */
    @JsonProperty("custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return customObjectTypeIdentifier;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetCustomObjectInstancesByExternalIdRequest
                && equalTo((GetCustomObjectInstancesByExternalIdRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomObjectInstancesByExternalIdRequest other) {
        return customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier)
                && externalId.equals(other.externalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.externalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    public interface CustomObjectTypeIdentifierStage {
        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         */
        ExternalIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier);

        Builder from(GetCustomObjectInstancesByExternalIdRequest other);
    }

    public interface ExternalIdStage {
        _FinalStage externalId(@NotNull String externalId);
    }

    public interface _FinalStage {
        GetCustomObjectInstancesByExternalIdRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CustomObjectTypeIdentifierStage, ExternalIdStage, _FinalStage {
        private String customObjectTypeIdentifier;

        private String externalId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GetCustomObjectInstancesByExternalIdRequest other) {
            customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            externalId(other.getExternalId());
            return this;
        }

        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("custom_object_type_identifier")
        public ExternalIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier =
                    Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        public GetCustomObjectInstancesByExternalIdRequest build() {
            return new GetCustomObjectInstancesByExternalIdRequest(
                    customObjectTypeIdentifier, externalId, additionalProperties);
        }
    }
}
