/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.ipallowlist;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.types.IpAllowlist;

public class IpAllowlistClient {
    protected final ClientOptions clientOptions;

    private final RawIpAllowlistClient rawClient;

    public IpAllowlistClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawIpAllowlistClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawIpAllowlistClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public IpAllowlist getIpAllowlist() {
        return this.rawClient.getIpAllowlist().body();
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public IpAllowlist getIpAllowlist(RequestOptions requestOptions) {
        return this.rawClient.getIpAllowlist(requestOptions).body();
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IpAllowlist updateIpAllowlist() {
        return this.rawClient.updateIpAllowlist().body();
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IpAllowlist updateIpAllowlist(IpAllowlist request) {
        return this.rawClient.updateIpAllowlist(request).body();
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IpAllowlist updateIpAllowlist(IpAllowlist request, RequestOptions requestOptions) {
        return this.rawClient.updateIpAllowlist(request, requestOptions).body();
    }
}
