/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.ipallowlist;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.errors.UnprocessableEntityError;
import com.intercom.api.types.Error;
import com.intercom.api.types.IpAllowlist;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawIpAllowlistClient {
    protected final ClientOptions clientOptions;

    public RawIpAllowlistClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public IntercomHttpResponse<IpAllowlist> getIpAllowlist() {
        return getIpAllowlist(null);
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public IntercomHttpResponse<IpAllowlist> getIpAllowlist(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("ip_allowlist")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, IpAllowlist.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<IpAllowlist> updateIpAllowlist() {
        return updateIpAllowlist(IpAllowlist.builder().build());
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<IpAllowlist> updateIpAllowlist(IpAllowlist request) {
        return updateIpAllowlist(request, null);
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<IpAllowlist> updateIpAllowlist(IpAllowlist request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("ip_allowlist")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, IpAllowlist.class), response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 422:
                        throw new UnprocessableEntityError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
