/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.messages.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Message.Builder.class)
public final class Message {
    private final String type;

    private final String id;

    private final int createdAt;

    private final Optional<String> subject;

    private final String body;

    private final MessageType messageType;

    private final String conversationId;

    private final Map<String, Object> additionalProperties;

    private Message(
            String type,
            String id,
            int createdAt,
            Optional<String> subject,
            String body,
            MessageType messageType,
            String conversationId,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.createdAt = createdAt;
        this.subject = subject;
        this.body = body;
        this.messageType = messageType;
        this.conversationId = conversationId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the message
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id representing the message.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The time the conversation was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The subject of the message. Only present if message_type: email.
     */
    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return subject;
    }

    /**
     * @return The message body, which may contain HTML.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * @return The type of message that was sent. Can be email, inapp, facebook or twitter.
     */
    @JsonProperty("message_type")
    public MessageType getMessageType() {
        return messageType;
    }

    /**
     * @return The associated conversation_id
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Message && equalTo((Message) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Message other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && createdAt == other.createdAt
                && subject.equals(other.subject)
                && body.equals(other.body)
                && messageType.equals(other.messageType)
                && conversationId.equals(other.conversationId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type, this.id, this.createdAt, this.subject, this.body, this.messageType, this.conversationId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>The type of the message</p>
         */
        IdStage type(@NotNull String type);

        Builder from(Message other);
    }

    public interface IdStage {
        /**
         * <p>The id representing the message.</p>
         */
        CreatedAtStage id(@NotNull String id);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time the conversation was created.</p>
         */
        BodyStage createdAt(int createdAt);
    }

    public interface BodyStage {
        /**
         * <p>The message body, which may contain HTML.</p>
         */
        MessageTypeStage body(@NotNull String body);
    }

    public interface MessageTypeStage {
        /**
         * <p>The type of message that was sent. Can be email, inapp, facebook or twitter.</p>
         */
        ConversationIdStage messageType(@NotNull MessageType messageType);
    }

    public interface ConversationIdStage {
        /**
         * <p>The associated conversation_id</p>
         */
        _FinalStage conversationId(@NotNull String conversationId);
    }

    public interface _FinalStage {
        Message build();

        /**
         * <p>The subject of the message. Only present if message_type: email.</p>
         */
        _FinalStage subject(Optional<String> subject);

        _FinalStage subject(String subject);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements TypeStage,
                    IdStage,
                    CreatedAtStage,
                    BodyStage,
                    MessageTypeStage,
                    ConversationIdStage,
                    _FinalStage {
        private String type;

        private String id;

        private int createdAt;

        private String body;

        private MessageType messageType;

        private String conversationId;

        private Optional<String> subject = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Message other) {
            type(other.getType());
            id(other.getId());
            createdAt(other.getCreatedAt());
            subject(other.getSubject());
            body(other.getBody());
            messageType(other.getMessageType());
            conversationId(other.getConversationId());
            return this;
        }

        /**
         * <p>The type of the message</p>
         * <p>The type of the message</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The id representing the message.</p>
         * <p>The id representing the message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The time the conversation was created.</p>
         * <p>The time the conversation was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public BodyStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         * <p>The message body, which may contain HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public MessageTypeStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * <p>The type of message that was sent. Can be email, inapp, facebook or twitter.</p>
         * <p>The type of message that was sent. Can be email, inapp, facebook or twitter.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("message_type")
        public ConversationIdStage messageType(@NotNull MessageType messageType) {
            this.messageType = Objects.requireNonNull(messageType, "messageType must not be null");
            return this;
        }

        /**
         * <p>The associated conversation_id</p>
         * <p>The associated conversation_id</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        /**
         * <p>The subject of the message. Only present if message_type: email.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        /**
         * <p>The subject of the message. Only present if message_type: email.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "subject", nulls = Nulls.SKIP)
        public _FinalStage subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        @java.lang.Override
        public Message build() {
            return new Message(type, id, createdAt, subject, body, messageType, conversationId, additionalProperties);
        }
    }

    public static final class MessageType {
        public static final MessageType EMAIL = new MessageType(Value.EMAIL, "email");

        public static final MessageType FACEBOOK = new MessageType(Value.FACEBOOK, "facebook");

        public static final MessageType INAPP = new MessageType(Value.INAPP, "inapp");

        public static final MessageType TWITTER = new MessageType(Value.TWITTER, "twitter");

        private final Value value;

        private final String string;

        MessageType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof MessageType && this.string.equals(((MessageType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case EMAIL:
                    return visitor.visitEmail();
                case FACEBOOK:
                    return visitor.visitFacebook();
                case INAPP:
                    return visitor.visitInapp();
                case TWITTER:
                    return visitor.visitTwitter();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static MessageType valueOf(String value) {
            switch (value) {
                case "email":
                    return EMAIL;
                case "facebook":
                    return FACEBOOK;
                case "inapp":
                    return INAPP;
                case "twitter":
                    return TWITTER;
                default:
                    return new MessageType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            EMAIL,

            INAPP,

            FACEBOOK,

            TWITTER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEmail();

            T visitInapp();

            T visitFacebook();

            T visitTwitter();

            T visitUnknown(String unknownType);
        }
    }
}
