/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.feeds;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.news.feeds.requests.FindNewsFeedRequest;
import com.intercom.api.resources.news.feeds.requests.ListNewsFeedItemsRequest;
import com.intercom.api.resources.news.types.Newsfeed;
import com.intercom.api.types.PaginatedResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncFeedsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawFeedsClient rawClient;

    public AsyncFeedsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFeedsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawFeedsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all news items that are live on a given newsfeed
     */
    public CompletableFuture<PaginatedResponse> listItems(ListNewsFeedItemsRequest request) {
        return this.rawClient.listItems(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all news items that are live on a given newsfeed
     */
    public CompletableFuture<PaginatedResponse> listItems(
            ListNewsFeedItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listItems(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all newsfeeds
     */
    public CompletableFuture<PaginatedResponse> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all newsfeeds
     */
    public CompletableFuture<PaginatedResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single newsfeed
     */
    public CompletableFuture<Newsfeed> find(FindNewsFeedRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single newsfeed
     */
    public CompletableFuture<Newsfeed> find(FindNewsFeedRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }
}
