/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NewsItem.Builder.class)
public final class NewsItem {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> workspaceId;

    private final Optional<String> title;

    private final Optional<String> body;

    private final Optional<Integer> senderId;

    private final Optional<State> state;

    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;

    private final Optional<List<Optional<String>>> labels;

    private final Optional<String> coverImageUrl;

    private final Optional<List<Optional<String>>> reactions;

    private final Optional<Boolean> deliverSilently;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private NewsItem(
            Optional<String> type,
            Optional<String> id,
            Optional<String> workspaceId,
            Optional<String> title,
            Optional<String> body,
            Optional<Integer> senderId,
            Optional<State> state,
            Optional<List<NewsfeedAssignment>> newsfeedAssignments,
            Optional<List<Optional<String>>> labels,
            Optional<String> coverImageUrl,
            Optional<List<Optional<String>>> reactions,
            Optional<Boolean> deliverSilently,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.newsfeedAssignments = newsfeedAssignments;
        this.labels = labels;
        this.coverImageUrl = coverImageUrl;
        this.reactions = reactions;
        this.deliverSilently = deliverSilently;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the news item which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the news item belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The title of the news item.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The news item body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the sender of the news item. Must be a teammate on the workspace.
     */
    @JsonProperty("sender_id")
    public Optional<Integer> getSenderId() {
        return senderId;
    }

    /**
     * @return News items will not be visible to your users in the assigned newsfeeds until they are set live.
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return A list of newsfeed_assignments to assign to the specified newsfeed.
     */
    @JsonProperty("newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return newsfeedAssignments;
    }

    /**
     * @return Label names displayed to users to categorize the news item.
     */
    @JsonProperty("labels")
    public Optional<List<Optional<String>>> getLabels() {
        return labels;
    }

    /**
     * @return URL of the image used as cover. Must have .jpg or .png extension.
     */
    @JsonProperty("cover_image_url")
    public Optional<String> getCoverImageUrl() {
        return coverImageUrl;
    }

    /**
     * @return Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
     */
    @JsonProperty("reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return reactions;
    }

    /**
     * @return When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.
     */
    @JsonProperty("deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return deliverSilently;
    }

    /**
     * @return Timestamp for when the news item was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Timestamp for when the news item was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NewsItem && equalTo((NewsItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItem other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && title.equals(other.title)
                && body.equals(other.body)
                && senderId.equals(other.senderId)
                && state.equals(other.state)
                && newsfeedAssignments.equals(other.newsfeedAssignments)
                && labels.equals(other.labels)
                && coverImageUrl.equals(other.coverImageUrl)
                && reactions.equals(other.reactions)
                && deliverSilently.equals(other.deliverSilently)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.workspaceId,
                this.title,
                this.body,
                this.senderId,
                this.state,
                this.newsfeedAssignments,
                this.labels,
                this.coverImageUrl,
                this.reactions,
                this.deliverSilently,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<Integer> senderId = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();

        private Optional<List<Optional<String>>> labels = Optional.empty();

        private Optional<String> coverImageUrl = Optional.empty();

        private Optional<List<Optional<String>>> reactions = Optional.empty();

        private Optional<Boolean> deliverSilently = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(NewsItem other) {
            type(other.getType());
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            title(other.getTitle());
            body(other.getBody());
            senderId(other.getSenderId());
            state(other.getState());
            newsfeedAssignments(other.getNewsfeedAssignments());
            labels(other.getLabels());
            coverImageUrl(other.getCoverImageUrl());
            reactions(other.getReactions());
            deliverSilently(other.getDeliverSilently());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>The type of object.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of the workspace which the news item belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The title of the news item.</p>
         */
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The news item body, which may contain HTML.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The id of the sender of the news item. Must be a teammate on the workspace.</p>
         */
        @JsonSetter(value = "sender_id", nulls = Nulls.SKIP)
        public Builder senderId(Optional<Integer> senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(Integer senderId) {
            this.senderId = Optional.ofNullable(senderId);
            return this;
        }

        /**
         * <p>News items will not be visible to your users in the assigned newsfeeds until they are set live.</p>
         */
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>A list of newsfeed_assignments to assign to the specified newsfeed.</p>
         */
        @JsonSetter(value = "newsfeed_assignments", nulls = Nulls.SKIP)
        public Builder newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        public Builder newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        /**
         * <p>Label names displayed to users to categorize the news item.</p>
         */
        @JsonSetter(value = "labels", nulls = Nulls.SKIP)
        public Builder labels(Optional<List<Optional<String>>> labels) {
            this.labels = labels;
            return this;
        }

        public Builder labels(List<Optional<String>> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        /**
         * <p>URL of the image used as cover. Must have .jpg or .png extension.</p>
         */
        @JsonSetter(value = "cover_image_url", nulls = Nulls.SKIP)
        public Builder coverImageUrl(Optional<String> coverImageUrl) {
            this.coverImageUrl = coverImageUrl;
            return this;
        }

        public Builder coverImageUrl(String coverImageUrl) {
            this.coverImageUrl = Optional.ofNullable(coverImageUrl);
            return this;
        }

        /**
         * <p>Ordered list of emoji reactions to the news item. When empty, reactions are disabled.</p>
         */
        @JsonSetter(value = "reactions", nulls = Nulls.SKIP)
        public Builder reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        public Builder reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        /**
         * <p>When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.</p>
         */
        @JsonSetter(value = "deliver_silently", nulls = Nulls.SKIP)
        public Builder deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        public Builder deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        /**
         * <p>Timestamp for when the news item was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>Timestamp for when the news item was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public NewsItem build() {
            return new NewsItem(
                    type,
                    id,
                    workspaceId,
                    title,
                    body,
                    senderId,
                    state,
                    newsfeedAssignments,
                    labels,
                    coverImageUrl,
                    reactions,
                    deliverSilently,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIVE:
                    return visitor.visitLive();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live":
                    return LIVE;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            DRAFT,

            LIVE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitDraft();

            T visitLive();

            T visitUnknown(String unknownType);
        }
    }
}
