/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.LinkedObjectList;
import com.intercom.api.types.TicketParts;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Ticket.Builder.class)
public final class Ticket {
    private final String id;

    private final String ticketId;

    private final Category category;

    private final Map<String, Object> ticketAttributes;

    private final Optional<TicketState> ticketState;

    private final Optional<TicketType> ticketType;

    private final TicketContacts contacts;

    private final Optional<String> adminAssigneeId;

    private final Optional<String> teamAssigneeId;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Boolean> open;

    private final Optional<Integer> snoozedUntil;

    private final Optional<LinkedObjectList> linkedObjects;

    private final Optional<TicketParts> ticketParts;

    private final Optional<Boolean> isShared;

    private final Map<String, Object> additionalProperties;

    private Ticket(
            String id,
            String ticketId,
            Category category,
            Map<String, Object> ticketAttributes,
            Optional<TicketState> ticketState,
            Optional<TicketType> ticketType,
            TicketContacts contacts,
            Optional<String> adminAssigneeId,
            Optional<String> teamAssigneeId,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<Boolean> open,
            Optional<Integer> snoozedUntil,
            Optional<LinkedObjectList> linkedObjects,
            Optional<TicketParts> ticketParts,
            Optional<Boolean> isShared,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.ticketId = ticketId;
        this.category = category;
        this.ticketAttributes = ticketAttributes;
        this.ticketState = ticketState;
        this.ticketType = ticketType;
        this.contacts = contacts;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.open = open;
        this.snoozedUntil = snoozedUntil;
        this.linkedObjects = linkedObjects;
        this.ticketParts = ticketParts;
        this.isShared = isShared;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket";
    }

    /**
     * @return The unique identifier for the ticket which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.
     */
    @JsonProperty("ticket_id")
    public String getTicketId() {
        return ticketId;
    }

    /**
     * @return Category of the Ticket.
     */
    @JsonProperty("category")
    public Category getCategory() {
        return category;
    }

    @JsonProperty("ticket_attributes")
    public Map<String, Object> getTicketAttributes() {
        return ticketAttributes;
    }

    @JsonProperty("ticket_state")
    public Optional<TicketState> getTicketState() {
        return ticketState;
    }

    @JsonProperty("ticket_type")
    public Optional<TicketType> getTicketType() {
        return ticketType;
    }

    @JsonProperty("contacts")
    public TicketContacts getContacts() {
        return contacts;
    }

    /**
     * @return The id representing the admin assigned to the ticket.
     */
    @JsonProperty("admin_assignee_id")
    public Optional<String> getAdminAssigneeId() {
        return adminAssigneeId;
    }

    /**
     * @return The id representing the team assigned to the ticket.
     */
    @JsonProperty("team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return teamAssigneeId;
    }

    /**
     * @return The time the ticket was created as a UTC Unix timestamp.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the ticket was updated as a UTC Unix timestamp.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Whether or not the ticket is open. If false, the ticket is closed.
     */
    @JsonProperty("open")
    public Optional<Boolean> getOpen() {
        return open;
    }

    /**
     * @return The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.
     */
    @JsonProperty("snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return snoozedUntil;
    }

    @JsonProperty("linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return linkedObjects;
    }

    @JsonProperty("ticket_parts")
    public Optional<TicketParts> getTicketParts() {
        return ticketParts;
    }

    /**
     * @return Whether or not the ticket is shared with the customer.
     */
    @JsonProperty("is_shared")
    public Optional<Boolean> getIsShared() {
        return isShared;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Ticket && equalTo((Ticket) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Ticket other) {
        return id.equals(other.id)
                && ticketId.equals(other.ticketId)
                && category.equals(other.category)
                && ticketAttributes.equals(other.ticketAttributes)
                && ticketState.equals(other.ticketState)
                && ticketType.equals(other.ticketType)
                && contacts.equals(other.contacts)
                && adminAssigneeId.equals(other.adminAssigneeId)
                && teamAssigneeId.equals(other.teamAssigneeId)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && open.equals(other.open)
                && snoozedUntil.equals(other.snoozedUntil)
                && linkedObjects.equals(other.linkedObjects)
                && ticketParts.equals(other.ticketParts)
                && isShared.equals(other.isShared);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.ticketId,
                this.category,
                this.ticketAttributes,
                this.ticketState,
                this.ticketType,
                this.contacts,
                this.adminAssigneeId,
                this.teamAssigneeId,
                this.createdAt,
                this.updatedAt,
                this.open,
                this.snoozedUntil,
                this.linkedObjects,
                this.ticketParts,
                this.isShared);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         */
        TicketIdStage id(@NotNull String id);

        Builder from(Ticket other);
    }

    public interface TicketIdStage {
        /**
         * <p>The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.</p>
         */
        CategoryStage ticketId(@NotNull String ticketId);
    }

    public interface CategoryStage {
        /**
         * <p>Category of the Ticket.</p>
         */
        ContactsStage category(@NotNull Category category);
    }

    public interface ContactsStage {
        _FinalStage contacts(@NotNull TicketContacts contacts);
    }

    public interface _FinalStage {
        Ticket build();

        _FinalStage ticketAttributes(Map<String, Object> ticketAttributes);

        _FinalStage putAllTicketAttributes(Map<String, Object> ticketAttributes);

        _FinalStage ticketAttributes(String key, Object value);

        _FinalStage ticketState(Optional<TicketState> ticketState);

        _FinalStage ticketState(TicketState ticketState);

        _FinalStage ticketType(Optional<TicketType> ticketType);

        _FinalStage ticketType(TicketType ticketType);

        /**
         * <p>The id representing the admin assigned to the ticket.</p>
         */
        _FinalStage adminAssigneeId(Optional<String> adminAssigneeId);

        _FinalStage adminAssigneeId(String adminAssigneeId);

        /**
         * <p>The id representing the team assigned to the ticket.</p>
         */
        _FinalStage teamAssigneeId(Optional<String> teamAssigneeId);

        _FinalStage teamAssigneeId(String teamAssigneeId);

        /**
         * <p>The time the ticket was created as a UTC Unix timestamp.</p>
         */
        _FinalStage createdAt(Optional<Integer> createdAt);

        _FinalStage createdAt(Integer createdAt);

        /**
         * <p>The last time the ticket was updated as a UTC Unix timestamp.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>Whether or not the ticket is open. If false, the ticket is closed.</p>
         */
        _FinalStage open(Optional<Boolean> open);

        _FinalStage open(Boolean open);

        /**
         * <p>The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.</p>
         */
        _FinalStage snoozedUntil(Optional<Integer> snoozedUntil);

        _FinalStage snoozedUntil(Integer snoozedUntil);

        _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects);

        _FinalStage linkedObjects(LinkedObjectList linkedObjects);

        _FinalStage ticketParts(Optional<TicketParts> ticketParts);

        _FinalStage ticketParts(TicketParts ticketParts);

        /**
         * <p>Whether or not the ticket is shared with the customer.</p>
         */
        _FinalStage isShared(Optional<Boolean> isShared);

        _FinalStage isShared(Boolean isShared);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TicketIdStage, CategoryStage, ContactsStage, _FinalStage {
        private String id;

        private String ticketId;

        private Category category;

        private TicketContacts contacts;

        private Optional<Boolean> isShared = Optional.empty();

        private Optional<TicketParts> ticketParts = Optional.empty();

        private Optional<LinkedObjectList> linkedObjects = Optional.empty();

        private Optional<Integer> snoozedUntil = Optional.empty();

        private Optional<Boolean> open = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<String> teamAssigneeId = Optional.empty();

        private Optional<String> adminAssigneeId = Optional.empty();

        private Optional<TicketType> ticketType = Optional.empty();

        private Optional<TicketState> ticketState = Optional.empty();

        private Map<String, Object> ticketAttributes = new LinkedHashMap<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Ticket other) {
            id(other.getId());
            ticketId(other.getTicketId());
            category(other.getCategory());
            ticketAttributes(other.getTicketAttributes());
            ticketState(other.getTicketState());
            ticketType(other.getTicketType());
            contacts(other.getContacts());
            adminAssigneeId(other.getAdminAssigneeId());
            teamAssigneeId(other.getTeamAssigneeId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            open(other.getOpen());
            snoozedUntil(other.getSnoozedUntil());
            linkedObjects(other.getLinkedObjects());
            ticketParts(other.getTicketParts());
            isShared(other.getIsShared());
            return this;
        }

        /**
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TicketIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.</p>
         * <p>The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_id")
        public CategoryStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        /**
         * <p>Category of the Ticket.</p>
         * <p>Category of the Ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("category")
        public ContactsStage category(@NotNull Category category) {
            this.category = Objects.requireNonNull(category, "category must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("contacts")
        public _FinalStage contacts(@NotNull TicketContacts contacts) {
            this.contacts = Objects.requireNonNull(contacts, "contacts must not be null");
            return this;
        }

        /**
         * <p>Whether or not the ticket is shared with the customer.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        /**
         * <p>Whether or not the ticket is shared with the customer.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "is_shared", nulls = Nulls.SKIP)
        public _FinalStage isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        @java.lang.Override
        public _FinalStage ticketParts(TicketParts ticketParts) {
            this.ticketParts = Optional.ofNullable(ticketParts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ticket_parts", nulls = Nulls.SKIP)
        public _FinalStage ticketParts(Optional<TicketParts> ticketParts) {
            this.ticketParts = ticketParts;
            return this;
        }

        @java.lang.Override
        public _FinalStage linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "linked_objects", nulls = Nulls.SKIP)
        public _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        /**
         * <p>The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        /**
         * <p>The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "snoozed_until", nulls = Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        /**
         * <p>Whether or not the ticket is open. If false, the ticket is closed.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        /**
         * <p>Whether or not the ticket is open. If false, the ticket is closed.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "open", nulls = Nulls.SKIP)
        public _FinalStage open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        /**
         * <p>The last time the ticket was updated as a UTC Unix timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The last time the ticket was updated as a UTC Unix timestamp.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The time the ticket was created as a UTC Unix timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the ticket was created as a UTC Unix timestamp.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The id representing the team assigned to the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        /**
         * <p>The id representing the team assigned to the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "team_assignee_id", nulls = Nulls.SKIP)
        public _FinalStage teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        /**
         * <p>The id representing the admin assigned to the ticket.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminAssigneeId(String adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        /**
         * <p>The id representing the admin assigned to the ticket.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_assignee_id", nulls = Nulls.SKIP)
        public _FinalStage adminAssigneeId(Optional<String> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        @java.lang.Override
        public _FinalStage ticketType(TicketType ticketType) {
            this.ticketType = Optional.ofNullable(ticketType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ticket_type", nulls = Nulls.SKIP)
        public _FinalStage ticketType(Optional<TicketType> ticketType) {
            this.ticketType = ticketType;
            return this;
        }

        @java.lang.Override
        public _FinalStage ticketState(TicketState ticketState) {
            this.ticketState = Optional.ofNullable(ticketState);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ticket_state", nulls = Nulls.SKIP)
        public _FinalStage ticketState(Optional<TicketState> ticketState) {
            this.ticketState = ticketState;
            return this;
        }

        @java.lang.Override
        public _FinalStage ticketAttributes(String key, Object value) {
            this.ticketAttributes.put(key, value);
            return this;
        }

        @java.lang.Override
        public _FinalStage putAllTicketAttributes(Map<String, Object> ticketAttributes) {
            if (ticketAttributes != null) {
                this.ticketAttributes.putAll(ticketAttributes);
            }
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ticket_attributes", nulls = Nulls.SKIP)
        public _FinalStage ticketAttributes(Map<String, Object> ticketAttributes) {
            this.ticketAttributes.clear();
            if (ticketAttributes != null) {
                this.ticketAttributes.putAll(ticketAttributes);
            }
            return this;
        }

        @java.lang.Override
        public Ticket build() {
            return new Ticket(
                    id,
                    ticketId,
                    category,
                    ticketAttributes,
                    ticketState,
                    ticketType,
                    contacts,
                    adminAssigneeId,
                    teamAssigneeId,
                    createdAt,
                    updatedAt,
                    open,
                    snoozedUntil,
                    linkedObjects,
                    ticketParts,
                    isShared,
                    additionalProperties);
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");

        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");

        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BACK_OFFICE:
                    return visitor.visitBackOffice();
                case CUSTOMER:
                    return visitor.visitCustomer();
                case TRACKER:
                    return visitor.visitTracker();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office":
                    return BACK_OFFICE;
                case "Customer":
                    return CUSTOMER;
                case "Tracker":
                    return TRACKER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CUSTOMER,

            BACK_OFFICE,

            TRACKER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCustomer();

            T visitBackOffice();

            T visitTracker();

            T visitUnknown(String unknownType);
        }
    }
}
