/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.brands.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Brand.Builder.class)
public final class Brand {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<Boolean> isDefault;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> helpCenterId;

    private final Optional<String> defaultAddressSettingsId;

    private final Map<String, Object> additionalProperties;

    private Brand(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<Boolean> isDefault,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> helpCenterId,
            Optional<String> defaultAddressSettingsId,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.isDefault = isDefault;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.helpCenterId = helpCenterId;
        this.defaultAddressSettingsId = defaultAddressSettingsId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Unique brand identifier. For default brand, matches the workspace ID
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Display name of the brand
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return Whether this is the workspace's default brand
     */
    @JsonProperty("is_default")
    public Optional<Boolean> getIsDefault() {
        return isDefault;
    }

    /**
     * @return Unix timestamp of brand creation
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Unix timestamp of last modification
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Associated help center identifier
     */
    @JsonProperty("help_center_id")
    public Optional<String> getHelpCenterId() {
        return helpCenterId;
    }

    /**
     * @return Default email settings ID for this brand
     */
    @JsonProperty("default_address_settings_id")
    public Optional<String> getDefaultAddressSettingsId() {
        return defaultAddressSettingsId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Brand && equalTo((Brand) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Brand other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && isDefault.equals(other.isDefault)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && helpCenterId.equals(other.helpCenterId)
                && defaultAddressSettingsId.equals(other.defaultAddressSettingsId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.isDefault,
                this.createdAt,
                this.updatedAt,
                this.helpCenterId,
                this.defaultAddressSettingsId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<Boolean> isDefault = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> helpCenterId = Optional.empty();

        private Optional<String> defaultAddressSettingsId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Brand other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            isDefault(other.getIsDefault());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            helpCenterId(other.getHelpCenterId());
            defaultAddressSettingsId(other.getDefaultAddressSettingsId());
            return this;
        }

        /**
         * <p>The type of object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Unique brand identifier. For default brand, matches the workspace ID</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Display name of the brand</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>Whether this is the workspace's default brand</p>
         */
        @JsonSetter(value = "is_default", nulls = Nulls.SKIP)
        public Builder isDefault(Optional<Boolean> isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = Optional.ofNullable(isDefault);
            return this;
        }

        /**
         * <p>Unix timestamp of brand creation</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>Unix timestamp of last modification</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>Associated help center identifier</p>
         */
        @JsonSetter(value = "help_center_id", nulls = Nulls.SKIP)
        public Builder helpCenterId(Optional<String> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(String helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        /**
         * <p>Default email settings ID for this brand</p>
         */
        @JsonSetter(value = "default_address_settings_id", nulls = Nulls.SKIP)
        public Builder defaultAddressSettingsId(Optional<String> defaultAddressSettingsId) {
            this.defaultAddressSettingsId = defaultAddressSettingsId;
            return this;
        }

        public Builder defaultAddressSettingsId(String defaultAddressSettingsId) {
            this.defaultAddressSettingsId = Optional.ofNullable(defaultAddressSettingsId);
            return this;
        }

        public Brand build() {
            return new Brand(
                    type,
                    id,
                    name,
                    isDefault,
                    createdAt,
                    updatedAt,
                    helpCenterId,
                    defaultAddressSettingsId,
                    additionalProperties);
        }
    }
}
