/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.notes.types.CompanyNote;
import com.intercom.api.resources.unstable.segments.types.Segment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Company.Builder.class)
public final class Company {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<String> appId;

    private final Optional<Plan> plan;

    private final Optional<String> companyId;

    private final Optional<Integer> remoteCreatedAt;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Integer> lastRequestAt;

    private final Optional<Integer> size;

    private final Optional<String> website;

    private final Optional<String> industry;

    private final Optional<Integer> monthlySpend;

    private final Optional<Integer> sessionCount;

    private final Optional<Integer> userCount;

    private final Optional<Map<String, String>> customAttributes;

    private final Optional<Tags> tags;

    private final Optional<Segments> segments;

    private final Optional<Notes> notes;

    private final Map<String, Object> additionalProperties;

    private Company(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<String> appId,
            Optional<Plan> plan,
            Optional<String> companyId,
            Optional<Integer> remoteCreatedAt,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<Integer> lastRequestAt,
            Optional<Integer> size,
            Optional<String> website,
            Optional<String> industry,
            Optional<Integer> monthlySpend,
            Optional<Integer> sessionCount,
            Optional<Integer> userCount,
            Optional<Map<String, String>> customAttributes,
            Optional<Tags> tags,
            Optional<Segments> segments,
            Optional<Notes> notes,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.appId = appId;
        this.plan = plan;
        this.companyId = companyId;
        this.remoteCreatedAt = remoteCreatedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastRequestAt = lastRequestAt;
        this.size = size;
        this.website = website;
        this.industry = industry;
        this.monthlySpend = monthlySpend;
        this.sessionCount = sessionCount;
        this.userCount = userCount;
        this.customAttributes = customAttributes;
        this.tags = tags;
        this.segments = segments;
        this.notes = notes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is <code>company</code>
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The Intercom defined id representing the company.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the company.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The Intercom defined code of the workspace the company is associated to.
     */
    @JsonProperty("app_id")
    public Optional<String> getAppId() {
        return appId;
    }

    @JsonProperty("plan")
    public Optional<Plan> getPlan() {
        return plan;
    }

    /**
     * @return The company id you have defined for the company.
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return The time the company was created by you.
     */
    @JsonProperty("remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return remoteCreatedAt;
    }

    /**
     * @return The time the company was added in Intercom.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the company was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The time the company last recorded making a request.
     */
    @JsonProperty("last_request_at")
    public Optional<Integer> getLastRequestAt() {
        return lastRequestAt;
    }

    /**
     * @return The number of employees in the company.
     */
    @JsonProperty("size")
    public Optional<Integer> getSize() {
        return size;
    }

    /**
     * @return The URL for the company website.
     */
    @JsonProperty("website")
    public Optional<String> getWebsite() {
        return website;
    }

    /**
     * @return The industry that the company operates in.
     */
    @JsonProperty("industry")
    public Optional<String> getIndustry() {
        return industry;
    }

    /**
     * @return How much revenue the company generates for your business.
     */
    @JsonProperty("monthly_spend")
    public Optional<Integer> getMonthlySpend() {
        return monthlySpend;
    }

    /**
     * @return How many sessions the company has recorded.
     */
    @JsonProperty("session_count")
    public Optional<Integer> getSessionCount() {
        return sessionCount;
    }

    /**
     * @return The number of users in the company.
     */
    @JsonProperty("user_count")
    public Optional<Integer> getUserCount() {
        return userCount;
    }

    /**
     * @return The custom attributes you have set on the company.
     */
    @JsonProperty("custom_attributes")
    public Optional<Map<String, String>> getCustomAttributes() {
        return customAttributes;
    }

    /**
     * @return The list of tags associated with the company
     */
    @JsonProperty("tags")
    public Optional<Tags> getTags() {
        return tags;
    }

    /**
     * @return The list of segments associated with the company
     */
    @JsonProperty("segments")
    public Optional<Segments> getSegments() {
        return segments;
    }

    /**
     * @return The list of notes associated with the company
     */
    @JsonProperty("notes")
    public Optional<Notes> getNotes() {
        return notes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Company && equalTo((Company) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Company other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && appId.equals(other.appId)
                && plan.equals(other.plan)
                && companyId.equals(other.companyId)
                && remoteCreatedAt.equals(other.remoteCreatedAt)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && lastRequestAt.equals(other.lastRequestAt)
                && size.equals(other.size)
                && website.equals(other.website)
                && industry.equals(other.industry)
                && monthlySpend.equals(other.monthlySpend)
                && sessionCount.equals(other.sessionCount)
                && userCount.equals(other.userCount)
                && customAttributes.equals(other.customAttributes)
                && tags.equals(other.tags)
                && segments.equals(other.segments)
                && notes.equals(other.notes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.appId,
                this.plan,
                this.companyId,
                this.remoteCreatedAt,
                this.createdAt,
                this.updatedAt,
                this.lastRequestAt,
                this.size,
                this.website,
                this.industry,
                this.monthlySpend,
                this.sessionCount,
                this.userCount,
                this.customAttributes,
                this.tags,
                this.segments,
                this.notes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> appId = Optional.empty();

        private Optional<Plan> plan = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<Integer> remoteCreatedAt = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> lastRequestAt = Optional.empty();

        private Optional<Integer> size = Optional.empty();

        private Optional<String> website = Optional.empty();

        private Optional<String> industry = Optional.empty();

        private Optional<Integer> monthlySpend = Optional.empty();

        private Optional<Integer> sessionCount = Optional.empty();

        private Optional<Integer> userCount = Optional.empty();

        private Optional<Map<String, String>> customAttributes = Optional.empty();

        private Optional<Tags> tags = Optional.empty();

        private Optional<Segments> segments = Optional.empty();

        private Optional<Notes> notes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Company other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            appId(other.getAppId());
            plan(other.getPlan());
            companyId(other.getCompanyId());
            remoteCreatedAt(other.getRemoteCreatedAt());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            lastRequestAt(other.getLastRequestAt());
            size(other.getSize());
            website(other.getWebsite());
            industry(other.getIndustry());
            monthlySpend(other.getMonthlySpend());
            sessionCount(other.getSessionCount());
            userCount(other.getUserCount());
            customAttributes(other.getCustomAttributes());
            tags(other.getTags());
            segments(other.getSegments());
            notes(other.getNotes());
            return this;
        }

        /**
         * <p>Value is <code>company</code></p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The Intercom defined id representing the company.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the company.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The Intercom defined code of the workspace the company is associated to.</p>
         */
        @JsonSetter(value = "app_id", nulls = Nulls.SKIP)
        public Builder appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value = "plan", nulls = Nulls.SKIP)
        public Builder plan(Optional<Plan> plan) {
            this.plan = plan;
            return this;
        }

        public Builder plan(Plan plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        /**
         * <p>The company id you have defined for the company.</p>
         */
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The time the company was created by you.</p>
         */
        @JsonSetter(value = "remote_created_at", nulls = Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        /**
         * <p>The time the company was added in Intercom.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The last time the company was updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time the company last recorded making a request.</p>
         */
        @JsonSetter(value = "last_request_at", nulls = Nulls.SKIP)
        public Builder lastRequestAt(Optional<Integer> lastRequestAt) {
            this.lastRequestAt = lastRequestAt;
            return this;
        }

        public Builder lastRequestAt(Integer lastRequestAt) {
            this.lastRequestAt = Optional.ofNullable(lastRequestAt);
            return this;
        }

        /**
         * <p>The number of employees in the company.</p>
         */
        @JsonSetter(value = "size", nulls = Nulls.SKIP)
        public Builder size(Optional<Integer> size) {
            this.size = size;
            return this;
        }

        public Builder size(Integer size) {
            this.size = Optional.ofNullable(size);
            return this;
        }

        /**
         * <p>The URL for the company website.</p>
         */
        @JsonSetter(value = "website", nulls = Nulls.SKIP)
        public Builder website(Optional<String> website) {
            this.website = website;
            return this;
        }

        public Builder website(String website) {
            this.website = Optional.ofNullable(website);
            return this;
        }

        /**
         * <p>The industry that the company operates in.</p>
         */
        @JsonSetter(value = "industry", nulls = Nulls.SKIP)
        public Builder industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        public Builder industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        /**
         * <p>How much revenue the company generates for your business.</p>
         */
        @JsonSetter(value = "monthly_spend", nulls = Nulls.SKIP)
        public Builder monthlySpend(Optional<Integer> monthlySpend) {
            this.monthlySpend = monthlySpend;
            return this;
        }

        public Builder monthlySpend(Integer monthlySpend) {
            this.monthlySpend = Optional.ofNullable(monthlySpend);
            return this;
        }

        /**
         * <p>How many sessions the company has recorded.</p>
         */
        @JsonSetter(value = "session_count", nulls = Nulls.SKIP)
        public Builder sessionCount(Optional<Integer> sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        public Builder sessionCount(Integer sessionCount) {
            this.sessionCount = Optional.ofNullable(sessionCount);
            return this;
        }

        /**
         * <p>The number of users in the company.</p>
         */
        @JsonSetter(value = "user_count", nulls = Nulls.SKIP)
        public Builder userCount(Optional<Integer> userCount) {
            this.userCount = userCount;
            return this;
        }

        public Builder userCount(Integer userCount) {
            this.userCount = Optional.ofNullable(userCount);
            return this;
        }

        /**
         * <p>The custom attributes you have set on the company.</p>
         */
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, String>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        /**
         * <p>The list of tags associated with the company</p>
         */
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public Builder tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        /**
         * <p>The list of segments associated with the company</p>
         */
        @JsonSetter(value = "segments", nulls = Nulls.SKIP)
        public Builder segments(Optional<Segments> segments) {
            this.segments = segments;
            return this;
        }

        public Builder segments(Segments segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        /**
         * <p>The list of notes associated with the company</p>
         */
        @JsonSetter(value = "notes", nulls = Nulls.SKIP)
        public Builder notes(Optional<Notes> notes) {
            this.notes = notes;
            return this;
        }

        public Builder notes(Notes notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        public Company build() {
            return new Company(
                    type,
                    id,
                    name,
                    appId,
                    plan,
                    companyId,
                    remoteCreatedAt,
                    createdAt,
                    updatedAt,
                    lastRequestAt,
                    size,
                    website,
                    industry,
                    monthlySpend,
                    sessionCount,
                    userCount,
                    customAttributes,
                    tags,
                    segments,
                    notes,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Plan.Builder.class)
    public static final class Plan {
        private final Optional<String> type;

        private final Optional<String> id;

        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Plan(
                Optional<String> type,
                Optional<String> id,
                Optional<String> name,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Value is always &quot;plan&quot;
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return The id of the plan
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        /**
         * @return The name of the plan
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Plan && equalTo((Plan) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Plan other) {
            return type.equals(other.type) && id.equals(other.id) && name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.id, this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> id = Optional.empty();

            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Plan other) {
                type(other.getType());
                id(other.getId());
                name(other.getName());
                return this;
            }

            /**
             * <p>Value is always &quot;plan&quot;</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The id of the plan</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            /**
             * <p>The name of the plan</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Plan build() {
                return new Plan(type, id, name, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Tags.Builder.class)
    public static final class Tags {
        private final Optional<String> type;

        private final Optional<List<Object>> tags;

        private final Map<String, Object> additionalProperties;

        private Tags(Optional<String> type, Optional<List<Object>> tags, Map<String, Object> additionalProperties) {
            this.type = type;
            this.tags = tags;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("tags")
        public Optional<List<Object>> getTags() {
            return tags;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Tags && equalTo((Tags) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Tags other) {
            return type.equals(other.type) && tags.equals(other.tags);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.tags);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<Object>> tags = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Tags other) {
                type(other.getType());
                tags(other.getTags());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "tags", nulls = Nulls.SKIP)
            public Builder tags(Optional<List<Object>> tags) {
                this.tags = tags;
                return this;
            }

            public Builder tags(List<Object> tags) {
                this.tags = Optional.ofNullable(tags);
                return this;
            }

            public Tags build() {
                return new Tags(type, tags, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Segments.Builder.class)
    public static final class Segments {
        private final Optional<String> type;

        private final Optional<List<Segment>> segments;

        private final Map<String, Object> additionalProperties;

        private Segments(
                Optional<String> type, Optional<List<Segment>> segments, Map<String, Object> additionalProperties) {
            this.type = type;
            this.segments = segments;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("segments")
        public Optional<List<Segment>> getSegments() {
            return segments;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Segments && equalTo((Segments) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Segments other) {
            return type.equals(other.type) && segments.equals(other.segments);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.segments);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<Segment>> segments = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Segments other) {
                type(other.getType());
                segments(other.getSegments());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "segments", nulls = Nulls.SKIP)
            public Builder segments(Optional<List<Segment>> segments) {
                this.segments = segments;
                return this;
            }

            public Builder segments(List<Segment> segments) {
                this.segments = Optional.ofNullable(segments);
                return this;
            }

            public Segments build() {
                return new Segments(type, segments, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Notes.Builder.class)
    public static final class Notes {
        private final Optional<String> type;

        private final Optional<List<CompanyNote>> notes;

        private final Map<String, Object> additionalProperties;

        private Notes(
                Optional<String> type, Optional<List<CompanyNote>> notes, Map<String, Object> additionalProperties) {
            this.type = type;
            this.notes = notes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of the object
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        @JsonProperty("notes")
        public Optional<List<CompanyNote>> getNotes() {
            return notes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Notes && equalTo((Notes) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Notes other) {
            return type.equals(other.type) && notes.equals(other.notes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.notes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<CompanyNote>> notes = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Notes other) {
                type(other.getType());
                notes(other.getNotes());
                return this;
            }

            /**
             * <p>The type of the object</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value = "notes", nulls = Nulls.SKIP)
            public Builder notes(Optional<List<CompanyNote>> notes) {
                this.notes = notes;
                return this;
            }

            public Builder notes(List<CompanyNote> notes) {
                this.notes = Optional.ofNullable(notes);
                return this;
            }

            public Notes build() {
                return new Notes(type, notes, additionalProperties);
            }
        }
    }
}
