/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.BlockContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListCompaniesForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSegmentsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSubscriptionsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListTagsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactByExternalIdRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.unstable.contacts.types.CreateContactResponse;
import com.intercom.api.resources.unstable.contacts.types.MergeContactResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactByExternalIdResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactResponse;
import com.intercom.api.resources.unstable.contacts.types.UpdateContactResponse;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.types.ContactArchived;
import com.intercom.api.resources.unstable.types.ContactAttachedCompanies;
import com.intercom.api.resources.unstable.types.ContactBlocked;
import com.intercom.api.resources.unstable.types.ContactDeleted;
import com.intercom.api.resources.unstable.types.ContactList;
import com.intercom.api.resources.unstable.types.ContactSegments;
import com.intercom.api.resources.unstable.types.ContactUnarchived;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import com.intercom.api.resources.unstable.types.TagList;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawContactsClient {
    protected final ClientOptions clientOptions;

    public RawContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public IntercomHttpResponse<ContactAttachedCompanies> listCompaniesForAContact(
            ListCompaniesForAContactRequest request) {
        return listCompaniesForAContact(request, null);
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public IntercomHttpResponse<ContactAttachedCompanies> listCompaniesForAContact(
            ListCompaniesForAContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .addPathSegments("companies")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactAttachedCompanies.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public IntercomHttpResponse<ContactSegments> listSegmentsForAContact(ListSegmentsForAContactRequest request) {
        return listSegmentsForAContact(request, null);
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public IntercomHttpResponse<ContactSegments> listSegmentsForAContact(
            ListSegmentsForAContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getContactId())
                .addPathSegments("segments")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactSegments.class), response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public IntercomHttpResponse<SubscriptionTypeList> listSubscriptionsForAContact(
            ListSubscriptionsForAContactRequest request) {
        return listSubscriptionsForAContact(request, null);
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public IntercomHttpResponse<SubscriptionTypeList> listSubscriptionsForAContact(
            ListSubscriptionsForAContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getContactId())
                .addPathSegments("subscriptions")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SubscriptionTypeList.class), response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public IntercomHttpResponse<TagList> listTagsForAContact(ListTagsForAContactRequest request) {
        return listTagsForAContact(request, null);
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public IntercomHttpResponse<TagList> listTagsForAContact(
            ListTagsForAContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getContactId())
                .addPathSegments("tags")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, TagList.class), response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch the details of a single contact.
     */
    public IntercomHttpResponse<ShowContactResponse> showContact(ShowContactRequest request) {
        return showContact(request, null);
    }

    /**
     * You can fetch the details of a single contact.
     */
    public IntercomHttpResponse<ShowContactResponse> showContact(
            ShowContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ShowContactResponse.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can update an existing contact (ie. user or lead).
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>contact updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a contact with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<UpdateContactResponse> updateContact(UpdateContactRequest request) {
        return updateContact(request, null);
    }

    /**
     * You can update an existing contact (ie. user or lead).
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>contact updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a contact with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<UpdateContactResponse> updateContact(
            UpdateContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UpdateContactResponse.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can delete a single contact.
     */
    public IntercomHttpResponse<ContactDeleted> deleteContact(DeleteContactRequest request) {
        return deleteContact(request, null);
    }

    /**
     * You can delete a single contact.
     */
    public IntercomHttpResponse<ContactDeleted> deleteContact(
            DeleteContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactDeleted.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public IntercomHttpResponse<MergeContactResponse> mergeContact() {
        return mergeContact(MergeContactsRequest.builder().build());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public IntercomHttpResponse<MergeContactResponse> mergeContact(MergeContactsRequest request) {
        return mergeContact(request, null);
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public IntercomHttpResponse<MergeContactResponse> mergeContact(
            MergeContactsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts/merge")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, MergeContactResponse.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | formatted_phone                    | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public IntercomHttpResponse<ContactList> searchContacts(SearchRequest request) {
        return searchContacts(request, null);
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | formatted_phone                    | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public IntercomHttpResponse<ContactList> searchContacts(SearchRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts/search")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactList.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public IntercomHttpResponse<ContactList> listContacts() {
        return listContacts(null);
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public IntercomHttpResponse<ContactList> listContacts(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactList.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public IntercomHttpResponse<CreateContactResponse> createContact(Object request) {
        return createContact(request, null);
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public IntercomHttpResponse<CreateContactResponse> createContact(Object request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CreateContactResponse.class), response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch the details of a single contact by external ID. Note that this endpoint only supports users and not leads.
     */
    public IntercomHttpResponse<ShowContactByExternalIdResponse> showContactByExternalId(
            ShowContactByExternalIdRequest request) {
        return showContactByExternalId(request, null);
    }

    /**
     * You can fetch the details of a single contact by external ID. Note that this endpoint only supports users and not leads.
     */
    public IntercomHttpResponse<ShowContactByExternalIdResponse> showContactByExternalId(
            ShowContactByExternalIdRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts/find_by_external_id")
                .addPathSegment(request.getExternalId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ShowContactByExternalIdResponse.class),
                        response);
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can archive a single contact.
     */
    public IntercomHttpResponse<ContactArchived> archiveContact(ArchiveContactRequest request) {
        return archiveContact(request, null);
    }

    /**
     * You can archive a single contact.
     */
    public IntercomHttpResponse<ContactArchived> archiveContact(
            ArchiveContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .addPathSegments("archive")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactArchived.class), response);
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can unarchive a single contact.
     */
    public IntercomHttpResponse<ContactUnarchived> unarchiveContact(UnarchiveContactRequest request) {
        return unarchiveContact(request, null);
    }

    /**
     * You can unarchive a single contact.
     */
    public IntercomHttpResponse<ContactUnarchived> unarchiveContact(
            UnarchiveContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .addPathSegments("unarchive")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactUnarchived.class), response);
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * Block a single contact.&lt;br&gt;<strong>Note:</strong> conversations of the contact will also be archived during the process.&lt;br&gt;More details in <a href="https://www.intercom.com/help/en/articles/8838656-inbox-faqs">FAQ How do I block Inbox spam?</a>
     */
    public IntercomHttpResponse<ContactBlocked> blockContact(BlockContactRequest request) {
        return blockContact(request, null);
    }

    /**
     * Block a single contact.&lt;br&gt;<strong>Note:</strong> conversations of the contact will also be archived during the process.&lt;br&gt;More details in <a href="https://www.intercom.com/help/en/articles/8838656-inbox-faqs">FAQ How do I block Inbox spam?</a>
     */
    public IntercomHttpResponse<ContactBlocked> blockContact(
            BlockContactRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("contacts")
                .addPathSegment(request.getId())
                .addPathSegments("block")
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContactBlocked.class), response);
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
