/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.CustomerRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AttachContactToConversationRequest.Builder.class)
public final class AttachContactToConversationRequest {
    private final String id;

    private final Optional<String> adminId;

    private final Optional<Customer> customer;

    private final Map<String, Object> additionalProperties;

    private AttachContactToConversationRequest(
            String id,
            Optional<String> adminId,
            Optional<Customer> customer,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.adminId = adminId;
        this.customer = customer;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for the conversation as given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The <code>id</code> of the admin who is adding the new participant.
     */
    @JsonProperty("admin_id")
    public Optional<String> getAdminId() {
        return adminId;
    }

    @JsonProperty("customer")
    public Optional<Customer> getCustomer() {
        return customer;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AttachContactToConversationRequest
                && equalTo((AttachContactToConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachContactToConversationRequest other) {
        return id.equals(other.id) && adminId.equals(other.adminId) && customer.equals(other.customer);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.adminId, this.customer);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         */
        _FinalStage id(@NotNull String id);

        Builder from(AttachContactToConversationRequest other);
    }

    public interface _FinalStage {
        AttachContactToConversationRequest build();

        /**
         * <p>The <code>id</code> of the admin who is adding the new participant.</p>
         */
        _FinalStage adminId(Optional<String> adminId);

        _FinalStage adminId(String adminId);

        _FinalStage customer(Optional<Customer> customer);

        _FinalStage customer(Customer customer);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Customer> customer = Optional.empty();

        private Optional<String> adminId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AttachContactToConversationRequest other) {
            id(other.getId());
            adminId(other.getAdminId());
            customer(other.getCustomer());
            return this;
        }

        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         * <p>The identifier for the conversation as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage customer(Customer customer) {
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "customer", nulls = Nulls.SKIP)
        public _FinalStage customer(Optional<Customer> customer) {
            this.customer = customer;
            return this;
        }

        /**
         * <p>The <code>id</code> of the admin who is adding the new participant.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        /**
         * <p>The <code>id</code> of the admin who is adding the new participant.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        @java.lang.Override
        public AttachContactToConversationRequest build() {
            return new AttachContactToConversationRequest(id, adminId, customer, additionalProperties);
        }
    }

    @JsonDeserialize(using = Customer.Deserializer.class)
    public static final class Customer {
        private final Object value;

        private final int type;

        private Customer(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((IntercomUserId) this.value);
            } else if (this.type == 1) {
                return visitor.visit((UserId) this.value);
            } else if (this.type == 2) {
                return visitor.visit((Customer_) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Customer && equalTo((Customer) other);
        }

        private boolean equalTo(Customer other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static Customer of(IntercomUserId value) {
            return new Customer(value, 0);
        }

        public static Customer of(UserId value) {
            return new Customer(value, 1);
        }

        public static Customer of(Customer_ value) {
            return new Customer(value, 2);
        }

        public interface Visitor<T> {
            T visit(IntercomUserId value);

            T visit(UserId value);

            T visit(Customer_ value);
        }

        static final class Deserializer extends StdDeserializer<Customer> {
            Deserializer() {
                super(Customer.class);
            }

            @java.lang.Override
            public Customer deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, IntercomUserId.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, UserId.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, Customer_.class));
                } catch (RuntimeException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = Customer_.Builder.class)
        public static final class Customer_ {
            private final String email;

            private final Optional<CustomerRequest> customer;

            private final Map<String, Object> additionalProperties;

            private Customer_(
                    String email, Optional<CustomerRequest> customer, Map<String, Object> additionalProperties) {
                this.email = email;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The email you have defined for the contact who is being added as a participant.
             */
            @JsonProperty("email")
            public String getEmail() {
                return email;
            }

            @JsonProperty("customer")
            public Optional<CustomerRequest> getCustomer() {
                return customer;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof Customer_ && equalTo((Customer_) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Customer_ other) {
                return email.equals(other.email) && customer.equals(other.customer);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.email, this.customer);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            public interface EmailStage {
                /**
                 * <p>The email you have defined for the contact who is being added as a participant.</p>
                 */
                _FinalStage email(@NotNull String email);

                Builder from(Customer_ other);
            }

            public interface _FinalStage {
                Customer_ build();

                _FinalStage customer(Optional<CustomerRequest> customer);

                _FinalStage customer(CustomerRequest customer);
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements EmailStage, _FinalStage {
                private String email;

                private Optional<CustomerRequest> customer = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(Customer_ other) {
                    email(other.getEmail());
                    customer(other.getCustomer());
                    return this;
                }

                /**
                 * <p>The email you have defined for the contact who is being added as a participant.</p>
                 * <p>The email you have defined for the contact who is being added as a participant.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @java.lang.Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @java.lang.Override
                @JsonSetter(value = "customer", nulls = Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @java.lang.Override
                public Customer_ build() {
                    return new Customer_(email, customer, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = UserId.Builder.class)
        public static final class UserId {
            private final String userId;

            private final Optional<CustomerRequest> customer;

            private final Map<String, Object> additionalProperties;

            private UserId(
                    String userId, Optional<CustomerRequest> customer, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The external_id you have defined for the contact who is being added as a participant.
             */
            @JsonProperty("user_id")
            public String getUserId() {
                return userId;
            }

            @JsonProperty("customer")
            public Optional<CustomerRequest> getCustomer() {
                return customer;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof UserId && equalTo((UserId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserId other) {
                return userId.equals(other.userId) && customer.equals(other.customer);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.userId, this.customer);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            public interface UserIdStage {
                /**
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 */
                _FinalStage userId(@NotNull String userId);

                Builder from(UserId other);
            }

            public interface _FinalStage {
                UserId build();

                _FinalStage customer(Optional<CustomerRequest> customer);

                _FinalStage customer(CustomerRequest customer);
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements UserIdStage, _FinalStage {
                private String userId;

                private Optional<CustomerRequest> customer = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(UserId other) {
                    userId(other.getUserId());
                    customer(other.getCustomer());
                    return this;
                }

                /**
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                @java.lang.Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @java.lang.Override
                @JsonSetter(value = "customer", nulls = Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @java.lang.Override
                public UserId build() {
                    return new UserId(userId, customer, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = IntercomUserId.Builder.class)
        public static final class IntercomUserId {
            private final String intercomUserId;

            private final Optional<CustomerRequest> customer;

            private final Map<String, Object> additionalProperties;

            private IntercomUserId(
                    String intercomUserId,
                    Optional<CustomerRequest> customer,
                    Map<String, Object> additionalProperties) {
                this.intercomUserId = intercomUserId;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The identifier for the contact as given by Intercom.
             */
            @JsonProperty("intercom_user_id")
            public String getIntercomUserId() {
                return intercomUserId;
            }

            @JsonProperty("customer")
            public Optional<CustomerRequest> getCustomer() {
                return customer;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof IntercomUserId && equalTo((IntercomUserId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(IntercomUserId other) {
                return intercomUserId.equals(other.intercomUserId) && customer.equals(other.customer);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.intercomUserId, this.customer);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IntercomUserIdStage builder() {
                return new Builder();
            }

            public interface IntercomUserIdStage {
                /**
                 * <p>The identifier for the contact as given by Intercom.</p>
                 */
                _FinalStage intercomUserId(@NotNull String intercomUserId);

                Builder from(IntercomUserId other);
            }

            public interface _FinalStage {
                IntercomUserId build();

                _FinalStage customer(Optional<CustomerRequest> customer);

                _FinalStage customer(CustomerRequest customer);
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IntercomUserIdStage, _FinalStage {
                private String intercomUserId;

                private Optional<CustomerRequest> customer = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(IntercomUserId other) {
                    intercomUserId(other.getIntercomUserId());
                    customer(other.getCustomer());
                    return this;
                }

                /**
                 * <p>The identifier for the contact as given by Intercom.</p>
                 * <p>The identifier for the contact as given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("intercom_user_id")
                public _FinalStage intercomUserId(@NotNull String intercomUserId) {
                    this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
                    return this;
                }

                @java.lang.Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @java.lang.Override
                @JsonSetter(value = "customer", nulls = Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @java.lang.Override
                public IntercomUserId build() {
                    return new IntercomUserId(intercomUserId, customer, additionalProperties);
                }
            }
        }
    }
}
