/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConvertConversationToTicketRequest.Builder.class)
public final class ConvertConversationToTicketRequest {
    private final int id;

    private final String ticketTypeId;

    private final Optional<Map<String, AttributesValue>> attributes;

    private final Map<String, Object> additionalProperties;

    private ConvertConversationToTicketRequest(
            int id,
            String ticketTypeId,
            Optional<Map<String, AttributesValue>> attributes,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.ticketTypeId = ticketTypeId;
        this.attributes = attributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation to target
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return The ID of the type of ticket you want to convert the conversation to
     */
    @JsonProperty("ticket_type_id")
    public String getTicketTypeId() {
        return ticketTypeId;
    }

    @JsonProperty("attributes")
    public Optional<Map<String, AttributesValue>> getAttributes() {
        return attributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConvertConversationToTicketRequest
                && equalTo((ConvertConversationToTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertConversationToTicketRequest other) {
        return id == other.id && ticketTypeId.equals(other.ticketTypeId) && attributes.equals(other.attributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.ticketTypeId, this.attributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The id of the conversation to target</p>
         */
        TicketTypeIdStage id(int id);

        Builder from(ConvertConversationToTicketRequest other);
    }

    public interface TicketTypeIdStage {
        /**
         * <p>The ID of the type of ticket you want to convert the conversation to</p>
         */
        _FinalStage ticketTypeId(@NotNull String ticketTypeId);
    }

    public interface _FinalStage {
        ConvertConversationToTicketRequest build();

        _FinalStage attributes(Optional<Map<String, AttributesValue>> attributes);

        _FinalStage attributes(Map<String, AttributesValue> attributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TicketTypeIdStage, _FinalStage {
        private int id;

        private String ticketTypeId;

        private Optional<Map<String, AttributesValue>> attributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConvertConversationToTicketRequest other) {
            id(other.getId());
            ticketTypeId(other.getTicketTypeId());
            attributes(other.getAttributes());
            return this;
        }

        /**
         * <p>The id of the conversation to target</p>
         * <p>The id of the conversation to target</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TicketTypeIdStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * <p>The ID of the type of ticket you want to convert the conversation to</p>
         * <p>The ID of the type of ticket you want to convert the conversation to</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage attributes(Map<String, AttributesValue> attributes) {
            this.attributes = Optional.ofNullable(attributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "attributes", nulls = Nulls.SKIP)
        public _FinalStage attributes(Optional<Map<String, AttributesValue>> attributes) {
            this.attributes = attributes;
            return this;
        }

        @java.lang.Override
        public ConvertConversationToTicketRequest build() {
            return new ConvertConversationToTicketRequest(id, ticketTypeId, attributes, additionalProperties);
        }
    }

    @JsonDeserialize(using = AttributesValue.Deserializer.class)
    public static final class AttributesValue {
        private final Object value;

        private final int type;

        private AttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Optional<String>) this.value);
            } else if (this.type == 1) {
                return visitor.visit((double) this.value);
            } else if (this.type == 2) {
                return visitor.visit((boolean) this.value);
            } else if (this.type == 3) {
                return visitor.visit((List<Object>) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof AttributesValue && equalTo((AttributesValue) other);
        }

        private boolean equalTo(AttributesValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static AttributesValue of(Optional<String> value) {
            return new AttributesValue(value, 0);
        }

        public static AttributesValue of(double value) {
            return new AttributesValue(value, 1);
        }

        public static AttributesValue of(boolean value) {
            return new AttributesValue(value, 2);
        }

        public static AttributesValue of(List<Object> value) {
            return new AttributesValue(value, 3);
        }

        public interface Visitor<T> {
            T visit(Optional<String> value);

            T visit(double value);

            T visit(boolean value);

            T visit(List<Object> value);
        }

        static final class Deserializer extends StdDeserializer<AttributesValue> {
            Deserializer() {
                super(AttributesValue.class);
            }

            @java.lang.Override
            public AttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<String>>() {}));
                } catch (RuntimeException e) {
                }
                if (value instanceof Double) {
                    return of((Double) value);
                }
                if (value instanceof Boolean) {
                    return of((Boolean) value);
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<List<Object>>() {}));
                } catch (RuntimeException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
