/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ReplyConversationRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ReplyConversationRequest.Builder.class)
public final class ReplyConversationRequest {
    private final String id;

    private final ReplyConversationRequestBody body;

    private final Map<String, Object> additionalProperties;

    private ReplyConversationRequest(
            String id, ReplyConversationRequestBody body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("body")
    public ReplyConversationRequestBody getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ReplyConversationRequest && equalTo((ReplyConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReplyConversationRequest other) {
        return id.equals(other.id) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation</p>
         */
        BodyStage id(@NotNull String id);

        Builder from(ReplyConversationRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull ReplyConversationRequestBody body);
    }

    public interface _FinalStage {
        ReplyConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, BodyStage, _FinalStage {
        private String id;

        private ReplyConversationRequestBody body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ReplyConversationRequest other) {
            id(other.getId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation</p>
         * <p>The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public BodyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull ReplyConversationRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public ReplyConversationRequest build() {
            return new ReplyConversationRequest(id, body, additionalProperties);
        }
    }
}
