/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.customobjectinstances;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.customobjectinstances.requests.CreateOrUpdateCustomObjectInstanceRequest;
import com.intercom.api.resources.unstable.customobjectinstances.requests.DeleteCustomObjectInstancesByExternalIdRequest;
import com.intercom.api.resources.unstable.customobjectinstances.requests.DeleteCustomObjectInstancesByIdRequest;
import com.intercom.api.resources.unstable.customobjectinstances.requests.GetCustomObjectInstancesByExternalIdRequest;
import com.intercom.api.resources.unstable.customobjectinstances.requests.GetCustomObjectInstancesByIdRequest;
import com.intercom.api.resources.unstable.customobjectinstances.types.CustomObjectInstance;
import com.intercom.api.resources.unstable.types.CustomObjectInstanceDeleted;
import java.util.Optional;

public class CustomObjectInstancesClient {
    protected final ClientOptions clientOptions;

    private final RawCustomObjectInstancesClient rawClient;

    public CustomObjectInstancesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCustomObjectInstancesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCustomObjectInstancesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetch a Custom Object Instance by external_id.
     */
    public Optional<CustomObjectInstance> getCustomObjectInstancesByExternalId(
            GetCustomObjectInstancesByExternalIdRequest request) {
        return this.rawClient.getCustomObjectInstancesByExternalId(request).body();
    }

    /**
     * Fetch a Custom Object Instance by external_id.
     */
    public Optional<CustomObjectInstance> getCustomObjectInstancesByExternalId(
            GetCustomObjectInstancesByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .getCustomObjectInstancesByExternalId(request, requestOptions)
                .body();
    }

    /**
     * Create or update a custom object instance
     */
    public Optional<CustomObjectInstance> createCustomObjectInstances(
            CreateOrUpdateCustomObjectInstanceRequest request) {
        return this.rawClient.createCustomObjectInstances(request).body();
    }

    /**
     * Create or update a custom object instance
     */
    public Optional<CustomObjectInstance> createCustomObjectInstances(
            CreateOrUpdateCustomObjectInstanceRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .createCustomObjectInstances(request, requestOptions)
                .body();
    }

    /**
     * Delete a single Custom Object instance by external_id.
     */
    public CustomObjectInstanceDeleted deleteCustomObjectInstancesById(DeleteCustomObjectInstancesByIdRequest request) {
        return this.rawClient.deleteCustomObjectInstancesById(request).body();
    }

    /**
     * Delete a single Custom Object instance by external_id.
     */
    public CustomObjectInstanceDeleted deleteCustomObjectInstancesById(
            DeleteCustomObjectInstancesByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .deleteCustomObjectInstancesById(request, requestOptions)
                .body();
    }

    /**
     * Fetch a Custom Object Instance by id.
     */
    public Optional<CustomObjectInstance> getCustomObjectInstancesById(GetCustomObjectInstancesByIdRequest request) {
        return this.rawClient.getCustomObjectInstancesById(request).body();
    }

    /**
     * Fetch a Custom Object Instance by id.
     */
    public Optional<CustomObjectInstance> getCustomObjectInstancesById(
            GetCustomObjectInstancesByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .getCustomObjectInstancesById(request, requestOptions)
                .body();
    }

    /**
     * Delete a single Custom Object instance using the Intercom defined id.
     */
    public CustomObjectInstanceDeleted deleteCustomObjectInstancesByExternalId(
            DeleteCustomObjectInstancesByExternalIdRequest request) {
        return this.rawClient.deleteCustomObjectInstancesByExternalId(request).body();
    }

    /**
     * Delete a single Custom Object instance using the Intercom defined id.
     */
    public CustomObjectInstanceDeleted deleteCustomObjectInstancesByExternalId(
            DeleteCustomObjectInstancesByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .deleteCustomObjectInstancesByExternalId(request, requestOptions)
                .body();
    }
}
