/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DeleteCustomObjectInstancesByExternalIdRequest.Builder.class)
public final class DeleteCustomObjectInstancesByExternalIdRequest {
    private final String customObjectTypeIdentifier;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private DeleteCustomObjectInstancesByExternalIdRequest(
            String customObjectTypeIdentifier, String id, Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of the custom object type that defines the structure of the custom object instance.
     */
    @JsonProperty("custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return customObjectTypeIdentifier;
    }

    /**
     * @return The Intercom defined id of the custom object instance
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeleteCustomObjectInstancesByExternalIdRequest
                && equalTo((DeleteCustomObjectInstancesByExternalIdRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCustomObjectInstancesByExternalIdRequest other) {
        return customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier) && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    public interface CustomObjectTypeIdentifierStage {
        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         */
        IdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier);

        Builder from(DeleteCustomObjectInstancesByExternalIdRequest other);
    }

    public interface IdStage {
        /**
         * <p>The Intercom defined id of the custom object instance</p>
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        DeleteCustomObjectInstancesByExternalIdRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CustomObjectTypeIdentifierStage, IdStage, _FinalStage {
        private String customObjectTypeIdentifier;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DeleteCustomObjectInstancesByExternalIdRequest other) {
            customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            id(other.getId());
            return this;
        }

        /**
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * <p>The unique identifier of the custom object type that defines the structure of the custom object instance.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("custom_object_type_identifier")
        public IdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier =
                    Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        /**
         * <p>The Intercom defined id of the custom object instance</p>
         * <p>The Intercom defined id of the custom object instance</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public DeleteCustomObjectInstancesByExternalIdRequest build() {
            return new DeleteCustomObjectInstancesByExternalIdRequest(
                    customObjectTypeIdentifier, id, additionalProperties);
        }
    }
}
