/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.BadRequestError;
import com.intercom.api.resources.unstable.errors.TooManyRequestsError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.export.requests.PostExportReportingDataEnqueueRequest;
import com.intercom.api.resources.unstable.export.types.GetExportReportingDataGetDatasetsResponse;
import com.intercom.api.resources.unstable.export.types.PostExportReportingDataEnqueueResponse;
import com.intercom.api.resources.unstable.types.Error;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExportClient {
    protected final ClientOptions clientOptions;

    public RawExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<PostExportReportingDataEnqueueResponse> enqueueANewReportingDataExportJob(
            PostExportReportingDataEnqueueRequest request) {
        return enqueueANewReportingDataExportJob(request, null);
    }

    public IntercomHttpResponse<PostExportReportingDataEnqueueResponse> enqueueANewReportingDataExportJob(
            PostExportReportingDataEnqueueRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/reporting_data/enqueue")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, PostExportReportingDataEnqueueResponse.class),
                        response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 429:
                        throw new TooManyRequestsError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<GetExportReportingDataGetDatasetsResponse> listAvailableDatasetsAndAttributes() {
        return listAvailableDatasetsAndAttributes(null);
    }

    public IntercomHttpResponse<GetExportReportingDataGetDatasetsResponse> listAvailableDatasetsAndAttributes(
            RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/reporting_data/get_datasets")
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, GetExportReportingDataGetDatasetsResponse.class),
                        response);
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
