/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.macros;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.macros.requests.GetMacroRequest;
import com.intercom.api.resources.unstable.macros.requests.ListMacrosRequest;
import com.intercom.api.resources.unstable.macros.types.Macro;
import com.intercom.api.resources.unstable.macros.types.MacroList;
import java.util.Optional;

public class MacrosClient {
    protected final ClientOptions clientOptions;

    private final RawMacrosClient rawClient;

    public MacrosClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawMacrosClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawMacrosClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public MacroList listMacros() {
        return this.rawClient.listMacros().body();
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public MacroList listMacros(ListMacrosRequest request) {
        return this.rawClient.listMacros(request).body();
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public MacroList listMacros(ListMacrosRequest request, RequestOptions requestOptions) {
        return this.rawClient.listMacros(request, requestOptions).body();
    }

    /**
     * You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.
     * <p><strong>Visibility Rules</strong></p>
     * <p>A macro is returned based on its <code>visible_to</code> setting:</p>
     * <ul>
     * <li><code>everyone</code>: Always visible to all team members</li>
     * <li><code>specific_teams</code>: Only visible if the authenticated user belongs to one of the teams specified in <code>visible_to_team_ids</code></li>
     * </ul>
     * <p>If a macro exists but is not visible to the authenticated user, a 404 error is returned.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format in the <code>body</code> field:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     * <p>Default values in placeholders are HTML-escaped for security.</p>
     */
    public Optional<Macro> getMacro(GetMacroRequest request) {
        return this.rawClient.getMacro(request).body();
    }

    /**
     * You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.
     * <p><strong>Visibility Rules</strong></p>
     * <p>A macro is returned based on its <code>visible_to</code> setting:</p>
     * <ul>
     * <li><code>everyone</code>: Always visible to all team members</li>
     * <li><code>specific_teams</code>: Only visible if the authenticated user belongs to one of the teams specified in <code>visible_to_team_ids</code></li>
     * </ul>
     * <p>If a macro exists but is not visible to the authenticated user, a 404 error is returned.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format in the <code>body</code> field:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     * <p>Default values in placeholders are HTML-escaped for security.</p>
     */
    public Optional<Macro> getMacro(GetMacroRequest request, RequestOptions requestOptions) {
        return this.rawClient.getMacro(request, requestOptions).body();
    }
}
