/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.macros.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Macro.Builder.class)
public final class Macro {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<String> body;

    private final Optional<String> bodyText;

    private final Optional<OffsetDateTime> createdAt;

    private final Optional<OffsetDateTime> updatedAt;

    private final Optional<VisibleTo> visibleTo;

    private final Optional<List<String>> visibleToTeamIds;

    private final Optional<List<AvailableOnItem>> availableOn;

    private final Map<String, Object> additionalProperties;

    private Macro(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<String> body,
            Optional<String> bodyText,
            Optional<OffsetDateTime> createdAt,
            Optional<OffsetDateTime> updatedAt,
            Optional<VisibleTo> visibleTo,
            Optional<List<String>> visibleToTeamIds,
            Optional<List<AvailableOnItem>> availableOn,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.body = body;
        this.bodyText = bodyText;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.visibleTo = visibleTo;
        this.visibleToTeamIds = visibleToTeamIds;
        this.availableOn = availableOn;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>macro</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the macro.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the macro.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The body of the macro in HTML format with placeholders transformed to XML-like format.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The plain text version of the macro body with original Intercom placeholder format.
     */
    @JsonProperty("body_text")
    public Optional<String> getBodyText() {
        return bodyText;
    }

    /**
     * @return The time the macro was created in ISO 8601 format.
     */
    @JsonProperty("created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the macro was last updated in ISO 8601 format.
     */
    @JsonProperty("updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Who can view this macro.
     */
    @JsonProperty("visible_to")
    public Optional<VisibleTo> getVisibleTo() {
        return visibleTo;
    }

    /**
     * @return The team IDs that can view this macro when visible_to is set to specific_teams.
     */
    @JsonProperty("visible_to_team_ids")
    public Optional<List<String>> getVisibleToTeamIds() {
        return visibleToTeamIds;
    }

    /**
     * @return Where the macro is available for use.
     */
    @JsonProperty("available_on")
    public Optional<List<AvailableOnItem>> getAvailableOn() {
        return availableOn;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Macro && equalTo((Macro) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Macro other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && body.equals(other.body)
                && bodyText.equals(other.bodyText)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && visibleTo.equals(other.visibleTo)
                && visibleToTeamIds.equals(other.visibleToTeamIds)
                && availableOn.equals(other.availableOn);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.body,
                this.bodyText,
                this.createdAt,
                this.updatedAt,
                this.visibleTo,
                this.visibleToTeamIds,
                this.availableOn);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<String> bodyText = Optional.empty();

        private Optional<OffsetDateTime> createdAt = Optional.empty();

        private Optional<OffsetDateTime> updatedAt = Optional.empty();

        private Optional<VisibleTo> visibleTo = Optional.empty();

        private Optional<List<String>> visibleToTeamIds = Optional.empty();

        private Optional<List<AvailableOnItem>> availableOn = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Macro other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            body(other.getBody());
            bodyText(other.getBodyText());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            visibleTo(other.getVisibleTo());
            visibleToTeamIds(other.getVisibleToTeamIds());
            availableOn(other.getAvailableOn());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>macro</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the macro.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the macro.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The body of the macro in HTML format with placeholders transformed to XML-like format.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The plain text version of the macro body with original Intercom placeholder format.</p>
         */
        @JsonSetter(value = "body_text", nulls = Nulls.SKIP)
        public Builder bodyText(Optional<String> bodyText) {
            this.bodyText = bodyText;
            return this;
        }

        public Builder bodyText(String bodyText) {
            this.bodyText = Optional.ofNullable(bodyText);
            return this;
        }

        /**
         * <p>The time the macro was created in ISO 8601 format.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the macro was last updated in ISO 8601 format.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>Who can view this macro.</p>
         */
        @JsonSetter(value = "visible_to", nulls = Nulls.SKIP)
        public Builder visibleTo(Optional<VisibleTo> visibleTo) {
            this.visibleTo = visibleTo;
            return this;
        }

        public Builder visibleTo(VisibleTo visibleTo) {
            this.visibleTo = Optional.ofNullable(visibleTo);
            return this;
        }

        /**
         * <p>The team IDs that can view this macro when visible_to is set to specific_teams.</p>
         */
        @JsonSetter(value = "visible_to_team_ids", nulls = Nulls.SKIP)
        public Builder visibleToTeamIds(Optional<List<String>> visibleToTeamIds) {
            this.visibleToTeamIds = visibleToTeamIds;
            return this;
        }

        public Builder visibleToTeamIds(List<String> visibleToTeamIds) {
            this.visibleToTeamIds = Optional.ofNullable(visibleToTeamIds);
            return this;
        }

        /**
         * <p>Where the macro is available for use.</p>
         */
        @JsonSetter(value = "available_on", nulls = Nulls.SKIP)
        public Builder availableOn(Optional<List<AvailableOnItem>> availableOn) {
            this.availableOn = availableOn;
            return this;
        }

        public Builder availableOn(List<AvailableOnItem> availableOn) {
            this.availableOn = Optional.ofNullable(availableOn);
            return this;
        }

        public Macro build() {
            return new Macro(
                    type,
                    id,
                    name,
                    body,
                    bodyText,
                    createdAt,
                    updatedAt,
                    visibleTo,
                    visibleToTeamIds,
                    availableOn,
                    additionalProperties);
        }
    }

    public static final class VisibleTo {
        public static final VisibleTo SPECIFIC_TEAMS = new VisibleTo(Value.SPECIFIC_TEAMS, "specific_teams");

        public static final VisibleTo EVERYONE = new VisibleTo(Value.EVERYONE, "everyone");

        private final Value value;

        private final String string;

        VisibleTo(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof VisibleTo && this.string.equals(((VisibleTo) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SPECIFIC_TEAMS:
                    return visitor.visitSpecificTeams();
                case EVERYONE:
                    return visitor.visitEveryone();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static VisibleTo valueOf(String value) {
            switch (value) {
                case "specific_teams":
                    return SPECIFIC_TEAMS;
                case "everyone":
                    return EVERYONE;
                default:
                    return new VisibleTo(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            EVERYONE,

            SPECIFIC_TEAMS,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEveryone();

            T visitSpecificTeams();

            T visitUnknown(String unknownType);
        }
    }

    public static final class AvailableOnItem {
        public static final AvailableOnItem INBOX = new AvailableOnItem(Value.INBOX, "inbox");

        public static final AvailableOnItem MESSENGER = new AvailableOnItem(Value.MESSENGER, "messenger");

        private final Value value;

        private final String string;

        AvailableOnItem(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof AvailableOnItem && this.string.equals(((AvailableOnItem) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case INBOX:
                    return visitor.visitInbox();
                case MESSENGER:
                    return visitor.visitMessenger();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static AvailableOnItem valueOf(String value) {
            switch (value) {
                case "inbox":
                    return INBOX;
                case "messenger":
                    return MESSENGER;
                default:
                    return new AvailableOnItem(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            INBOX,

            MESSENGER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitInbox();

            T visitMessenger();

            T visitUnknown(String unknownType);
        }
    }
}
