/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.notes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.admins.types.Admin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyNote.Builder.class)
public final class CompanyNote {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<Integer> createdAt;

    private final Optional<Company> company;

    private final Optional<Admin> author;

    private final Optional<String> body;

    private final Map<String, Object> additionalProperties;

    private CompanyNote(
            Optional<String> type,
            Optional<String> id,
            Optional<Integer> createdAt,
            Optional<Company> company,
            Optional<Admin> author,
            Optional<String> body,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.createdAt = createdAt;
        this.company = company;
        this.author = author;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>note</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id of the note.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The time the note was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Represents the company that the note was created about.
     */
    @JsonProperty("company")
    public Optional<Company> getCompany() {
        return company;
    }

    /**
     * @return Optional. Represents the Admin that created the note.
     */
    @JsonProperty("author")
    public Optional<Admin> getAuthor() {
        return author;
    }

    /**
     * @return The body text of the note.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyNote && equalTo((CompanyNote) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyNote other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && createdAt.equals(other.createdAt)
                && company.equals(other.company)
                && author.equals(other.author)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.createdAt, this.company, this.author, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Company> company = Optional.empty();

        private Optional<Admin> author = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CompanyNote other) {
            type(other.getType());
            id(other.getId());
            createdAt(other.getCreatedAt());
            company(other.getCompany());
            author(other.getAuthor());
            body(other.getBody());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>note</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id of the note.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The time the note was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>Represents the company that the note was created about.</p>
         */
        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public Builder company(Optional<Company> company) {
            this.company = company;
            return this;
        }

        public Builder company(Company company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        /**
         * <p>Optional. Represents the Admin that created the note.</p>
         */
        @JsonSetter(value = "author", nulls = Nulls.SKIP)
        public Builder author(Optional<Admin> author) {
            this.author = author;
            return this;
        }

        public Builder author(Admin author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        /**
         * <p>The body text of the note.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        public CompanyNote build() {
            return new CompanyNote(type, id, createdAt, company, author, body, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Company.Builder.class)
    public static final class Company {
        private final Optional<String> type;

        private final Optional<String> id;

        private final Map<String, Object> additionalProperties;

        private Company(Optional<String> type, Optional<String> id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return String representing the object's type. Always has the value <code>company</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return The id of the company.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Company && equalTo((Company) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Company other) {
            return type.equals(other.type) && id.equals(other.id);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> id = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Company other) {
                type(other.getType());
                id(other.getId());
                return this;
            }

            /**
             * <p>String representing the object's type. Always has the value <code>company</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The id of the company.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public Company build() {
                return new Company(type, id, additionalProperties);
            }
        }
    }
}
