/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ActivityLogMetadata.Builder.class)
public final class ActivityLogMetadata {
    private final Optional<String> signInMethod;

    private final Optional<String> externalId;

    private final Optional<Boolean> awayMode;

    private final Optional<String> awayStatusReason;

    private final Optional<Boolean> reassignConversations;

    private final Optional<String> source;

    private final Optional<String> autoChanged;

    private final Optional<Integer> updateBy;

    private final Optional<String> updateByName;

    private final Optional<Integer> conversationAssignmentLimit;

    private final Optional<Integer> ticketAssignmentLimit;

    private final Map<String, Object> additionalProperties;

    private ActivityLogMetadata(
            Optional<String> signInMethod,
            Optional<String> externalId,
            Optional<Boolean> awayMode,
            Optional<String> awayStatusReason,
            Optional<Boolean> reassignConversations,
            Optional<String> source,
            Optional<String> autoChanged,
            Optional<Integer> updateBy,
            Optional<String> updateByName,
            Optional<Integer> conversationAssignmentLimit,
            Optional<Integer> ticketAssignmentLimit,
            Map<String, Object> additionalProperties) {
        this.signInMethod = signInMethod;
        this.externalId = externalId;
        this.awayMode = awayMode;
        this.awayStatusReason = awayStatusReason;
        this.reassignConversations = reassignConversations;
        this.source = source;
        this.autoChanged = autoChanged;
        this.updateBy = updateBy;
        this.updateByName = updateByName;
        this.conversationAssignmentLimit = conversationAssignmentLimit;
        this.ticketAssignmentLimit = ticketAssignmentLimit;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The way the admin signed in.
     */
    @JsonProperty("sign_in_method")
    public Optional<String> getSignInMethod() {
        return signInMethod;
    }

    /**
     * @return The unique identifier for the contact which is provided by the Client.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return The away mode status which is set to true when away and false when returned.
     */
    @JsonProperty("away_mode")
    public Optional<Boolean> getAwayMode() {
        return awayMode;
    }

    /**
     * @return The reason the Admin is away.
     */
    @JsonProperty("away_status_reason")
    public Optional<String> getAwayStatusReason() {
        return awayStatusReason;
    }

    /**
     * @return Indicates if conversations should be reassigned while an Admin is away.
     */
    @JsonProperty("reassign_conversations")
    public Optional<Boolean> getReassignConversations() {
        return reassignConversations;
    }

    /**
     * @return The action that initiated the status change.
     */
    @JsonProperty("source")
    public Optional<String> getSource() {
        return source;
    }

    /**
     * @return Indicates if the status was changed automatically or manually.
     */
    @JsonProperty("auto_changed")
    public Optional<String> getAutoChanged() {
        return autoChanged;
    }

    /**
     * @return The ID of the Admin who initiated the activity.
     */
    @JsonProperty("update_by")
    public Optional<Integer> getUpdateBy() {
        return updateBy;
    }

    /**
     * @return The name of the Admin who initiated the activity.
     */
    @JsonProperty("update_by_name")
    public Optional<String> getUpdateByName() {
        return updateByName;
    }

    /**
     * @return The conversation assignment limit value for an admin.
     */
    @JsonProperty("conversation_assignment_limit")
    public Optional<Integer> getConversationAssignmentLimit() {
        return conversationAssignmentLimit;
    }

    /**
     * @return The ticket assignment limit value for an admin.
     */
    @JsonProperty("ticket_assignment_limit")
    public Optional<Integer> getTicketAssignmentLimit() {
        return ticketAssignmentLimit;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ActivityLogMetadata && equalTo((ActivityLogMetadata) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityLogMetadata other) {
        return signInMethod.equals(other.signInMethod)
                && externalId.equals(other.externalId)
                && awayMode.equals(other.awayMode)
                && awayStatusReason.equals(other.awayStatusReason)
                && reassignConversations.equals(other.reassignConversations)
                && source.equals(other.source)
                && autoChanged.equals(other.autoChanged)
                && updateBy.equals(other.updateBy)
                && updateByName.equals(other.updateByName)
                && conversationAssignmentLimit.equals(other.conversationAssignmentLimit)
                && ticketAssignmentLimit.equals(other.ticketAssignmentLimit);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.signInMethod,
                this.externalId,
                this.awayMode,
                this.awayStatusReason,
                this.reassignConversations,
                this.source,
                this.autoChanged,
                this.updateBy,
                this.updateByName,
                this.conversationAssignmentLimit,
                this.ticketAssignmentLimit);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> signInMethod = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<Boolean> awayMode = Optional.empty();

        private Optional<String> awayStatusReason = Optional.empty();

        private Optional<Boolean> reassignConversations = Optional.empty();

        private Optional<String> source = Optional.empty();

        private Optional<String> autoChanged = Optional.empty();

        private Optional<Integer> updateBy = Optional.empty();

        private Optional<String> updateByName = Optional.empty();

        private Optional<Integer> conversationAssignmentLimit = Optional.empty();

        private Optional<Integer> ticketAssignmentLimit = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ActivityLogMetadata other) {
            signInMethod(other.getSignInMethod());
            externalId(other.getExternalId());
            awayMode(other.getAwayMode());
            awayStatusReason(other.getAwayStatusReason());
            reassignConversations(other.getReassignConversations());
            source(other.getSource());
            autoChanged(other.getAutoChanged());
            updateBy(other.getUpdateBy());
            updateByName(other.getUpdateByName());
            conversationAssignmentLimit(other.getConversationAssignmentLimit());
            ticketAssignmentLimit(other.getTicketAssignmentLimit());
            return this;
        }

        /**
         * <p>The way the admin signed in.</p>
         */
        @JsonSetter(value = "sign_in_method", nulls = Nulls.SKIP)
        public Builder signInMethod(Optional<String> signInMethod) {
            this.signInMethod = signInMethod;
            return this;
        }

        public Builder signInMethod(String signInMethod) {
            this.signInMethod = Optional.ofNullable(signInMethod);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The away mode status which is set to true when away and false when returned.</p>
         */
        @JsonSetter(value = "away_mode", nulls = Nulls.SKIP)
        public Builder awayMode(Optional<Boolean> awayMode) {
            this.awayMode = awayMode;
            return this;
        }

        public Builder awayMode(Boolean awayMode) {
            this.awayMode = Optional.ofNullable(awayMode);
            return this;
        }

        /**
         * <p>The reason the Admin is away.</p>
         */
        @JsonSetter(value = "away_status_reason", nulls = Nulls.SKIP)
        public Builder awayStatusReason(Optional<String> awayStatusReason) {
            this.awayStatusReason = awayStatusReason;
            return this;
        }

        public Builder awayStatusReason(String awayStatusReason) {
            this.awayStatusReason = Optional.ofNullable(awayStatusReason);
            return this;
        }

        /**
         * <p>Indicates if conversations should be reassigned while an Admin is away.</p>
         */
        @JsonSetter(value = "reassign_conversations", nulls = Nulls.SKIP)
        public Builder reassignConversations(Optional<Boolean> reassignConversations) {
            this.reassignConversations = reassignConversations;
            return this;
        }

        public Builder reassignConversations(Boolean reassignConversations) {
            this.reassignConversations = Optional.ofNullable(reassignConversations);
            return this;
        }

        /**
         * <p>The action that initiated the status change.</p>
         */
        @JsonSetter(value = "source", nulls = Nulls.SKIP)
        public Builder source(Optional<String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        /**
         * <p>Indicates if the status was changed automatically or manually.</p>
         */
        @JsonSetter(value = "auto_changed", nulls = Nulls.SKIP)
        public Builder autoChanged(Optional<String> autoChanged) {
            this.autoChanged = autoChanged;
            return this;
        }

        public Builder autoChanged(String autoChanged) {
            this.autoChanged = Optional.ofNullable(autoChanged);
            return this;
        }

        /**
         * <p>The ID of the Admin who initiated the activity.</p>
         */
        @JsonSetter(value = "update_by", nulls = Nulls.SKIP)
        public Builder updateBy(Optional<Integer> updateBy) {
            this.updateBy = updateBy;
            return this;
        }

        public Builder updateBy(Integer updateBy) {
            this.updateBy = Optional.ofNullable(updateBy);
            return this;
        }

        /**
         * <p>The name of the Admin who initiated the activity.</p>
         */
        @JsonSetter(value = "update_by_name", nulls = Nulls.SKIP)
        public Builder updateByName(Optional<String> updateByName) {
            this.updateByName = updateByName;
            return this;
        }

        public Builder updateByName(String updateByName) {
            this.updateByName = Optional.ofNullable(updateByName);
            return this;
        }

        /**
         * <p>The conversation assignment limit value for an admin.</p>
         */
        @JsonSetter(value = "conversation_assignment_limit", nulls = Nulls.SKIP)
        public Builder conversationAssignmentLimit(Optional<Integer> conversationAssignmentLimit) {
            this.conversationAssignmentLimit = conversationAssignmentLimit;
            return this;
        }

        public Builder conversationAssignmentLimit(Integer conversationAssignmentLimit) {
            this.conversationAssignmentLimit = Optional.ofNullable(conversationAssignmentLimit);
            return this;
        }

        /**
         * <p>The ticket assignment limit value for an admin.</p>
         */
        @JsonSetter(value = "ticket_assignment_limit", nulls = Nulls.SKIP)
        public Builder ticketAssignmentLimit(Optional<Integer> ticketAssignmentLimit) {
            this.ticketAssignmentLimit = ticketAssignmentLimit;
            return this;
        }

        public Builder ticketAssignmentLimit(Integer ticketAssignmentLimit) {
            this.ticketAssignmentLimit = Optional.ofNullable(ticketAssignmentLimit);
            return this;
        }

        public ActivityLogMetadata build() {
            return new ActivityLogMetadata(
                    signInMethod,
                    externalId,
                    awayMode,
                    awayStatusReason,
                    reassignConversations,
                    source,
                    autoChanged,
                    updateBy,
                    updateByName,
                    conversationAssignmentLimit,
                    ticketAssignmentLimit,
                    additionalProperties);
        }
    }
}
