/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomChannelNotificationResponse.Builder.class)
public final class CustomChannelNotificationResponse {
    private final String externalConversationId;

    private final String conversationId;

    private final String externalContactId;

    private final String contactId;

    private final Map<String, Object> additionalProperties;

    private CustomChannelNotificationResponse(
            String externalConversationId,
            String conversationId,
            String externalContactId,
            String contactId,
            Map<String, Object> additionalProperties) {
        this.externalConversationId = externalConversationId;
        this.conversationId = conversationId;
        this.externalContactId = externalContactId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The external conversation ID provided in the notification request
     */
    @JsonProperty("external_conversation_id")
    public String getExternalConversationId() {
        return externalConversationId;
    }

    /**
     * @return The Intercom conversation ID mapped to the external conversation ID
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    /**
     * @return The external contact ID provided in the notification request
     */
    @JsonProperty("external_contact_id")
    public String getExternalContactId() {
        return externalContactId;
    }

    /**
     * @return The Intercom contact ID mapped to the external contact ID
     */
    @JsonProperty("contact_id")
    public String getContactId() {
        return contactId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomChannelNotificationResponse && equalTo((CustomChannelNotificationResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelNotificationResponse other) {
        return externalConversationId.equals(other.externalConversationId)
                && conversationId.equals(other.conversationId)
                && externalContactId.equals(other.externalContactId)
                && contactId.equals(other.contactId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.externalConversationId, this.conversationId, this.externalContactId, this.contactId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalConversationIdStage builder() {
        return new Builder();
    }

    public interface ExternalConversationIdStage {
        /**
         * <p>The external conversation ID provided in the notification request</p>
         */
        ConversationIdStage externalConversationId(@NotNull String externalConversationId);

        Builder from(CustomChannelNotificationResponse other);
    }

    public interface ConversationIdStage {
        /**
         * <p>The Intercom conversation ID mapped to the external conversation ID</p>
         */
        ExternalContactIdStage conversationId(@NotNull String conversationId);
    }

    public interface ExternalContactIdStage {
        /**
         * <p>The external contact ID provided in the notification request</p>
         */
        ContactIdStage externalContactId(@NotNull String externalContactId);
    }

    public interface ContactIdStage {
        /**
         * <p>The Intercom contact ID mapped to the external contact ID</p>
         */
        _FinalStage contactId(@NotNull String contactId);
    }

    public interface _FinalStage {
        CustomChannelNotificationResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ExternalConversationIdStage,
                    ConversationIdStage,
                    ExternalContactIdStage,
                    ContactIdStage,
                    _FinalStage {
        private String externalConversationId;

        private String conversationId;

        private String externalContactId;

        private String contactId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CustomChannelNotificationResponse other) {
            externalConversationId(other.getExternalConversationId());
            conversationId(other.getConversationId());
            externalContactId(other.getExternalContactId());
            contactId(other.getContactId());
            return this;
        }

        /**
         * <p>The external conversation ID provided in the notification request</p>
         * <p>The external conversation ID provided in the notification request</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_conversation_id")
        public ConversationIdStage externalConversationId(@NotNull String externalConversationId) {
            this.externalConversationId =
                    Objects.requireNonNull(externalConversationId, "externalConversationId must not be null");
            return this;
        }

        /**
         * <p>The Intercom conversation ID mapped to the external conversation ID</p>
         * <p>The Intercom conversation ID mapped to the external conversation ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public ExternalContactIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        /**
         * <p>The external contact ID provided in the notification request</p>
         * <p>The external contact ID provided in the notification request</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_contact_id")
        public ContactIdStage externalContactId(@NotNull String externalContactId) {
            this.externalContactId = Objects.requireNonNull(externalContactId, "externalContactId must not be null");
            return this;
        }

        /**
         * <p>The Intercom contact ID mapped to the external contact ID</p>
         * <p>The Intercom contact ID mapped to the external contact ID</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact_id")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @java.lang.Override
        public CustomChannelNotificationResponse build() {
            return new CustomChannelNotificationResponse(
                    externalConversationId, conversationId, externalContactId, contactId, additionalProperties);
        }
    }
}
