/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OpenConversationRequest.Builder.class)
public final class OpenConversationRequest {
    private final String adminId;

    private final Map<String, Object> additionalProperties;

    private OpenConversationRequest(String adminId, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the admin who is performing the action.
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OpenConversationRequest && equalTo((OpenConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OpenConversationRequest other) {
        return adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    public interface AdminIdStage {
        /**
         * <p>The id of the admin who is performing the action.</p>
         */
        _FinalStage adminId(@NotNull String adminId);

        Builder from(OpenConversationRequest other);
    }

    public interface _FinalStage {
        OpenConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AdminIdStage, _FinalStage {
        private String adminId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OpenConversationRequest other) {
            adminId(other.getAdminId());
            return this;
        }

        /**
         * <p>The id of the admin who is performing the action.</p>
         * <p>The id of the admin who is performing the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @java.lang.Override
        public OpenConversationRequest build() {
            return new OpenConversationRequest(adminId, additionalProperties);
        }
    }
}
