/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdminList.Builder.class)
public final class AdminList {
    private final Optional<String> type;

    private final Optional<List<Optional<Admin>>> admins;

    private final Map<String, Object> additionalProperties;

    private AdminList(
            Optional<String> type, Optional<List<Optional<Admin>>> admins, Map<String, Object> additionalProperties) {
        this.type = type;
        this.admins = admins;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin.list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of admins associated with a given workspace.
     */
    @JsonProperty("admins")
    public Optional<List<Optional<Admin>>> getAdmins() {
        return admins;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdminList && equalTo((AdminList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminList other) {
        return type.equals(other.type) && admins.equals(other.admins);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.admins);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Optional<Admin>>> admins = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AdminList other) {
            type(other.getType());
            admins(other.getAdmins());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>admin.list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of admins associated with a given workspace.</p>
         */
        @JsonSetter(value = "admins", nulls = Nulls.SKIP)
        public Builder admins(Optional<List<Optional<Admin>>> admins) {
            this.admins = admins;
            return this;
        }

        public Builder admins(List<Optional<Admin>> admins) {
            this.admins = Optional.ofNullable(admins);
            return this;
        }

        public AdminList build() {
            return new AdminList(type, admins, additionalProperties);
        }
    }
}
