/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactCompanies.Builder.class)
public final class ContactCompanies {
    private final Optional<List<CompanyData>> data;

    private final Optional<String> url;

    private final Optional<Integer> totalCount;

    private final Optional<Boolean> hasMore;

    private final Map<String, Object> additionalProperties;

    private ContactCompanies(
            Optional<List<CompanyData>> data,
            Optional<String> url,
            Optional<Integer> totalCount,
            Optional<Boolean> hasMore,
            Map<String, Object> additionalProperties) {
        this.data = data;
        this.url = url;
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return An array of company data objects attached to the contact.
     */
    @JsonProperty("data")
    public Optional<List<CompanyData>> getData() {
        return data;
    }

    /**
     * @return Url to get more company resources for this contact
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return Integer representing the total number of companies attached to this contact
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return Whether there's more Addressable Objects to be viewed. If true, use the url to view all
     */
    @JsonProperty("has_more")
    public Optional<Boolean> getHasMore() {
        return hasMore;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactCompanies && equalTo((ContactCompanies) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactCompanies other) {
        return data.equals(other.data)
                && url.equals(other.url)
                && totalCount.equals(other.totalCount)
                && hasMore.equals(other.hasMore);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data, this.url, this.totalCount, this.hasMore);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<CompanyData>> data = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<Boolean> hasMore = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContactCompanies other) {
            data(other.getData());
            url(other.getUrl());
            totalCount(other.getTotalCount());
            hasMore(other.getHasMore());
            return this;
        }

        /**
         * <p>An array of company data objects attached to the contact.</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<CompanyData>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<CompanyData> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        /**
         * <p>Url to get more company resources for this contact</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>Integer representing the total number of companies attached to this contact</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>Whether there's more Addressable Objects to be viewed. If true, use the url to view all</p>
         */
        @JsonSetter(value = "has_more", nulls = Nulls.SKIP)
        public Builder hasMore(Optional<Boolean> hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        public Builder hasMore(Boolean hasMore) {
            this.hasMore = Optional.ofNullable(hasMore);
            return this;
        }

        public ContactCompanies build() {
            return new ContactCompanies(data, url, totalCount, hasMore, additionalProperties);
        }
    }
}
