/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.contacts.types.Contact;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactList.Builder.class)
public final class ContactList {
    private final Optional<String> type;

    private final Optional<List<Contact>> data;

    private final Optional<Integer> totalCount;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private ContactList(
            Optional<String> type,
            Optional<List<Contact>> data,
            Optional<Integer> totalCount,
            Optional<CursorPages> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always list
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of contact objects
     */
    @JsonProperty("data")
    public Optional<List<Contact>> getData() {
        return data;
    }

    /**
     * @return A count of the total number of objects.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactList && equalTo((ContactList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactList other) {
        return type.equals(other.type)
                && data.equals(other.data)
                && totalCount.equals(other.totalCount)
                && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Contact>> data = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContactList other) {
            type(other.getType());
            data(other.getData());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>Always list</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of contact objects</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<Contact>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Contact> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        /**
         * <p>A count of the total number of objects.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public ContactList build() {
            return new ContactList(type, data, totalCount, pages, additionalProperties);
        }
    }
}
