/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.dataevents.types.DataEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataEventList.Builder.class)
public final class DataEventList {
    private final Optional<String> type;

    private final Optional<List<DataEvent>> events;

    private final Optional<Pages> pages;

    private final Map<String, Object> additionalProperties;

    private DataEventList(
            Optional<String> type,
            Optional<List<DataEvent>> events,
            Optional<Pages> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.events = events;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return A list of data events
     */
    @JsonProperty("events")
    public Optional<List<DataEvent>> getEvents() {
        return events;
    }

    /**
     * @return Pagination
     */
    @JsonProperty("pages")
    public Optional<Pages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataEventList && equalTo((DataEventList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventList other) {
        return type.equals(other.type) && events.equals(other.events) && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.events, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<DataEvent>> events = Optional.empty();

        private Optional<Pages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataEventList other) {
            type(other.getType());
            events(other.getEvents());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>The type of the object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>A list of data events</p>
         */
        @JsonSetter(value = "events", nulls = Nulls.SKIP)
        public Builder events(Optional<List<DataEvent>> events) {
            this.events = events;
            return this;
        }

        public Builder events(List<DataEvent> events) {
            this.events = Optional.ofNullable(events);
            return this;
        }

        /**
         * <p>Pagination</p>
         */
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<Pages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Pages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public DataEventList build() {
            return new DataEventList(type, events, pages, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Pages.Builder.class)
    public static final class Pages {
        private final Optional<String> next;

        private final Optional<String> since;

        private final Map<String, Object> additionalProperties;

        private Pages(Optional<String> next, Optional<String> since, Map<String, Object> additionalProperties) {
            this.next = next;
            this.since = since;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty("next")
        public Optional<String> getNext() {
            return next;
        }

        @JsonProperty("since")
        public Optional<String> getSince() {
            return since;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Pages && equalTo((Pages) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return next.equals(other.next) && since.equals(other.since);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.next, this.since);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> next = Optional.empty();

            private Optional<String> since = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Pages other) {
                next(other.getNext());
                since(other.getSince());
                return this;
            }

            @JsonSetter(value = "next", nulls = Nulls.SKIP)
            public Builder next(Optional<String> next) {
                this.next = next;
                return this;
            }

            public Builder next(String next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            @JsonSetter(value = "since", nulls = Nulls.SKIP)
            public Builder since(Optional<String> since) {
                this.since = since;
                return this;
            }

            public Builder since(String since) {
                this.since = Optional.ofNullable(since);
                return this;
            }

            public Pages build() {
                return new Pages(next, since, additionalProperties);
            }
        }
    }
}
