/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = IpAllowlist.Builder.class)
public final class IpAllowlist {
    private final Optional<String> type;

    private final Optional<Boolean> enabled;

    private final Optional<List<String>> ipAllowlist;

    private final Map<String, Object> additionalProperties;

    private IpAllowlist(
            Optional<String> type,
            Optional<Boolean> enabled,
            Optional<List<String>> ipAllowlist,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.enabled = enabled;
        this.ipAllowlist = ipAllowlist;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ip_allowlist</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Whether the IP allowlist is enabled for the workspace.
     */
    @JsonProperty("enabled")
    public Optional<Boolean> getEnabled() {
        return enabled;
    }

    /**
     * @return List of allowed IP addresses and/or IP ranges in CIDR notation.
     * Examples:
     * <ul>
     * <li>Single IP: <code>192.168.0.1</code></li>
     * <li>IP range: <code>192.168.0.1/24</code> (allows 192.168.0.0 - 192.168.0.255)</li>
     * </ul>
     */
    @JsonProperty("ip_allowlist")
    public Optional<List<String>> getIpAllowlist() {
        return ipAllowlist;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof IpAllowlist && equalTo((IpAllowlist) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(IpAllowlist other) {
        return type.equals(other.type) && enabled.equals(other.enabled) && ipAllowlist.equals(other.ipAllowlist);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.enabled, this.ipAllowlist);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Boolean> enabled = Optional.empty();

        private Optional<List<String>> ipAllowlist = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(IpAllowlist other) {
            type(other.getType());
            enabled(other.getEnabled());
            ipAllowlist(other.getIpAllowlist());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>ip_allowlist</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Whether the IP allowlist is enabled for the workspace.</p>
         */
        @JsonSetter(value = "enabled", nulls = Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        /**
         * <p>List of allowed IP addresses and/or IP ranges in CIDR notation.
         * Examples:</p>
         * <ul>
         * <li>Single IP: <code>192.168.0.1</code></li>
         * <li>IP range: <code>192.168.0.1/24</code> (allows 192.168.0.0 - 192.168.0.255)</li>
         * </ul>
         */
        @JsonSetter(value = "ip_allowlist", nulls = Nulls.SKIP)
        public Builder ipAllowlist(Optional<List<String>> ipAllowlist) {
            this.ipAllowlist = ipAllowlist;
            return this;
        }

        public Builder ipAllowlist(List<String> ipAllowlist) {
            this.ipAllowlist = Optional.ofNullable(ipAllowlist);
            return this;
        }

        public IpAllowlist build() {
            return new IpAllowlist(type, enabled, ipAllowlist, additionalProperties);
        }
    }
}
