/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PaginatedResponse.Builder.class)
public final class PaginatedResponse {
    private final Optional<Type> type;

    private final Optional<CursorPages> pages;

    private final Optional<Integer> totalCount;

    private final Optional<List<PaginatedResponseDataItem>> data;

    private final Map<String, Object> additionalProperties;

    private PaginatedResponse(
            Optional<Type> type,
            Optional<CursorPages> pages,
            Optional<Integer> totalCount,
            Optional<List<PaginatedResponseDataItem>> data,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public Optional<Type> getType() {
        return type;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    /**
     * @return A count of the total number of objects.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return An array of Objects
     */
    @JsonProperty("data")
    public Optional<List<PaginatedResponseDataItem>> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PaginatedResponse && equalTo((PaginatedResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedResponse other) {
        return type.equals(other.type)
                && pages.equals(other.pages)
                && totalCount.equals(other.totalCount)
                && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.pages, this.totalCount, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Type> type = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<List<PaginatedResponseDataItem>> data = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(PaginatedResponse other) {
            type(other.getType());
            pages(other.getPages());
            totalCount(other.getTotalCount());
            data(other.getData());
            return this;
        }

        /**
         * <p>The type of object</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        /**
         * <p>A count of the total number of objects.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>An array of Objects</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<PaginatedResponseDataItem>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<PaginatedResponseDataItem> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public PaginatedResponse build() {
            return new PaginatedResponse(type, pages, totalCount, data, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type LIST = new Type(Value.LIST, "list");

        public static final Type CONVERSATION_LIST = new Type(Value.CONVERSATION_LIST, "conversation.list");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIST:
                    return visitor.visitList();
                case CONVERSATION_LIST:
                    return visitor.visitConversationList();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "list":
                    return LIST;
                case "conversation.list":
                    return CONVERSATION_LIST;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            LIST,

            CONVERSATION_LIST,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitList();

            T visitConversationList();

            T visitUnknown(String unknownType);
        }
    }
}
