/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.resources.news.types.NewsItem;
import com.intercom.api.resources.news.types.Newsfeed;
import java.util.Objects;
import java.util.Optional;

public final class PaginatedResponseDataItem {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private PaginatedResponseDataItem(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static PaginatedResponseDataItem newsItem(NewsItem value) {
        return new PaginatedResponseDataItem(new NewsItemValue(value));
    }

    public static PaginatedResponseDataItem newsfeed(Newsfeed value) {
        return new PaginatedResponseDataItem(new NewsfeedValue(value));
    }

    public boolean isNewsItem() {
        return value instanceof NewsItemValue;
    }

    public boolean isNewsfeed() {
        return value instanceof NewsfeedValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<NewsItem> getNewsItem() {
        if (isNewsItem()) {
            return Optional.of(((NewsItemValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Newsfeed> getNewsfeed() {
        if (isNewsfeed()) {
            return Optional.of(((NewsfeedValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitNewsItem(NewsItem newsItem);

        T visitNewsfeed(Newsfeed newsfeed);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", visible = true, defaultImpl = _UnknownValue.class)
    @JsonSubTypes({@JsonSubTypes.Type(NewsItemValue.class), @JsonSubTypes.Type(NewsfeedValue.class)})
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("news-item")
    @JsonIgnoreProperties("type")
    private static final class NewsItemValue implements Value {
        @JsonUnwrapped
        private NewsItem value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private NewsItemValue() {}

        private NewsItemValue(NewsItem value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNewsItem(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof NewsItemValue && equalTo((NewsItemValue) other);
        }

        private boolean equalTo(NewsItemValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "PaginatedResponseDataItem{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("newsfeed")
    @JsonIgnoreProperties("type")
    private static final class NewsfeedValue implements Value {
        @JsonUnwrapped
        private Newsfeed value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private NewsfeedValue() {}

        private NewsfeedValue(Newsfeed value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitNewsfeed(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof NewsfeedValue && equalTo((NewsfeedValue) other);
        }

        private boolean equalTo(NewsfeedValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "PaginatedResponseDataItem{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "PaginatedResponseDataItem{" + "type: " + type + ", value: " + value + "}";
        }
    }
}
