/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = ReplyConversationRequest.Deserializer.class)
public final class ReplyConversationRequest {
    private final Object value;

    private final int type;

    private ReplyConversationRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((ContactReplyConversationRequest) this.value);
        } else if (this.type == 1) {
            return visitor.visit((AdminReplyConversationRequest) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ReplyConversationRequest && equalTo((ReplyConversationRequest) other);
    }

    private boolean equalTo(ReplyConversationRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static ReplyConversationRequest of(ContactReplyConversationRequest value) {
        return new ReplyConversationRequest(value, 0);
    }

    public static ReplyConversationRequest of(AdminReplyConversationRequest value) {
        return new ReplyConversationRequest(value, 1);
    }

    public interface Visitor<T> {
        T visit(ContactReplyConversationRequest value);

        T visit(AdminReplyConversationRequest value);
    }

    static final class Deserializer extends StdDeserializer<ReplyConversationRequest> {
        Deserializer() {
            super(ReplyConversationRequest.class);
        }

        @java.lang.Override
        public ReplyConversationRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ContactReplyConversationRequest.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, AdminReplyConversationRequest.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
