/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SocialProfile.Builder.class)
public final class SocialProfile {
    private final Optional<String> type;

    private final Optional<String> name;

    private final Optional<String> url;

    private final Map<String, Object> additionalProperties;

    private SocialProfile(
            Optional<String> type,
            Optional<String> name,
            Optional<String> url,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return value is &quot;social_profile&quot;
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The name of the Social media profile
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The name of the Social media profile
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SocialProfile && equalTo((SocialProfile) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SocialProfile other) {
        return type.equals(other.type) && name.equals(other.name) && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> url = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SocialProfile other) {
            type(other.getType());
            name(other.getName());
            url(other.getUrl());
            return this;
        }

        /**
         * <p>value is &quot;social_profile&quot;</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The name of the Social media profile</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The name of the Social media profile</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        public SocialProfile build() {
            return new SocialProfile(type, name, url, additionalProperties);
        }
    }
}
