/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.cli.CliContext;
import io.jooby.cli.Cmd;
import io.jooby.internal.cli.Dependency;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates a new application"})
public class CreateCmd
extends Cmd {
    @CommandLine.Parameters(description={"Application name or coordinates (groupId:artifactId:version)"})
    private String name;
    @CommandLine.Option(names={"-g", "--gradle"}, description={"Generates a Gradle project"})
    private boolean gradle;
    @CommandLine.Option(names={"-k", "--kotlin"}, description={"Generates a Kotlin application"})
    private boolean kotlin;
    @CommandLine.Option(names={"--stork"}, description={"Add Stork Maven plugin to build (Maven only)"})
    private boolean stork;
    @CommandLine.Option(names={"-i"}, description={"Start interactive mode"})
    private boolean interactive;
    @CommandLine.Option(names={"--server"}, description={"Choose one of the available servers: jetty, netty or undertow"})
    private String server;
    @CommandLine.Option(names={"--docker"}, description={"Generates a Dockerfile"})
    private boolean docker;
    @CommandLine.Option(names={"-m", "--mvc"}, description={"Generates a MVC application"})
    private boolean mvc;
    @CommandLine.Option(names={"--openapi"}, description={"Configure build to generate OpenAPI files"})
    private boolean openapi;

    @Override
    public void run(@NonNull CliContext ctx) throws Exception {
        String extension;
        String templateName;
        String server;
        String version;
        String packageName;
        boolean stork;
        Path projectDir = ctx.getWorkspace().resolve(this.name);
        if (Files.exists(projectDir, new LinkOption[0])) {
            throw new IOException("Project directory already exists: " + projectDir);
        }
        Files.createDirectory(projectDir, new FileAttribute[0]);
        boolean bl = stork = !this.gradle && this.stork;
        if (this.interactive) {
            this.gradle = this.yesNo(ctx.readLine("Use Gradle (yes/no): "));
            this.kotlin = this.yesNo(ctx.readLine("Use Kotlin (yes/no): "));
            packageName = ctx.readLine("Enter a groupId/package: ");
            version = ctx.readLine("Enter a version (1.0.0): ");
            if (version == null || version.trim().length() == 0) {
                version = "1.0.0";
            }
            this.mvc = this.yesNo(ctx.readLine("Use MVC (yes/no): "));
            this.openapi = this.yesNo(ctx.readLine("Configure OpenAPI (yes/no): "));
            server = this.server(ctx.readLine("Choose a server (jetty, netty or undertow): "));
            if (!this.gradle) {
                stork = this.distribution(ctx.readLine("Distribution (uber/fat jar or stork): ")).equals("stork");
            }
            this.docker = this.yesNo(ctx.readLine("Generates Dockerfile (yes/no): "));
        } else {
            String[] parts = this.name.split(":");
            switch (parts.length) {
                case 3: {
                    packageName = parts[0];
                    this.name = parts[1];
                    version = parts[2];
                    break;
                }
                case 2: {
                    packageName = parts[0];
                    this.name = parts[1];
                    version = "1.0.0";
                    break;
                }
                default: {
                    packageName = "app";
                    version = "1.0.0";
                }
            }
            server = this.server(this.server);
        }
        String buildFileName = templateName = this.gradle ? "build.gradle" : "pom.xml";
        String language = this.kotlin ? "kotlin" : "java";
        String string = extension = language.equalsIgnoreCase("kotlin") ? "kt" : "java";
        Object finalArtifactId = this.gradle ? Paths.get("build", "libs", this.name + "-" + version + "-all.jar").toString() : this.name + "-" + version + (stork ? ".zip" : ".jar");
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map<String, String> dependencyMap = ctx.getDependencyMap();
        model.putAll(dependencyMap);
        model.put("package", packageName);
        model.put("groupId", packageName);
        model.put("artifactId", this.name);
        model.put("version", version);
        model.put("joobyVersion", ctx.getVersion());
        model.put("server", server);
        model.put("kotlin", this.kotlin);
        model.put("dependencies", this.dependencies(dependencyMap, server, this.kotlin));
        model.put("testDependencies", this.testDependencies(dependencyMap, this.kotlin));
        model.put("stork", stork);
        model.put("gradle", this.gradle);
        model.put("maven", !this.gradle);
        model.put("docker", this.docker);
        model.put("mvc", this.mvc);
        model.put("openapi", this.openapi);
        model.put("kapt", this.mvc && this.kotlin);
        model.put("apt", this.mvc && !this.kotlin);
        model.put("finalArtifactId", finalArtifactId);
        ctx.writeTemplate(templateName, model, projectDir.resolve(buildFileName));
        Path confDir = projectDir.resolve("conf");
        ctx.copyResource("/cli/conf/application.conf", confDir.resolve("application.conf"));
        ctx.copyResource("/cli/conf/logback.xml", confDir.resolve("logback.xml"));
        ctx.writeTemplate("README.md", model, projectDir.resolve("README.md"));
        if (this.gradle) {
            this.gradleWrapper(ctx, projectDir, model);
        }
        if (stork) {
            this.stork(ctx, projectDir);
        }
        if (this.docker) {
            this.docker(ctx, projectDir, model);
        }
        Path sourcePath = projectDir.resolve("src").resolve("main");
        Path javaPath = sourcePath.resolve(language);
        Path packagePath = Stream.of(packageName.split("\\.")).reduce(javaPath, Path::resolve, Path::resolve);
        ctx.writeTemplate("App." + extension, model, packagePath.resolve("App." + extension));
        if (this.mvc) {
            ctx.writeTemplate("Controller." + extension, model, packagePath.resolve("Controller." + extension));
        }
        Path testPath = projectDir.resolve("src").resolve("test");
        Path testJavaPath = testPath.resolve(language);
        Path testPackagePath = Stream.of(packageName.split("\\.")).reduce(testJavaPath, Path::resolve, Path::resolve);
        ctx.writeTemplate("UnitTest." + extension, model, testPackagePath.resolve("UnitTest." + extension));
        ctx.writeTemplate("IntegrationTest." + extension, model, testPackagePath.resolve("IntegrationTest." + extension));
        ctx.println("Try it! Open a terminal and type: ");
        ctx.println("  cd " + projectDir.toAbsolutePath());
        ctx.println("  " + (this.gradle ? "./gradlew joobyRun" : "mvn jooby:run"));
    }

    private boolean yesNo(String value) {
        return "y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    private void docker(CliContext ctx, Path dir, Map<String, Object> model) throws IOException {
        boolean gradle = (Boolean)model.get("gradle");
        String dockerfile = gradle ? "docker.gradle" : "docker.maven";
        ctx.writeTemplate(dockerfile, model, dir.resolve("Dockerfile"));
    }

    private Object distribution(String value) {
        if (value == null || value.trim().length() == 0) {
            return "uber";
        }
        switch (value.toLowerCase()) {
            case "fat": 
            case "uber": {
                return "uber";
            }
            case "stork": {
                return "stork";
            }
        }
        throw new IllegalArgumentException("Unknown distribution option: " + value);
    }

    private String server(String value) {
        if (value == null || value.trim().length() == 0) {
            return "netty";
        }
        switch (value.toLowerCase()) {
            case "j": 
            case "jetty": {
                return "jetty";
            }
            case "n": 
            case "netty": {
                return "netty";
            }
            case "u": 
            case "utow": 
            case "undertow": {
                return "utow";
            }
        }
        throw new IllegalArgumentException("Unknown server option: " + value);
    }

    private void stork(CliContext ctx, Path projectDir) throws IOException {
        ctx.copyResource("/cli/src/etc/stork/stork.yml", projectDir.resolve("src").resolve("etc").resolve("stork").resolve("stork.yml"));
    }

    private void gradleWrapper(CliContext ctx, Path projectDir, Map<String, Object> model) throws IOException {
        Path wrapperDir = projectDir.resolve("gradle").resolve("wrapper");
        ctx.writeTemplate("gradle/settings.gradle", model, projectDir.resolve("settings.gradle"));
        ctx.copyResource("/cli/gradle/gradlew", projectDir.resolve("gradlew"), EnumSet.allOf(PosixFilePermission.class));
        ctx.copyResource("/cli/gradle/gradlew.bat", projectDir.resolve("gradlew.bat"));
        ctx.copyResource("/cli/gradle/gradle/wrapper/gradle-wrapper.jar", wrapperDir.resolve("gradle-wrapper.jar"));
        ctx.copyResource("/cli/gradle/gradle/wrapper/gradle-wrapper.properties", wrapperDir.resolve("gradle-wrapper.properties"));
    }

    private List<Dependency> dependencies(Map<String, String> dependencyMap, String server, boolean kotlin) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(new Dependency("io.jooby", "jooby-" + server, null));
        if (kotlin) {
            dependencies.add(new Dependency("io.jooby", "jooby-kotlin", null));
            dependencies.add(new Dependency("org.jetbrains.kotlin", "kotlin-stdlib-jdk8", dependencyMap.get("kotlinVersion")));
        }
        dependencies.add(new Dependency("ch.qos.logback", "logback-classic", dependencyMap.get("logbackClassicVersion")));
        return dependencies;
    }

    private List<Dependency> testDependencies(Map<String, String> dependencyMap, boolean kotlin) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        dependencies.add(new Dependency("org.junit.jupiter", "junit-jupiter-api", dependencyMap.get("junitVersion")));
        dependencies.add(new Dependency("org.junit.jupiter", "junit-jupiter-engine", dependencyMap.get("junitVersion")));
        dependencies.add(new Dependency("io.jooby", "jooby-test", null));
        dependencies.add(new Dependency("com.squareup.okhttp3", "okhttp", dependencyMap.get("okhttpVersion")));
        return dependencies;
    }
}

