/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import com.vdurmont.semver4j.Semver;
import io.jooby.cli.Cli;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import picocli.CommandLine;

public class Version
implements CommandLine.IVersionProvider {
    public static final String VERSION = Version.doVersion();

    @Override
    public String[] getVersion() {
        return new String[]{VERSION};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doVersion() {
        String currentVersion = Optional.ofNullable(Version.class.getPackage()).map(Package::getImplementationVersion).filter(Objects::nonNull).orElse(null);
        try {
            URL url = URI.create("https://search.maven.org/solrsearch/select?q=+g:io.jooby+a:jooby&start=0&rows=1").toURL();
            URLConnection connection = url.openConnection();
            try (InputStreamReader in = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                Semver semver;
                Map json = Cli.gson.fromJson((Reader)in, Map.class);
                Map response = (Map)json.get("response");
                List docs = (List)response.get("docs");
                Map jooby = (Map)docs.get(0);
                String publicVersion = (String)jooby.get("latestVersion");
                if (currentVersion != null && (semver = new Semver(currentVersion)).isGreaterThan(publicVersion)) {
                    String string = currentVersion;
                    return string;
                }
                String string = publicVersion;
                return string;
            }
        }
        catch (Exception x) {
            if (currentVersion != null) return currentVersion;
            throw new IllegalStateException("Jooby version not found", x);
        }
    }
}

