/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.cli.CliContext;
import io.jooby.cli.Cmd;
import io.jooby.cli.CreateCmd;
import io.jooby.cli.ExitCmd;
import io.jooby.cli.SetCmd;
import io.jooby.cli.Version;
import io.jooby.internal.cli.CommandContextImpl;
import io.jooby.internal.cli.JLineCompleter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="jooby", versionProvider=Version.class, mixinStandardHelpOptions=true, version={"Print version information"})
public class Cli
extends Cmd {
    public static final Gson gson = new GsonBuilder().create();
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Unmatched
    private List<String> args;

    @Override
    public void run(@NonNull CliContext ctx) {
        List args = this.args.stream().filter(Objects::nonNull).map(String::trim).filter(it -> it.length() > 0).collect(Collectors.toList());
        if (args.size() > 0) {
            String arg = (String)args.get(0);
            if ("-h".equals(arg) || "--help".equals(arg)) {
                ctx.println(this.spec.commandLine().getUsageMessage());
            } else if ("-V".equalsIgnoreCase(arg) || "--version".equals(arg)) {
                ctx.println(ctx.getVersion());
            } else {
                ctx.println("Unknown command or option(s): " + args.stream().collect(Collectors.joining(" ")));
                ctx.println("  " + ctx);
                ctx.println(this.spec.commandLine().getUsageMessage());
            }
        } else {
            ctx.println(this.spec.commandLine().getUsageMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        Cli jooby = new Cli();
        CommandLine cmd = new CommandLine((Object)jooby).addSubcommand((Object)new CreateCmd()).addSubcommand((Object)new ExitCmd()).addSubcommand((Object)new SetCmd());
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)new JLineCompleter(cmd.getCommandSpec())).parser((Parser)new DefaultParser()).build();
        CommandContextImpl context = new CommandContextImpl(reader, Version.VERSION);
        jooby.setContext(context);
        cmd.getSubcommands().values().stream().map(CommandLine::getCommand).filter(Cmd.class::isInstance).map(Cmd.class::cast).forEach(command -> command.setContext(context));
        if (args.length <= 0) {
            String prompt = "jooby> ";
            while (true) {
                try {
                    while (true) {
                        String line = reader.readLine(prompt);
                        ParsedLine pl = reader.getParser().parse(line, 0);
                        String[] arguments = pl.words().toArray(new String[0]);
                        cmd.execute(arguments);
                    }
                }
                catch (UserInterruptException e) {
                    System.exit(0);
                    continue;
                }
                catch (EndOfFileException e) {
                    return;
                }
                break;
            }
        }
        cmd.execute(args);
    }
}

