/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.ebean;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.ebean.Database;
import io.ebean.Transaction;
import io.jooby.Route;
import io.jooby.ServiceKey;
import java.io.Serializable;

public class TransactionalRequest
implements Route.Filter {
    private ServiceKey<Database> key;
    private boolean enabledByDefault = true;

    public TransactionalRequest(@NonNull String name) {
        this.key = ServiceKey.key(Database.class, (String)name);
    }

    public TransactionalRequest() {
        this.key = ServiceKey.key(Database.class);
    }

    public TransactionalRequest enabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            if (ctx.getRoute().isTransactional(this.enabledByDefault)) {
                Database db = (Database)ctx.require(this.key);
                try (Transaction transaction = db.beginTransaction();){
                    Object result = next.apply(ctx);
                    transaction.commit();
                    Object object = result;
                    return object;
                }
            }
            return next.apply(ctx);
        };
    }
}

