/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jooby.SneakyThrows;
import io.jooby.internal.openapi.OperationExt;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class OpenAPIExt
extends OpenAPI {
    @JsonIgnore
    private List<OperationExt> operations = Collections.emptyList();
    @JsonIgnore
    private String source;

    public static OpenAPIExt create(Path basedir, ClassLoader classLoader, String templateName) {
        try {
            Path path = basedir.resolve("conf").resolve(templateName);
            if (Files.exists(path, new LinkOption[0])) {
                return (OpenAPIExt)((Object)Yaml.mapper().readValue(path.toFile(), OpenAPIExt.class));
            }
            URL resource = classLoader.getResource(templateName);
            if (resource != null) {
                return (OpenAPIExt)((Object)Yaml.mapper().readValue(resource, OpenAPIExt.class));
            }
            return new OpenAPIExt();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public List<OperationExt> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationExt> operations) {
        this.operations = operations;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String classname) {
        this.source = classname;
    }
}

