/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.FileUpload;
import io.jooby.internal.openapi.InsnSupport;
import io.jooby.internal.openapi.ParameterExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.Signature;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.Handle;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.InsnNode;
import io.jooby.internal.openapi.asm.tree.IntInsnNode;
import io.jooby.internal.openapi.asm.tree.InvokeDynamicInsnNode;
import io.jooby.internal.openapi.asm.tree.LdcInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RequestParser {
    public static Optional<RequestBodyExt> requestBody(ParserContext ctx, MethodNode node) {
        List instructions = StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.instructions.iterator(), 16), false).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(i -> i.owner.equals(TypeFactory.CONTEXT.getInternalName()) && (RequestParser.isFormLike(i) || i.name.equals("body"))).collect(Collectors.toList());
        if (instructions.size() == 0) {
            return Optional.empty();
        }
        if (instructions.size() == 1) {
            MethodInsnNode i2 = (MethodInsnNode)instructions.get(0);
            Signature signature = Signature.create(i2);
            RequestBodyExt body = new RequestBodyExt();
            if (RequestParser.isMultipart(i2)) {
                body.setContentType("multipart/form-data");
            } else if (RequestParser.isForm(i2)) {
                body.setContentType("application/x-www-form-urlencoded");
            }
            if (signature.matches(Class.class)) {
                String bodyType = RequestParser.valueType(i2).orElseThrow(() -> new IllegalStateException("Type not found, for: " + InsnSupport.toString(i2)));
                body.setJavaType(bodyType);
            } else if (RequestParser.isFormLike(i2)) {
                RequestParser.formFields(ctx, Collections.singletonList(i2)).ifPresent(arg_0 -> ((RequestBodyExt)body).setContent(arg_0));
            } else {
                RequestParser.argumentValue(i2.name, i2).set(body);
            }
            return Optional.of(body);
        }
        RequestBodyExt body = new RequestBodyExt();
        RequestParser.formFields(ctx, instructions.stream().filter(RequestParser::isFormLike).collect(Collectors.toList())).ifPresent(arg_0 -> ((RequestBodyExt)body).setContent(arg_0));
        boolean multipart = instructions.stream().anyMatch(RequestParser::isMultipart);
        if (multipart) {
            body.setContentType("multipart/form-data");
        } else {
            body.setContentType("application/x-www-form-urlencoded");
        }
        return Optional.of(body);
    }

    private static Optional<Content> formFields(ParserContext ctx, List<MethodInsnNode> nodes) {
        LinkedHashMap properties = new LinkedHashMap();
        for (MethodInsnNode methodInsnNode : nodes) {
            RequestParser.formField(ctx, methodInsnNode, properties::put);
        }
        if (properties.size() > 0) {
            ArrayList<String> required = new ArrayList<String>();
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                List mark = ((Schema)entry.getValue()).getRequired();
                if (mark == null || !mark.contains("true")) continue;
                ((Schema)entry.getValue()).setRequired(null);
                required.add(name);
            }
            ObjectSchema objectSchema = new ObjectSchema();
            objectSchema.setProperties(properties);
            if (required.size() > 0) {
                objectSchema.setRequired(required);
            }
            MediaType mediaType = new MediaType();
            mediaType.setSchema((Schema)objectSchema);
            boolean multipart = nodes.stream().anyMatch(RequestParser::isMultipart);
            String contentType = multipart ? "multipart/form-data" : "application/x-www-form-urlencoded";
            Content content = new Content();
            content.addMediaType(contentType, mediaType);
            return Optional.of(content);
        }
        return Optional.empty();
    }

    private static boolean isFormLike(MethodInsnNode field) {
        return RequestParser.isForm(field) || RequestParser.isMultipart(field);
    }

    private static boolean isForm(MethodInsnNode field) {
        return field.name.equals("form");
    }

    private static boolean isMultipart(MethodInsnNode field) {
        return field.name.equals("multipart") || RequestParser.isFileUpload(field);
    }

    private static boolean isFileUpload(MethodInsnNode field) {
        return field.name.equals("file") || field.name.equals("files");
    }

    private static void formField(ParserContext ctx, MethodInsnNode node, BiConsumer<String, Schema> consumer) {
        String name = RequestParser.argumentName(node);
        WebArgument argument = RequestParser.argumentValue(name, node);
        Optional.ofNullable(argument.javaType).map(ctx::schema).filter(Objects::nonNull).ifPresent(schema -> consumer.accept(name, argument.set((Schema)schema)));
    }

    public static List<ParameterExt> parameters(MethodNode node) {
        List nodes = StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.instructions.iterator(), 16), false).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(i -> i.owner.equals("io/jooby/Context")).collect(Collectors.toList());
        ArrayList<ParameterExt> args = new ArrayList<ParameterExt>();
        for (MethodInsnNode methodInsnNode : nodes) {
            String scope;
            Signature signature = Signature.create(methodInsnNode);
            ParameterExt argument = new ParameterExt();
            switch (scope = signature.getMethod()) {
                case "header": 
                case "cookie": 
                case "path": 
                case "query": {
                    argument.setIn(scope);
                    if (signature.matches(String.class)) {
                        argument.setName(RequestParser.argumentName(methodInsnNode));
                        RequestParser.argumentValue(argument.getName(), methodInsnNode).set(argument);
                        break;
                    }
                    if (!signature.matches(Class.class)) break;
                    argument.setName(signature.getMethod());
                    RequestParser.contextObjectToType(argument, methodInsnNode);
                }
            }
            if (argument.getJavaType() == null) continue;
            args.add(argument);
        }
        return args;
    }

    private static void contextObjectToType(ParameterExt argument, MethodInsnNode node) {
        String type = RequestParser.valueType(node).orElseThrow(() -> new IllegalStateException("Parameter type not found, for: " + argument.getName()));
        argument.setJavaType(type);
        argument.setSingle(false);
    }

    private static Optional<String> valueType(MethodInsnNode node) {
        return InsnSupport.prev(node).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).filter(i -> i.cst instanceof Type).map(i -> (Type)i.cst).map(Type::getClassName);
    }

    private static WebArgument argumentValue(String argumentName, MethodInsnNode node) {
        MethodInsnNode convertCall = InsnSupport.next(node).filter(RequestParser.valueOwner()).map(MethodInsnNode.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Parameter type not found, for: " + argumentName));
        Signature convert = Signature.create(convertCall);
        WebArgument argument = new WebArgument();
        if (convert.matches("value") || convert.matches("valueOrNull") || convert.getMethod().endsWith("Value")) {
            argument.javaType = Type.getReturnType(convertCall.desc).getClassName();
            if (convert.matches("valueOrNull")) {
                argument.required = false;
            } else if (convert.getParameterCount() == 0) {
                argument.required = true;
            } else {
                argument.required = false;
                argument.defaultValue = RequestParser.argumentDefaultValue(convertCall.getPrevious());
            }
        } else if (convert.matches("toList")) {
            argument.javaType = RequestParser.toGenericOne(convertCall, convert, List.class);
            argument.required = false;
        } else if (convert.matches("toSet")) {
            argument.javaType = RequestParser.toGenericOne(convertCall, convert, Set.class);
            argument.required = false;
        } else if (convert.matches("toOptional")) {
            argument.javaType = RequestParser.toGenericOne(convertCall, convert, Optional.class);
            argument.required = false;
            InsnSupport.next(convertCall).filter(RequestParser.optionalOrElse()).findFirst().map(MethodInsnNode.class::cast).ifPresent(elseCall -> InsnSupport.prev(elseCall).filter(RequestParser.valueToOptional()).findFirst().map(MethodInsnNode.class::cast).ifPresent(toOptional -> {
                if (toOptional.equals(convertCall)) {
                    argument.defaultValue = RequestParser.argumentDefaultValue(elseCall.getPrevious());
                }
            }));
        } else if (convert.matches("to")) {
            Type toType = InsnSupport.prev(convertCall).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).map(e -> (Type)e.cst).orElseThrow(() -> new IllegalStateException("Parameter type not found: " + InsnSupport.toString(convertCall)));
            argument.javaType = toType.getClassName();
        } else if (convert.matches("toEnum")) {
            Type toType = InsnSupport.prev(convertCall).filter(InvokeDynamicInsnNode.class::isInstance).map(InvokeDynamicInsnNode.class::cast).filter(i -> i.name.equals("tryApply")).findFirst().map(i -> (Handle)i.bsmArgs[1]).map(h -> Type.getObjectType(h.getOwner())).orElseThrow(() -> new IllegalStateException("Parameter type not found: " + InsnSupport.toString(convertCall)));
            argument.javaType = toType.getClassName();
            argument.required = true;
        } else if (convert.matches("toMap")) {
            argument.javaType = "java.util.Map<java.lang.String,java.lang.String>";
            argument.required = true;
            argument.single = false;
        } else if (convert.matches("toMultimap")) {
            argument.javaType = "java.util.Map<java.lang.String,java.util.List<java.lang.String>>";
            argument.required = true;
            argument.single = false;
        } else if (convert.matches("file")) {
            argument.javaType = FileUpload.class.getName();
            argument.required = true;
        } else if (convert.matches("files")) {
            argument.javaType = "java.util.List<" + FileUpload.class.getName() + ">";
            argument.required = true;
        } else {
            throw new IllegalStateException("Unhandled parameter type: " + convert);
        }
        return argument;
    }

    private static Predicate<AbstractInsnNode> valueOwner() {
        return e -> {
            if (e instanceof MethodInsnNode) {
                return ((MethodInsnNode)e).owner.equals("io/jooby/Value") || ((MethodInsnNode)e).owner.equals("io/jooby/ValueNode") || ((MethodInsnNode)e).owner.equals("io/jooby/Body") || ((MethodInsnNode)e).owner.equals("io/jooby/Context") && RequestParser.isFileUpload((MethodInsnNode)e);
            }
            return false;
        };
    }

    private static Predicate<AbstractInsnNode> optionalOrElse() {
        return e -> e instanceof MethodInsnNode && ((MethodInsnNode)e).owner.equals("java/util/Optional") && ((MethodInsnNode)e).name.equals("orElse");
    }

    private static Predicate<AbstractInsnNode> valueToOptional() {
        return RequestParser.valueOwner().and(e -> ((MethodInsnNode)e).name.equals("toOptional"));
    }

    private static String toGenericOne(MethodInsnNode node, Signature signature, Class collectionType) {
        StringBuilder type = new StringBuilder(collectionType.getName());
        type.append("<");
        if (signature.matches(Class.class)) {
            String itemType = InsnSupport.prev(node).filter(LdcInsnNode.class::isInstance).findFirst().map(e -> ((Type)((LdcInsnNode)e).cst).getClassName()).orElse(String.class.getName());
            type.append(itemType);
        } else {
            type.append(String.class.getName());
        }
        type.append(">");
        return type.toString();
    }

    private static Object argumentDefaultValue(AbstractInsnNode n) {
        if (n instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)n).cst;
            if (cst instanceof Type) {
                return ((Type)cst).getClassName();
            }
            return cst;
        }
        if (n instanceof InsnNode) {
            InsnNode insn = (InsnNode)n;
            switch (insn.getOpcode()) {
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 4;
                }
                case 8: {
                    return 5;
                }
                case 9: {
                    return 0L;
                }
                case 10: {
                    return 1L;
                }
                case 11: {
                    return Float.valueOf(0.0f);
                }
                case 12: {
                    return Float.valueOf(1.0f);
                }
                case 13: {
                    return Float.valueOf(2.0f);
                }
                case 14: {
                    return 0.0;
                }
                case 15: {
                    return 1.0;
                }
                case 2: {
                    return -1;
                }
                case 1: {
                    return null;
                }
            }
        } else if (n instanceof IntInsnNode) {
            return ((IntInsnNode)n).operand;
        }
        return null;
    }

    private static String argumentName(MethodInsnNode node) {
        return InsnSupport.prev(node).filter(LdcInsnNode.class::isInstance).map(it -> ((LdcInsnNode)it).cst.toString()).findFirst().orElseThrow(() -> new IllegalStateException("Parameter name not found: " + InsnSupport.toString(node)));
    }

    private static class WebArgument {
        String javaType;
        Boolean required;
        Boolean single;
        Object defaultValue;

        private WebArgument() {
        }

        public void set(ParameterExt argument) {
            Optional.ofNullable(this.javaType).ifPresent(argument::setJavaType);
            Optional.ofNullable(this.required).ifPresent(arg_0 -> ((ParameterExt)argument).setRequired(arg_0));
            Optional.ofNullable(this.single).ifPresent(argument::setSingle);
            Optional.ofNullable(this.defaultValue).ifPresent(argument::setDefaultValue);
        }

        public void set(RequestBodyExt argument) {
            Optional.ofNullable(this.javaType).ifPresent(argument::setJavaType);
            Optional.ofNullable(this.required).ifPresent(arg_0 -> ((RequestBodyExt)argument).setRequired(arg_0));
        }

        public Schema set(Schema argument) {
            Optional.ofNullable(this.required).filter(Boolean.TRUE::equals).ifPresent(value -> argument.setRequired(Arrays.asList("true")));
            Optional.ofNullable(this.defaultValue).ifPresent(arg_0 -> ((Schema)argument).setDefault(arg_0));
            return argument;
        }
    }
}

