/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.jooby.internal.openapi.AsmUtils;
import io.jooby.internal.openapi.OpenAPIExt;
import io.jooby.internal.openapi.OperationExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.ResponseExt;
import io.jooby.internal.openapi.StatusCodeParser;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AnnotationNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.Extensions;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.Servers;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OpenAPIParser {
    public static void parse(ParserContext ctx, OpenAPIExt openapi) {
        Type type = Type.getObjectType(openapi.getSource().replace(".", "/"));
        ClassNode node = ctx.classNode(type);
        AsmUtils.findAnnotationByType(node.visibleAnnotations, OpenAPIDefinition.class).stream().findFirst().ifPresent(a -> OpenAPIParser.definition(openapi, a));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, Servers.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(it -> OpenAPIParser.servers(it, arg_0 -> ((OpenAPIExt)openapi).addServersItem(arg_0)));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, Server.class).stream().findFirst().ifPresent(it -> OpenAPIParser.servers(Collections.singletonList(AsmUtils.toMap(it)), arg_0 -> ((OpenAPIExt)openapi).addServersItem(arg_0)));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, SecurityRequirements.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(it -> OpenAPIParser.securityRequirements(it, arg_0 -> ((OpenAPIExt)openapi).addSecurityItem(arg_0)));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().findFirst().ifPresent(it -> OpenAPIParser.securityRequirements(Collections.singletonList(AsmUtils.toMap(it)), arg_0 -> ((OpenAPIExt)openapi).addSecurityItem(arg_0)));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, SecuritySchemes.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(it -> OpenAPIParser.securitySchemas(openapi, it));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, SecurityScheme.class).stream().findFirst().ifPresent(it -> OpenAPIParser.securitySchemas(openapi, Collections.singletonList(AsmUtils.toMap(it))));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, Extensions.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(it -> OpenAPIParser.extensions(it, (arg_0, arg_1) -> ((OpenAPIExt)openapi).addExtension(arg_0, arg_1)));
        AsmUtils.findAnnotationByType(node.visibleAnnotations, Extension.class).stream().findFirst().ifPresent(it -> OpenAPIParser.extensions(Collections.singletonList(AsmUtils.toMap(it)), (arg_0, arg_1) -> ((OpenAPIExt)openapi).addExtension(arg_0, arg_1)));
    }

    private static void securitySchemas(OpenAPIExt openapi, List<Map<String, Object>> schemas) {
        for (Map<String, Object> annotation : schemas) {
            Components components = openapi.getComponents();
            if (components == null) {
                components = new Components();
                openapi.setComponents(components);
            }
            io.swagger.v3.oas.models.security.SecurityScheme scheme = new io.swagger.v3.oas.models.security.SecurityScheme();
            AsmUtils.enumValue(annotation, "type", v -> scheme.setType(SecurityScheme.Type.valueOf((String)v)));
            AsmUtils.stringValue(annotation, "name", arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).setName(arg_0));
            AsmUtils.stringValue(annotation, "description", arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).setDescription(arg_0));
            AsmUtils.enumValue(annotation, "in", v -> scheme.setIn(SecurityScheme.In.valueOf((String)v)));
            AsmUtils.stringValue(annotation, "scheme", arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).scheme(arg_0));
            AsmUtils.stringValue(annotation, "bearerFormat", arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).bearerFormat(arg_0));
            AsmUtils.stringValue(annotation, "openIdConnectUrl", arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).openIdConnectUrl(arg_0));
            AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).addExtension(arg_0, arg_1)));
            AsmUtils.annotationValue(annotation, "flows", flows -> OpenAPIParser.flows(flows, arg_0 -> ((io.swagger.v3.oas.models.security.SecurityScheme)scheme).flows(arg_0)));
            components.addSecuritySchemes(scheme.getName(), scheme);
        }
    }

    private static void flows(Map<String, Object> annotation, Consumer<OAuthFlows> consumer) {
        OAuthFlows flows = new OAuthFlows();
        AsmUtils.annotationValue(annotation, "implicit", value -> OpenAPIParser.flow(value, arg_0 -> ((OAuthFlows)flows).implicit(arg_0)));
        AsmUtils.annotationValue(annotation, "password", value -> OpenAPIParser.flow(value, arg_0 -> ((OAuthFlows)flows).password(arg_0)));
        AsmUtils.annotationValue(annotation, "clientCredentials", value -> OpenAPIParser.flow(value, arg_0 -> ((OAuthFlows)flows).clientCredentials(arg_0)));
        AsmUtils.annotationValue(annotation, "authorizationCode", value -> OpenAPIParser.flow(value, arg_0 -> ((OAuthFlows)flows).authorizationCode(arg_0)));
        AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((OAuthFlows)flows).addExtension(arg_0, arg_1)));
        consumer.accept(flows);
    }

    private static void flow(Map<String, Object> annotation, Consumer<OAuthFlow> consumer) {
        OAuthFlow flow = new OAuthFlow();
        AsmUtils.stringValue(annotation, "authorizationUrl", arg_0 -> ((OAuthFlow)flow).authorizationUrl(arg_0));
        AsmUtils.stringValue(annotation, "tokenUrl", arg_0 -> ((OAuthFlow)flow).tokenUrl(arg_0));
        AsmUtils.stringValue(annotation, "refreshUrl", arg_0 -> ((OAuthFlow)flow).refreshUrl(arg_0));
        AsmUtils.annotationList(annotation, "scopes", values -> {
            Scopes scopes = new Scopes();
            for (Map value : values) {
                AsmUtils.stringValue((Map<String, Object>)value, "name", name -> {
                    String description = AsmUtils.stringValueOrNull(value, "description");
                    scopes.put(name, (Object)description);
                });
            }
            flow.setScopes(scopes);
        });
        AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((OAuthFlow)flow).addExtension(arg_0, arg_1)));
        consumer.accept(flow);
    }

    public static void parse(ParserContext ctx, OperationExt operation) {
        MethodNode method = operation.getNode();
        List<AnnotationNode> annotations = operation.getAllAnnotations();
        AsmUtils.findAnnotationByType(annotations, Tags.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(a -> OpenAPIParser.tags(a, operation::addTag));
        AsmUtils.findAnnotationByType(annotations, Tag.class).stream().findFirst().ifPresent(it -> OpenAPIParser.tags(Collections.singletonList(AsmUtils.toMap(it)), operation::addTag));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Operation.class).stream().findFirst().ifPresent(a -> OpenAPIParser.operation(ctx, operation, AsmUtils.toMap(a)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Parameters.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(a -> OpenAPIParser.parameters(ctx, operation, a));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Parameter.class).stream().findFirst().ifPresent(a -> OpenAPIParser.parameters(ctx, operation, Collections.singletonList(AsmUtils.toMap(a))));
        if (method.visibleParameterAnnotations != null) {
            for (List<AnnotationNode> paramAnnotations : method.visibleParameterAnnotations) {
                AsmUtils.findAnnotationByType(paramAnnotations, RequestBody.class).stream().findFirst().ifPresent(a -> OpenAPIParser.requestBody(ctx, operation, AsmUtils.toMap(a)));
            }
        }
        AsmUtils.findAnnotationByType(method.visibleAnnotations, RequestBody.class).stream().findFirst().ifPresent(a -> OpenAPIParser.requestBody(ctx, operation, AsmUtils.toMap(a)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, ApiResponse.class).stream().findFirst().ifPresent(a -> OpenAPIParser.operationResponse(ctx, operation, AsmUtils.toMap(a)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, SecurityRequirements.class).stream().map(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value")).forEach(a -> OpenAPIParser.securityRequirements(a, arg_0 -> ((OperationExt)operation).addSecurityItem(arg_0)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, io.swagger.v3.oas.annotations.security.SecurityRequirement.class).stream().findFirst().ifPresent(a -> OpenAPIParser.securityRequirements(Collections.singletonList(AsmUtils.toMap(a)), arg_0 -> ((OperationExt)operation).addSecurityItem(arg_0)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, ApiResponses.class).stream().flatMap(it -> AsmUtils.annotationList(AsmUtils.toMap(it), "value").stream()).forEach(a -> OpenAPIParser.operationResponse(ctx, operation, a));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, ApiResponse.class).stream().findFirst().ifPresent(a -> OpenAPIParser.operationResponse(ctx, operation, AsmUtils.toMap(a)));
        OpenAPIParser.checkDefaultResponse(operation);
    }

    private static void servers(List<Map<String, Object>> serverList, Consumer<io.swagger.v3.oas.models.servers.Server> consumer) {
        for (Map<String, Object> serverMap : serverList) {
            io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server();
            AsmUtils.stringValue(serverMap, "url", arg_0 -> ((io.swagger.v3.oas.models.servers.Server)server).setUrl(arg_0));
            AsmUtils.stringValue(serverMap, "description", arg_0 -> ((io.swagger.v3.oas.models.servers.Server)server).setDescription(arg_0));
            AsmUtils.annotationList(serverMap, "variables", variableList -> {
                ServerVariables variables = new ServerVariables();
                for (Map varMap : variableList) {
                    ServerVariable variable = new ServerVariable();
                    AsmUtils.stringValue((Map<String, Object>)varMap, "description", arg_0 -> ((ServerVariable)variable).setDescription(arg_0));
                    AsmUtils.stringValue((Map<String, Object>)varMap, "defaultValue", arg_0 -> ((ServerVariable)variable).setDefault(arg_0));
                    AsmUtils.stringList(varMap, "allowableValues", arg_0 -> ((ServerVariable)variable).setEnum(arg_0));
                    AsmUtils.annotationList(varMap, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((ServerVariable)variable).addExtension(arg_0, arg_1)));
                    variables.put((Object)((String)varMap.get("name")), (Object)variable);
                }
                server.setVariables(variables);
            });
            consumer.accept(server);
        }
    }

    private static void definition(OpenAPIExt openapi, AnnotationNode node) {
        Map<String, Object> annotation = AsmUtils.toMap(node);
        AsmUtils.annotationValue(annotation, "info", info -> OpenAPIParser.info(info, arg_0 -> ((OpenAPIExt)openapi).setInfo(arg_0)));
        AsmUtils.annotationList(annotation, "tags", tags -> OpenAPIParser.tags(tags, arg_0 -> ((OpenAPIExt)openapi).addTagsItem(arg_0)));
        AsmUtils.annotationList(annotation, "servers", servers -> OpenAPIParser.servers(servers, arg_0 -> ((OpenAPIExt)openapi).addServersItem(arg_0)));
        AsmUtils.annotationList(annotation, "security", security -> OpenAPIParser.securityRequirements(security, arg_0 -> ((OpenAPIExt)openapi).addSecurityItem(arg_0)));
        AsmUtils.annotationList(annotation, "extensions", extensionList -> OpenAPIParser.extensions(extensionList, (arg_0, arg_1) -> ((OpenAPIExt)openapi).addExtension(arg_0, arg_1)));
        AsmUtils.annotationValue(annotation, "externalDocs", value -> OpenAPIParser.externalDocumentation(value, arg_0 -> ((OpenAPIExt)openapi).setExternalDocs(arg_0)));
    }

    private static void info(Map<String, Object> annotation, Consumer<Info> consumer) {
        Info info = new Info();
        AsmUtils.stringValue(annotation, "title", arg_0 -> ((Info)info).setTitle(arg_0));
        AsmUtils.stringValue(annotation, "description", arg_0 -> ((Info)info).setDescription(arg_0));
        AsmUtils.stringValue(annotation, "termsOfService", arg_0 -> ((Info)info).setTermsOfService(arg_0));
        AsmUtils.stringValue(annotation, "version", arg_0 -> ((Info)info).setVersion(arg_0));
        AsmUtils.annotationValue(annotation, "contact", map -> {
            Contact contact = new Contact();
            AsmUtils.stringValue((Map<String, Object>)map, "name", arg_0 -> ((Contact)contact).setName(arg_0));
            AsmUtils.stringValue((Map<String, Object>)map, "url", arg_0 -> ((Contact)contact).setUrl(arg_0));
            AsmUtils.stringValue((Map<String, Object>)map, "email", arg_0 -> ((Contact)contact).setEmail(arg_0));
            info.setContact(contact);
        });
        AsmUtils.annotationValue(annotation, "license", map -> {
            License license = new License();
            AsmUtils.stringValue((Map<String, Object>)map, "name", arg_0 -> ((License)license).setName(arg_0));
            AsmUtils.stringValue((Map<String, Object>)map, "url", arg_0 -> ((License)license).setUrl(arg_0));
            info.setLicense(license);
        });
        AsmUtils.annotationList(annotation, "extensions", extensions -> OpenAPIParser.extensions(extensions, (arg_0, arg_1) -> ((Info)info).addExtension(arg_0, arg_1)));
        consumer.accept(info);
    }

    private static void tags(List<Map<String, Object>> tags, Consumer<io.swagger.v3.oas.models.tags.Tag> consumer) {
        for (Map<String, Object> tagMap : tags) {
            io.swagger.v3.oas.models.tags.Tag tag = new io.swagger.v3.oas.models.tags.Tag();
            AsmUtils.stringValue(tagMap, "name", arg_0 -> ((io.swagger.v3.oas.models.tags.Tag)tag).setName(arg_0));
            AsmUtils.stringValue(tagMap, "description", arg_0 -> ((io.swagger.v3.oas.models.tags.Tag)tag).setDescription(arg_0));
            AsmUtils.annotationList(tagMap, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((io.swagger.v3.oas.models.tags.Tag)tag).addExtension(arg_0, arg_1)));
            AsmUtils.annotationValue(tagMap, "externalDocs", value -> OpenAPIParser.externalDocumentation(value, arg_0 -> ((io.swagger.v3.oas.models.tags.Tag)tag).setExternalDocs(arg_0)));
            consumer.accept(tag);
        }
    }

    private static void checkDefaultResponse(OperationExt operation) {
        if (!operation.getResponseCodes().contains("200") && operation.getResponses().keySet().stream().filter(StatusCodeParser::isSuccessCode).count() > 1L) {
            operation.getResponses().remove((Object)"200");
        }
    }

    private static void operation(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        AsmUtils.stringValue(annotation, "operationId", arg_0 -> ((OperationExt)operation).setOperationId(arg_0));
        AsmUtils.stringValue(annotation, "method", operation::setMethod);
        AsmUtils.boolValue(annotation, "deprecated", arg_0 -> ((OperationExt)operation).setDeprecated(arg_0));
        AsmUtils.boolValue(annotation, "hidden", operation::setHidden);
        AsmUtils.stringValue(annotation, "summary", arg_0 -> ((OperationExt)operation).setSummary(arg_0));
        AsmUtils.stringValue(annotation, "description", arg_0 -> ((OperationExt)operation).setDescription(arg_0));
        AsmUtils.stringList(annotation, "tags", tags -> tags.forEach(arg_0 -> ((OperationExt)operation).addTagsItem(arg_0)));
        AsmUtils.annotationList(annotation, "servers", servers -> OpenAPIParser.servers(servers, arg_0 -> ((OperationExt)operation).addServersItem(arg_0)));
        AsmUtils.annotationList(annotation, "security", values -> OpenAPIParser.securityRequirements(values, arg_0 -> ((OperationExt)operation).addSecurityItem(arg_0)));
        AsmUtils.annotationList(annotation, "parameters", values -> OpenAPIParser.parameters(ctx, operation, values));
        AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((OperationExt)operation).addExtension(arg_0, arg_1)));
        AsmUtils.annotationValue(annotation, "externalDocs", value -> OpenAPIParser.externalDocumentation(value, arg_0 -> ((OperationExt)operation).setExternalDocs(arg_0)));
        OpenAPIParser.requestBody(ctx, operation, AsmUtils.toMap((AnnotationNode)annotation.get("requestBody")));
        OpenAPIParser.responses(ctx, operation, annotation);
    }

    private static void securityRequirements(List<Map<String, Object>> securityRequirements, Consumer<SecurityRequirement> consumer) {
        for (Map<String, Object> securityMap : securityRequirements) {
            String name = (String)securityMap.get("name");
            List scopes = securityMap.getOrDefault("scopes", Collections.emptyList());
            SecurityRequirement requirement = new SecurityRequirement();
            requirement.addList(name, scopes);
            consumer.accept(requirement);
        }
    }

    private static void requestBody(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        if (annotation.size() > 0) {
            RequestBodyExt requestBody = operation.getRequestBody();
            if (requestBody == null) {
                requestBody = new RequestBodyExt();
                operation.setRequestBody(requestBody);
            }
            AsmUtils.stringValue(annotation, "description", arg_0 -> ((RequestBodyExt)requestBody).setDescription(arg_0));
            AsmUtils.boolValue(annotation, "required", arg_0 -> ((RequestBodyExt)requestBody).setRequired(arg_0));
            String defaultMediaType = operation.getConsumes().stream().findFirst().orElse("application/json");
            OpenAPIParser.content(ctx, defaultMediaType, annotation).ifPresent(arg_0 -> ((RequestBodyExt)requestBody).setContent(arg_0));
        }
    }

    @Operation(parameters={@Parameter(name="p", description="des", in=ParameterIn.COOKIE, required=false, deprecated=true, allowEmptyValue=true, allowReserved=false, hidden=false, explode=Explode.TRUE, ref="Pet")})
    private static void parameters(ParserContext ctx, OperationExt operation, List<Map<String, Object>> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter;
            Map<String, Object> parameterMap = parameters.get(i);
            String name = (String)parameterMap.get("name");
            if (name != null) {
                int index = i;
                parameter = operation.getParameters().stream().filter(it -> it.getName().equals(name)).findFirst().orElseGet(() -> operation.getParameter(index));
            } else {
                parameter = operation.getParameter(i);
            }
            if (parameter == null) {
                throw new IllegalArgumentException("Parameter not found: " + name + " at  position: " + i + " for annotation: " + parameterMap);
            }
            Optional.ofNullable(name).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setName(arg_0));
            AsmUtils.stringValue(parameterMap, "description", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setDescription(arg_0));
            AsmUtils.enumValue(parameterMap, "in", in -> parameter.setIn(in.toLowerCase()));
            AsmUtils.boolValue(parameterMap, "required", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setRequired(arg_0));
            AsmUtils.boolValue(parameterMap, "deprecated", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setDeprecated(arg_0));
            AsmUtils.boolValue(parameterMap, "allowEmptyValue", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setAllowEmptyValue(arg_0));
            AsmUtils.boolValue(parameterMap, "allowReserved", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setAllowReserved(arg_0));
            AsmUtils.enumValue(parameterMap, "explode", value -> parameter.setExample((Object)Boolean.valueOf(value)));
            AsmUtils.stringValue(parameterMap, "ref", ref -> parameter.set$ref(RefUtils.constructRef((String)ref)));
            OpenAPIParser.arrayOrSchema(ctx, parameterMap).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setSchema(arg_0));
            OpenAPIParser.examples(parameterMap, arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExample(arg_0), arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExamples(arg_0));
            AsmUtils.annotationList(parameterMap, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1)));
        }
    }

    private static void examples(Map<String, Object> annotation, Consumer<String> exampleConsumer, Consumer<Map<String, Example>> consumer) {
        LinkedHashMap examples = new LinkedHashMap();
        AsmUtils.stringValue(annotation, "example", exampleConsumer);
        AsmUtils.annotationList(annotation, "examples", values -> {
            for (Map e : values) {
                Example example = new Example();
                AsmUtils.stringValue((Map<String, Object>)e, "summary", arg_0 -> ((Example)example).setSummary(arg_0));
                AsmUtils.stringValue((Map<String, Object>)e, "description", arg_0 -> ((Example)example).setDescription(arg_0));
                AsmUtils.stringValue((Map<String, Object>)e, "value", arg_0 -> ((Example)example).setValue(arg_0));
                AsmUtils.stringValue((Map<String, Object>)e, "externalValue", arg_0 -> ((Example)example).setExternalValue(arg_0));
                String key = (String)((Object)e.getOrDefault("name", "example" + examples.size()));
                examples.put(key, example);
            }
            consumer.accept(examples);
        });
    }

    private static void responses(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        AsmUtils.annotationList(annotation, "responses", values -> values.forEach(it -> OpenAPIParser.operationResponse(ctx, operation, it)));
    }

    @Operation(responses={@ApiResponse})
    private static void operationResponse(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        String code = AsmUtils.stringValue(annotation, "responseCode", "200").replace("default", "200");
        ResponseExt response = operation.addResponse(code);
        AsmUtils.annotationList(annotation, "headers", values -> {
            LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
            for (Map value : values) {
                Header header = new Header();
                String name = AsmUtils.stringValue(value, "name");
                AsmUtils.stringValue((Map<String, Object>)value, "description", arg_0 -> ((Header)header).setDescription(arg_0));
                Schema schema = AsmUtils.annotationValue(value, "schema").map(schemaMap -> OpenAPIParser.toSchema(ctx, schemaMap).orElseGet(StringSchema::new)).orElseGet(StringSchema::new);
                header.setSchema(schema);
                headers.put(name, header);
            }
            response.setHeaders(headers);
        });
        AsmUtils.stringValue(annotation, "description", arg_0 -> ((ResponseExt)response).setDescription(arg_0));
        String defaultMediaType = operation.getProduces().stream().findFirst().orElse("application/json");
        OpenAPIParser.content(ctx, defaultMediaType, annotation).ifPresent(arg_0 -> ((ResponseExt)response).setContent(arg_0));
        AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((ResponseExt)response).addExtension(arg_0, arg_1)));
    }

    @Operation(responses={@ApiResponse(content={@io.swagger.v3.oas.annotations.media.Content})})
    private static Optional<Content> content(ParserContext ctx, String defaultMediaType, Map<String, Object> annotation) {
        Content content = new Content();
        AsmUtils.annotationList(annotation, "content", values -> {
            for (Map value : values) {
                OpenAPIParser.mediaType(ctx, content, defaultMediaType, value);
            }
        });
        return content.isEmpty() ? Optional.empty() : Optional.of(content);
    }

    @ApiResponse(content={@io.swagger.v3.oas.annotations.media.Content(mediaType="media/type", array=@io.swagger.v3.oas.annotations.media.ArraySchema(schema=@io.swagger.v3.oas.annotations.media.Schema(implementation=String.class)))})
    private static void mediaType(ParserContext ctx, Content content, String defaultMediaType, Map<String, Object> contentMap) {
        if (contentMap == null || contentMap.isEmpty()) {
            return;
        }
        String mediaType = AsmUtils.stringValue(contentMap, "mediaType", defaultMediaType);
        Optional<Schema> schema = OpenAPIParser.arrayOrSchema(ctx, contentMap);
        MediaType mediaTypeObject = new MediaType();
        schema.ifPresent(arg_0 -> ((MediaType)mediaTypeObject).setSchema(arg_0));
        content.addMediaType(mediaType, mediaTypeObject);
    }

    private static Optional<Schema> arrayOrSchema(ParserContext ctx, Map<String, Object> annotation) {
        AnnotationNode e = (AnnotationNode)annotation.get("array");
        if (e != null) {
            return OpenAPIParser.toArraySchema(ctx, AsmUtils.toMap(e));
        }
        return OpenAPIParser.toSchema(ctx, AsmUtils.toMap((AnnotationNode)annotation.get("schema")));
    }

    private static Optional<Schema> toArraySchema(ParserContext ctx, Map<String, Object> annotation) {
        ArraySchema arraySchema = new ArraySchema();
        AsmUtils.boolValue(annotation, "uniqueItems", arg_0 -> ((ArraySchema)arraySchema).setUniqueItems(arg_0));
        AsmUtils.intValue(annotation, "maxItems", arg_0 -> ((ArraySchema)arraySchema).setMaxItems(arg_0));
        AsmUtils.intValue(annotation, "minItems", arg_0 -> ((ArraySchema)arraySchema).setMinItems(arg_0));
        if (annotation.containsKey("arraySchema")) {
            OpenAPIParser.toArraySchema(ctx, AsmUtils.toMap((AnnotationNode)annotation.get("arraySchema"))).ifPresent(arg_0 -> ((ArraySchema)arraySchema).setItems(arg_0));
        } else {
            Type implementation;
            Map<String, Object> schemaAnnotation = AsmUtils.toMap((AnnotationNode)annotation.get("schema"));
            if (schemaAnnotation.containsKey("implementation") && (implementation = (Type)schemaAnnotation.get("implementation")).getClassName().equals("byte")) {
                schemaAnnotation.put("implementation", Type.getObjectType("[B"));
                return OpenAPIParser.toSchema(ctx, schemaAnnotation);
            }
            OpenAPIParser.toSchema(ctx, schemaAnnotation).ifPresent(arg_0 -> ((ArraySchema)arraySchema).setItems(arg_0));
        }
        return Optional.of(arraySchema);
    }

    private static Optional<Schema> toSchema(ParserContext ctx, Map<String, Object> annotation) {
        Schema schema;
        HashMap schemaMap = new HashMap();
        OpenAPIParser.schemaType(ctx, annotation, "implementation", schemaMap::put);
        OpenAPIParser.schemaType(ctx, annotation, "not", schemaMap::put);
        OpenAPIParser.schemaType(ctx, annotation, "anyOf", schemaMap::put);
        OpenAPIParser.schemaType(ctx, annotation, "oneOf", schemaMap::put);
        OpenAPIParser.schemaType(ctx, annotation, "allOf", schemaMap::put);
        if (schemaMap.isEmpty()) {
            return Optional.empty();
        }
        List schemas = (List)schemaMap.get("implementation");
        if (schemas == null || schemas.isEmpty()) {
            ComposedSchema composedSchema = new ComposedSchema();
            Optional.ofNullable((List)schemaMap.get("anyOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).anyOf(arg_0));
            Optional.ofNullable((List)schemaMap.get("oneOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).oneOf(arg_0));
            Optional.ofNullable((List)schemaMap.get("allOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).allOf(arg_0));
            schema = composedSchema;
        } else {
            schema = (Schema)schemas.get(0);
        }
        Optional.ofNullable((List)schemaMap.get("not")).ifPresent(not -> schema.not((Schema)not.get(0)));
        Optional.ofNullable(annotation.get("nullable")).filter(nullable -> nullable instanceof Boolean).ifPresent(nullable -> schema.setNullable((Boolean)nullable));
        AsmUtils.annotationValue(annotation, "externalDocs", value -> OpenAPIParser.externalDocumentation(value, arg_0 -> ((Schema)schema).setExternalDocs(arg_0)));
        return Optional.of(schema);
    }

    private static void schemaType(ParserContext ctx, Map<String, Object> schema, String property, BiConsumer<String, List<Schema>> consumer) {
        Object value = schema.get(property);
        List<Object> types = value instanceof List ? (List)value : (value instanceof Type ? Collections.singletonList((Type)value) : Collections.emptyList());
        if (types.size() > 0) {
            List schemas = types.stream().map(ctx::schema).filter(Objects::nonNull).collect(Collectors.toList());
            consumer.accept(property, schemas);
        }
    }

    private static void externalDocumentation(Map<String, Object> annotation, Consumer<ExternalDocumentation> consumer) {
        if (!annotation.isEmpty()) {
            ExternalDocumentation doc = new ExternalDocumentation();
            AsmUtils.stringValue(annotation, "description", arg_0 -> ((ExternalDocumentation)doc).setDescription(arg_0));
            AsmUtils.stringValue(annotation, "url", arg_0 -> ((ExternalDocumentation)doc).setUrl(arg_0));
            AsmUtils.annotationList(annotation, "extensions", values -> OpenAPIParser.extensions(values, (arg_0, arg_1) -> ((ExternalDocumentation)doc).addExtension(arg_0, arg_1)));
            consumer.accept(doc);
        }
    }

    private static void extensions(List<Map<String, Object>> extensions, BiConsumer<String, Object> consumer) {
        OpenAPIParser.extensionMap(extensions, map -> {
            for (Map.Entry e : map.entrySet()) {
                consumer.accept((String)e.getKey(), e.getValue());
            }
        });
    }

    private static void extensionMap(List<Map<String, Object>> extensions, Consumer<Map<String, Object>> consumer) {
        HashMap map = new HashMap();
        for (Map<String, Object> extension : extensions) {
            String name = AsmUtils.stringValueOrNull(extension, "name");
            AsmUtils.annotationList(extension, "properties", propertyList -> {
                for (Map property : propertyList) {
                    LinkedHashMap<String, LinkedHashMap<String, String>> scope;
                    String key = AsmUtils.stringValue(property, "name");
                    if (name != null) {
                        String scopeKey = OpenAPIParser.prepend("x-", name);
                        Object raw = map.get(scopeKey);
                        if (raw instanceof Map) {
                            scope = (Map)raw;
                        } else {
                            scope = new LinkedHashMap<String, LinkedHashMap<String, String>>();
                            map.put(scopeKey, scope);
                        }
                    } else {
                        key = OpenAPIParser.prepend("x-", key);
                        scope = map;
                    }
                    Object value = AsmUtils.stringValue(property, "value");
                    if (AsmUtils.boolValue(property, "parseValue")) {
                        value = OpenAPIParser.parse((String)value);
                    }
                    scope.put(key, (LinkedHashMap<String, String>)value);
                }
            });
        }
        consumer.accept(map);
    }

    private static String prepend(String prefix, String key) {
        return key.startsWith(prefix) ? key : prefix + key;
    }

    private static Object parse(String value) {
        try {
            return Json.mapper().reader().withFeatures(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, JsonParser.Feature.ALLOW_SINGLE_QUOTES}).readTree(value);
        }
        catch (JsonProcessingException e) {
            return value;
        }
    }
}

