/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.rxjava3;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ReactiveSupport;
import io.jooby.Reified;
import io.jooby.ResultHandler;
import io.jooby.Route;
import io.jooby.internal.rxjava3.RxObserver;
import io.jooby.internal.rxjava3.RxSubscriber;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;

public class Reactivex
implements ResultHandler {
    private static final Route.Filter RX = new Route.Filter(){

        @NonNull
        public Route.Handler apply(@NonNull Route.Handler next) {
            return (Route.Handler & Serializable)ctx -> {
                Object result = next.apply(ctx);
                if (result instanceof Flowable) {
                    Flowable flow = (Flowable)result;
                    flow.subscribe(FlowAdapters.toSubscriber((Flow.Subscriber)ReactiveSupport.newSubscriber((Context)ctx)));
                } else if (result instanceof Single) {
                    Single single = (Single)result;
                    single.subscribe((SingleObserver)new RxSubscriber(ctx));
                } else if (result instanceof Observable) {
                    Observable observable = (Observable)result;
                    observable.subscribe((Observer)new RxObserver(ReactiveSupport.newSubscriber((Context)ctx)));
                } else if (result instanceof Maybe) {
                    Maybe maybe = (Maybe)result;
                    maybe.subscribe((MaybeObserver)new RxSubscriber(ctx));
                }
                return result;
            };
        }

        public void setRoute(Route route) {
            route.setReactive(true);
        }
    };

    public static Route.Filter rx() {
        return RX;
    }

    public boolean matches(@NonNull Type type) {
        Class raw = Reified.get((Type)type).getRawType();
        return Single.class.isAssignableFrom(raw) || Flowable.class.isAssignableFrom(raw) || Maybe.class.isAssignableFrom(raw) || Observable.class.isAssignableFrom(raw);
    }

    @NonNull
    public Route.Filter create() {
        return RX;
    }

    public boolean isReactive() {
        return true;
    }
}

